/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.spi;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class GetterFile {
    private static final String GETTER_EXTENSION = ".getter";
    private final File file;
    private final String name;
    private final Set<String> keys;

    public static List<GetterFile> load(File gettersDirectory) throws IOException {
        if (gettersDirectory.exists()) {
            return Files.walk(gettersDirectory.toPath(), 1, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toFile().getName().endsWith(GETTER_EXTENSION)).map(Path::toFile).map(f -> new GetterFile(f.getParentFile(), f.getName())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public GetterFile(File gettersDirectory, String name) {
        this.file = new File(gettersDirectory, name);
        this.name = name;
        this.keys = new TreeSet<String>();
    }

    public synchronized void addKey(String key) {
        this.keys.add(key);
    }

    public synchronized void addKeys(Collection<String> result) {
        this.keys.addAll(result);
    }

    public void load() throws IOException {
        if (this.file.exists()) {
            List<String> existingKeys = Files.readAllLines(this.file.toPath(), StandardCharsets.UTF_8);
            this.keys.addAll(existingKeys);
        }
    }

    public void store() throws IOException {
        if (!this.file.getParentFile().exists()) {
            Files.createDirectories(this.file.getParentFile().toPath(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (String key : this.keys) {
                writer.write(key);
                writer.newLine();
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public void delete() {
        try {
            Files.deleteIfExists(this.file.toPath());
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't delete getter file " + this.file, e);
        }
    }

    public boolean isNotEmpty() {
        return !this.keys.isEmpty();
    }
}

