/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.openapi;

import io.swagger.codegen.v3.generators.openapi.OpenAPIGenerator;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIYamlGenerator
extends OpenAPIGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIYamlGenerator.class);
    public static final String OPENAPI_FILENAME_DEFAULT_YAML = "openapi.yaml";
    private String outputFile = "openapi.yaml";

    @Override
    public String getName() {
        return "openapi-yaml";
    }

    @Override
    public String getHelp() {
        return "Creates a static openapi.yaml file.";
    }

    @Override
    protected String getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        try {
            String outputString = this.flattenSpec ? Yaml.pretty((Object)openAPI) : Yaml.pretty((Object)this.unflattenedOpenAPI);
            String outputFile = this.outputFolder + File.separator + this.outputFile;
            FileUtils.writeStringToFile((File)new File(outputFile), (String)outputString);
            LOGGER.debug("wrote file to " + outputFile);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

