/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.securityscheme;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.security.SecuritySchemeImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.oauth.OAuthReader;
import io.smallrye.openapi.runtime.io.securityscheme.SecuritySchemeConstant;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class SecuritySchemeReader {
    private static final Map<String, SecurityScheme.Type> SECURITY_SCHEME_TYPE_LOOKUP;
    private static final Map<String, SecurityScheme.In> SECURITY_SCHEME_IN_LOOKUP;

    private SecuritySchemeReader() {
    }

    public static Map<String, SecurityScheme> readSecuritySchemes(AnnotationScannerContext context, AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.annotationsMap("@SecurityScheme");
        LinkedHashMap<String, SecurityScheme> securitySchemes = new LinkedHashMap<String, SecurityScheme>();
        for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
            String name = (String)context.annotations().value(nested, "securitySchemeName");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            securitySchemes.put(name, SecuritySchemeReader.readSecurityScheme(context, nested));
        }
        return securitySchemes;
    }

    public static Map<String, SecurityScheme> readSecuritySchemes(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, SecurityScheme> securitySchemes = new LinkedHashMap<String, SecurityScheme>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            securitySchemes.put(fieldName, SecuritySchemeReader.readSecurityScheme(childNode));
        }
        return securitySchemes;
    }

    public static SecurityScheme readSecurityScheme(AnnotationScannerContext context, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@SecurityScheme");
        SecuritySchemeImpl securityScheme = new SecuritySchemeImpl();
        securityScheme.setType(context.annotations().enumValue(annotationInstance, "type", SecurityScheme.Type.class));
        securityScheme.setDescription((String)context.annotations().value(annotationInstance, "description"));
        securityScheme.setName((String)context.annotations().value(annotationInstance, "apiKeyName"));
        securityScheme.setIn(context.annotations().enumValue(annotationInstance, "in", SecurityScheme.In.class));
        securityScheme.setScheme((String)context.annotations().value(annotationInstance, "scheme"));
        securityScheme.setBearerFormat((String)context.annotations().value(annotationInstance, "bearerFormat"));
        securityScheme.setFlows(OAuthReader.readOAuthFlows(context, annotationInstance.value("flows")));
        securityScheme.setOpenIdConnectUrl((String)context.annotations().value(annotationInstance, "openIdConnectUrl"));
        securityScheme.setRef(JandexUtil.refValue(annotationInstance, JandexUtil.RefType.SECURITY_SCHEME));
        securityScheme.setExtensions(ExtensionReader.readExtensions(context, annotationInstance));
        return securityScheme;
    }

    private static SecurityScheme readSecurityScheme(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        SecuritySchemeImpl model = new SecuritySchemeImpl();
        model.setRef(JsonUtil.stringProperty(node, "$ref"));
        model.setType(SecuritySchemeReader.readSecuritySchemeType(node.get("type")));
        model.setDescription(JsonUtil.stringProperty(node, "description"));
        model.setName(JsonUtil.stringProperty(node, "name"));
        model.setIn(SecuritySchemeReader.readSecuritySchemeIn(node.get("in")));
        model.setScheme(JsonUtil.stringProperty(node, "scheme"));
        model.setBearerFormat(JsonUtil.stringProperty(node, "bearerFormat"));
        model.setFlows(OAuthReader.readOAuthFlows(node.get("flows")));
        model.setOpenIdConnectUrl(JsonUtil.stringProperty(node, "openIdConnectUrl"));
        ExtensionReader.readExtensions(node, model);
        return model;
    }

    private static SecurityScheme.Type readSecuritySchemeType(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return SECURITY_SCHEME_TYPE_LOOKUP.get(node.asText());
    }

    private static SecurityScheme.In readSecuritySchemeIn(JsonNode node) {
        if (node == null || !node.isTextual()) {
            return null;
        }
        return SECURITY_SCHEME_IN_LOOKUP.get(node.asText());
    }

    public static List<AnnotationInstance> getSecuritySchemeAnnotations(AnnotationScannerContext context, AnnotationTarget target) {
        return context.annotations().getRepeatableAnnotation(target, SecuritySchemeConstant.DOTNAME_SECURITY_SCHEME, SecuritySchemeConstant.TYPE_SECURITY_SCHEMES);
    }

    public static String getSecuritySchemeName(AnnotationScannerContext context, AnnotationInstance annotation) {
        return (String)context.annotations().value(annotation, "securitySchemeName");
    }

    static {
        SecurityScheme.In[] securitySchemeIns;
        SecurityScheme.Type[] securitySchemeTypes;
        SECURITY_SCHEME_TYPE_LOOKUP = new LinkedHashMap<String, SecurityScheme.Type>();
        SECURITY_SCHEME_IN_LOOKUP = new LinkedHashMap<String, SecurityScheme.In>();
        for (SecurityScheme.Type type : securitySchemeTypes = SecurityScheme.Type.values()) {
            SECURITY_SCHEME_TYPE_LOOKUP.put(type.toString(), type);
        }
        for (SecurityScheme.In type : securitySchemeIns = SecurityScheme.In.values()) {
            SECURITY_SCHEME_IN_LOOKUP.put(type.toString(), type);
        }
    }
}

