package io.vertx.mutiny.uritemplate;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import io.vertx.core.json.JsonObject;

/**
 * Holds a set of name/value pairs where each value can be a <code>String</code> or a <code>List<String></code> or a <code>Map<String, String></code>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.uritemplate.Variables original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.uritemplate.Variables.class)
public class Variables implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<Variables> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Variables((io.vertx.uritemplate.Variables) obj),
    Variables::getDelegate
  );

  private final io.vertx.uritemplate.Variables delegate;
  
  public Variables(io.vertx.uritemplate.Variables delegate) {
    this.delegate = delegate;
  }

  public Variables(Object delegate) {
    this.delegate = (io.vertx.uritemplate.Variables)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Variables() {
    this.delegate = null;
  }

  @Override
  public io.vertx.uritemplate.Variables getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Variables that = (Variables) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return an empty instance
   */
  public static io.vertx.mutiny.uritemplate.Variables variables() { 
    io.vertx.mutiny.uritemplate.Variables ret = io.vertx.mutiny.uritemplate.Variables.newInstance((io.vertx.uritemplate.Variables)io.vertx.uritemplate.Variables.variables());
    return ret;
  }

  /**
   * @param json the json that populates the returned variables
   * @return an instance populated from a JSON object
   */
  public static io.vertx.mutiny.uritemplate.Variables variables(JsonObject json) { 
    io.vertx.mutiny.uritemplate.Variables ret = io.vertx.mutiny.uritemplate.Variables.newInstance((io.vertx.uritemplate.Variables)io.vertx.uritemplate.Variables.variables(json));
    return ret;
  }

  /**
   * @param name the variable name
   * @param value the variable value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.uritemplate.Variables set(String name, String value) { 
    delegate.set(name, value);
    return this;
  }

  /**
   * @param name the variable name
   * @param value the variable value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.uritemplate.Variables set(String name, List<String> value) { 
    delegate.set(name, value);
    return this;
  }

  /**
   * @param name the variable name
   * @param value the variable value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.uritemplate.Variables set(String name, java.util.Map<String, String> value) { 
    delegate.set(name, value);
    return this;
  }

  /**
   * @param json 
   * @return the instance of Variables to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.uritemplate.Variables setAll(JsonObject json) { 
    delegate.setAll(json);
    return this;
  }

  /**
   * @param json the json that populates the returned variables
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.uritemplate.Variables addAll(JsonObject json) { 
    delegate.addAll(json);
    return this;
  }

  @Fluent
  public io.vertx.mutiny.uritemplate.Variables clear() { 
    delegate.clear();
    return this;
  }

  /**
   * @return the set of variable names
   */
  public Set<String> names() { 
    Set<String> ret = delegate.names();
    return ret;
  }

  /**
   * @param name 
   * @return the value of the variable <code>name</code>
   */
  public java.lang.Object get(String name) { 
    java.lang.Object ret = (Object) delegate.get(name);
    return ret;
  }

  /**
   * @param name 
   * @return the single value of the variable <code>name</code>
   */
  public String getSingle(String name) { 
    String ret = delegate.getSingle(name);
    return ret;
  }

  /**
   * @param name 
   * @return the list value of the variable <code>name</code>
   */
  public List<String> getList(String name) { 
    List<String> ret = delegate.getList(name);
    return ret;
  }

  /**
   * @param name 
   * @return the map value of the variable <code>name</code>
   */
  public java.util.Map<String, String> getMap(String name) { 
    java.util.Map<String, String> ret = delegate.getMap(name);
    return ret;
  }

  public static  Variables newInstance(io.vertx.uritemplate.Variables arg) {
    return arg != null ? new Variables(arg) : null;
  }

}
