package io.vertx.mutiny.core.shareddata;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * An asynchronous counter that can be used to across the cluster to maintain a consistent count.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.Counter original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.shareddata.Counter.class)
public class Counter {

  public static final io.smallrye.mutiny.vertx.TypeArg<Counter> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Counter((io.vertx.core.shareddata.Counter) obj),
    Counter::getDelegate
  );

  private final io.vertx.core.shareddata.Counter delegate;
  
  public Counter(io.vertx.core.shareddata.Counter delegate) {
    this.delegate = delegate;
  }

  public Counter(Object delegate) {
    this.delegate = (io.vertx.core.shareddata.Counter)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Counter() {
    this.delegate = null;
  }

  public io.vertx.core.shareddata.Counter getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Counter that = (Counter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Get the current value of the counter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<Long> get() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.get(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.Counter#get}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Long instance produced by the operation.
   */
  public Long getAndAwait() { 
    return (Long) get().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.Counter#get} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.Counter#get}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.Counter#get} but you don't need to compose it with other operations.
   */
  public void getAndForget() { 
    get().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Increment the counter atomically and return the new count
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<Long> incrementAndGet() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.incrementAndGet(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.Counter#incrementAndGet}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Long instance produced by the operation.
   */
  public Long incrementAndGetAndAwait() { 
    return (Long) incrementAndGet().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.Counter#incrementAndGet} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.Counter#incrementAndGet}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.Counter#incrementAndGet} but you don't need to compose it with other operations.
   */
  public void incrementAndGetAndForget() { 
    incrementAndGet().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<Long> getAndIncrement() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getAndIncrement(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.Counter#getAndIncrement}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Long instance produced by the operation.
   */
  public Long getAndIncrementAndAwait() { 
    return (Long) getAndIncrement().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.Counter#getAndIncrement} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.Counter#getAndIncrement}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.Counter#getAndIncrement} but you don't need to compose it with other operations.
   */
  public void getAndIncrementAndForget() { 
    getAndIncrement().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Decrement the counter atomically and return the new count
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<Long> decrementAndGet() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.decrementAndGet(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.Counter#decrementAndGet}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Long instance produced by the operation.
   */
  public Long decrementAndGetAndAwait() { 
    return (Long) decrementAndGet().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.Counter#decrementAndGet} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.Counter#decrementAndGet}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.Counter#decrementAndGet} but you don't need to compose it with other operations.
   */
  public void decrementAndGetAndForget() { 
    decrementAndGet().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Add the value to the counter atomically and return the new count
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param value the value to add
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<Long> addAndGet(long value) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.addAndGet(value, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.Counter#addAndGet(long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param value the value to add
   * @return the Long instance produced by the operation.
   */
  public Long addAndGetAndAwait(long value) { 
    return (Long) addAndGet(value).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.Counter#addAndGet(long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.Counter#addAndGet(long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.Counter#addAndGet(long)} but you don't need to compose it with other operations.
   * @param value the value to add
   */
  public void addAndGetAndForget(long value) { 
    addAndGet(value).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param value the value to add
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<Long> getAndAdd(long value) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getAndAdd(value, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.Counter#getAndAdd(long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param value the value to add
   * @return the Long instance produced by the operation.
   */
  public Long getAndAddAndAwait(long value) { 
    return (Long) getAndAdd(value).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.Counter#getAndAdd(long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.Counter#getAndAdd(long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.Counter#getAndAdd(long)} but you don't need to compose it with other operations.
   * @param value the value to add
   */
  public void getAndAddAndForget(long value) { 
    getAndAdd(value).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param expected the expected value
   * @param value the new value
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<Boolean> compareAndSet(long expected, long value) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.compareAndSet(expected, value, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.shareddata.Counter#compareAndSet(long,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param expected the expected value
   * @param value the new value
   * @return the Boolean instance produced by the operation.
   */
  public Boolean compareAndSetAndAwait(long expected, long value) { 
    return (Boolean) compareAndSet(expected, value).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.shareddata.Counter#compareAndSet(long,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.shareddata.Counter#compareAndSet(long,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.shareddata.Counter#compareAndSet(long,long)} but you don't need to compose it with other operations.
   * @param expected the expected value
   * @param value the new value
   */
  public void compareAndSetAndForget(long expected, long value) { 
    compareAndSet(expected, value).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  Counter newInstance(io.vertx.core.shareddata.Counter arg) {
    return arg != null ? new Counter(arg) : null;
  }

}
