package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;

/**
 * An HTTP/2 frame.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpFrame original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpFrame.class)
public class HttpFrame {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpFrame> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpFrame((io.vertx.core.http.HttpFrame) obj),
    HttpFrame::getDelegate
  );

  private final io.vertx.core.http.HttpFrame delegate;
  
  public HttpFrame(io.vertx.core.http.HttpFrame delegate) {
    this.delegate = delegate;
  }

  public HttpFrame(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpFrame)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpFrame() {
    this.delegate = null;
  }

  public io.vertx.core.http.HttpFrame getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpFrame that = (HttpFrame) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the 8-bit type of the frame
   */
  public int type() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.type();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the 8-bit flags specific to the frame
   */
  public int flags() { 
    if (cached_1 != null) {
      return cached_1;
    }
    int ret = delegate.flags();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the frame payload
   */
  public io.vertx.mutiny.core.buffer.Buffer payload() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.payload());
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private java.lang.Integer cached_1;
  private io.vertx.mutiny.core.buffer.Buffer cached_2;
  public static  HttpFrame newInstance(io.vertx.core.http.HttpFrame arg) {
    return arg != null ? new HttpFrame(arg) : null;
  }

}
