package io.vertx.mutiny.core.eventbus;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * An event bus consumer object representing a stream of message to an {@link io.vertx.mutiny.core.eventbus.EventBus} address that can
 * be read from.
 * <p>
 * The {@link io.vertx.mutiny.core.eventbus.EventBus#consumer} or {@link io.vertx.mutiny.core.eventbus.EventBus#localConsumer}
 * creates a new consumer, the returned consumer is not yet registered against the event bus. Registration
 * is effective after the {@link io.vertx.mutiny.core.eventbus.MessageConsumer#handler} method is invoked.<p>
 *
 * The consumer is unregistered from the event bus using the {@link io.vertx.mutiny.core.eventbus.MessageConsumer#unregister} method or by calling the
 * {@link io.vertx.mutiny.core.eventbus.MessageConsumer#handler} with a null value..
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageConsumer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.eventbus.MessageConsumer.class)
public class MessageConsumer<T> implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.eventbus.Message<T>> {

  public static final io.smallrye.mutiny.vertx.TypeArg<MessageConsumer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MessageConsumer((io.vertx.core.eventbus.MessageConsumer) obj),
    MessageConsumer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageConsumer<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public MessageConsumer(io.vertx.core.eventbus.MessageConsumer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public MessageConsumer(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.eventbus.MessageConsumer)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public MessageConsumer(io.vertx.core.eventbus.MessageConsumer delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MessageConsumer() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.eventbus.MessageConsumer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageConsumer that = (MessageConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.eventbus.Message<T>> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.eventbus.Message<T>> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), new TypeArg<io.vertx.mutiny.core.eventbus.Message<T>>(o0 -> io.vertx.mutiny.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)o0, __typeArg_0), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.eventbus.Message<T>> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.eventbus.Message<T>> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.eventbus.Message<T>> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @Fluent
  private io.vertx.mutiny.core.eventbus.MessageConsumer<T> __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  @Fluent
  private io.vertx.mutiny.core.eventbus.MessageConsumer<T> __handler(Handler<io.vertx.mutiny.core.eventbus.Message<T>> handler) { 
    delegate.handler(new Handler<io.vertx.core.eventbus.Message<T>>() {
      public void handle(io.vertx.core.eventbus.Message<T> event) {
        handler.handle(io.vertx.mutiny.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)event, __typeArg_0));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> handler(java.util.function.Consumer<io.vertx.mutiny.core.eventbus.Message<T>> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  @Fluent
  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.core.eventbus.MessageConsumer<T> __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  /**
   * @return a read stream for the body of the message stream.
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> bodyStream() { 
    io.vertx.mutiny.core.streams.ReadStream<T> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.bodyStream(), __typeArg_0);
    return ret;
  }

  /**
   * @return true if the current consumer is registered
   */
  public boolean isRegistered() { 
    boolean ret = delegate.isRegistered();
    return ret;
  }

  /**
   * @return The address the handler was registered with.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * @param maxBufferedMessages the maximum number of messages that can be buffered
   * @return this registration
   */
  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> setMaxBufferedMessages(int maxBufferedMessages) { 
    io.vertx.mutiny.core.eventbus.MessageConsumer<T> ret = io.vertx.mutiny.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.setMaxBufferedMessages(maxBufferedMessages), __typeArg_0);
    return ret;
  }

  /**
   * @return the maximum number of messages that can be buffered when this stream is paused
   */
  public int getMaxBufferedMessages() { 
    int ret = delegate.getMaxBufferedMessages();
    return ret;
  }

  /**
   * Optional method which can be called to indicate when the registration has been propagated across the cluster.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> completionHandler() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.completionHandler(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.eventbus.MessageConsumer#completionHandler}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void completionHandlerAndAwait() { 
    return (Void) completionHandler().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.eventbus.MessageConsumer#completionHandler} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.eventbus.MessageConsumer#completionHandler}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.eventbus.MessageConsumer#completionHandler} but you don't need to compose it with other operations.
   */
  public void completionHandlerAndForget() { 
    completionHandler().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Unregisters the handler which created this registration
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> unregister() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.unregister(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.eventbus.MessageConsumer#unregister}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void unregisterAndAwait() { 
    return (Void) unregister().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.eventbus.MessageConsumer#unregister} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.eventbus.MessageConsumer#unregister}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.eventbus.MessageConsumer#unregister} but you don't need to compose it with other operations.
   */
  public void unregisterAndForget() { 
    unregister().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  private Multi<io.vertx.mutiny.core.eventbus.Message<T>> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.core.eventbus.Message<T>> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.eventbus.Message<T>, io.vertx.mutiny.core.eventbus.Message<T>> conv = io.vertx.mutiny.core.eventbus.Message::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.eventbus.Message<T>> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.core.eventbus.Message<T>> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static <T>MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg) {
    return arg != null ? new MessageConsumer<T>(arg) : null;
  }


  public static <T>MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageConsumer<T>(arg, __typeArg_T) : null;
  }

}
