package io.vertx.mutiny.core.eventbus;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Represents a message that is received from the event bus in a handler.
 * <p>
 * Messages have a {@link io.vertx.mutiny.core.eventbus.Message#body}, which can be null, and also {@link io.vertx.mutiny.core.eventbus.Message#headers}, which can be empty.
 * <p>
 * If the message was sent specifying a reply handler, it can be replied to using {@link io.vertx.mutiny.core.eventbus.Message#reply}.
 * <p>
 * If you want to notify the sender that processing failed, then {@link io.vertx.mutiny.core.eventbus.Message#fail} can be called.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.Message original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.eventbus.Message.class)
public class Message<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<Message> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Message((io.vertx.core.eventbus.Message) obj),
    Message::getDelegate
  );

  private final io.vertx.core.eventbus.Message<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public Message(io.vertx.core.eventbus.Message delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public Message(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.eventbus.Message)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public Message(io.vertx.core.eventbus.Message delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Message() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.eventbus.Message getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Message that = (Message) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return 
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * @return the body, or null.
   */
  public T body() { 
    if (cached_0 != null) {
      return cached_0;
    }
    T ret = (T)__typeArg_0.wrap(delegate.body());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the reply address, or null, if message was sent without a reply handler.
   */
  public String replyAddress() { 
    String ret = delegate.replyAddress();
    return ret;
  }

  /**
   * @return true if this is a send.
   */
  public boolean isSend() { 
    boolean ret = delegate.isSend();
    return ret;
  }

  /**
   * @param message the message to reply with.
   */
  public void reply(java.lang.Object message) { 
    delegate.reply(message);
  }

  /**
   * @param message the reply message
   * @param options the delivery options
   */
  public void reply(java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) { 
    delegate.reply(message, options);
  }

  /**
   * Reply to this message, specifying a <code>replyHandler</code> for the reply - i.e.
   * to receive the reply to the reply.
   * <p>
   * If the message was sent specifying a reply handler, that handler will be
   * called when it has received a reply. If the message wasn't sent specifying a receipt handler
   * this method does nothing.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param message the message to reply with.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public <R> io.smallrye.mutiny.Uni<io.vertx.mutiny.core.eventbus.Message<R>> replyAndRequest(java.lang.Object message) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(replyHandler -> {
        delegate.replyAndRequest(message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)ar.result(), TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.eventbus.Message#replyAndRequest(Object)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param message the message to reply with.
   * @return the Message<R> instance produced by the operation.
   */
  public <R> io.vertx.mutiny.core.eventbus.Message<R> replyAndRequestAndAwait(java.lang.Object message) { 
    return (io.vertx.mutiny.core.eventbus.Message<R>) replyAndRequest(message).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.eventbus.Message#replyAndRequest(Object)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.eventbus.Message#replyAndRequest(Object)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.eventbus.Message#replyAndRequest(Object)} but you don't need to compose it with other operations.
   * @param message the message to reply with.
   */
  public <R> void replyAndRequestAndForget(java.lang.Object message) { 
    replyAndRequest(message).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.eventbus.Message#replyAndRequest} but specifying <code>options</code> that can be used
   * to configure the delivery.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public <R> io.smallrye.mutiny.Uni<io.vertx.mutiny.core.eventbus.Message<R>> replyAndRequest(java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(replyHandler -> {
        delegate.replyAndRequest(message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)ar.result(), TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.eventbus.Message#replyAndRequest(Object,DeliveryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @return the Message<R> instance produced by the operation.
   */
  public <R> io.vertx.mutiny.core.eventbus.Message<R> replyAndRequestAndAwait(java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) { 
    return (io.vertx.mutiny.core.eventbus.Message<R>) replyAndRequest(message, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.eventbus.Message#replyAndRequest(Object,DeliveryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.eventbus.Message#replyAndRequest(Object,DeliveryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.eventbus.Message#replyAndRequest(Object,DeliveryOptions)} but you don't need to compose it with other operations.
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   */
  public <R> void replyAndRequestAndForget(java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) { 
    replyAndRequest(message, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param failureCode A failure code to pass back to the sender
   * @param message A message to pass back to the sender
   */
  public void fail(int failureCode, String message) { 
    delegate.fail(failureCode, message);
  }

  private T cached_0;
  public static <T>Message<T> newInstance(io.vertx.core.eventbus.Message arg) {
    return arg != null ? new Message<T>(arg) : null;
  }


  public static <T>Message<T> newInstance(io.vertx.core.eventbus.Message arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new Message<T>(arg, __typeArg_T) : null;
  }

}
