package io.vertx.mutiny.core.http;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import javax.net.ssl.SSLSession;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a client-side WebSocket.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocket original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.WebSocket.class)
public class WebSocket implements io.vertx.mutiny.core.http.WebSocketBase {

  public static final io.smallrye.mutiny.vertx.TypeArg<WebSocket> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WebSocket((io.vertx.core.http.WebSocket) obj),
    WebSocket::getDelegate
  );

  private final io.vertx.core.http.WebSocket delegate;
  
  public WebSocket(io.vertx.core.http.WebSocket delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  WebSocket() {    this.delegate = null;
  }

  public io.vertx.core.http.WebSocket getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebSocket that = (WebSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  private io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> subscriber;

  public synchronized io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.mutiny.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::getDelegate;
      subscriber = io.smallrye.mutiny.vertx.MutinyHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  /**
   * @param data 
   * @param handler 
   */
  private void __end(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(data, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) end(data).await().indefinitely();
  }

  /**
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance(delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * @return the binary handler id
   */
  public String binaryHandlerID() { 
    String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * @return 
   */
  public String textHandlerID() { 
    String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * @return 
   */
  public String subProtocol() { 
    String ret = delegate.subProtocol();
    return ret;
  }

  /**
   * @return 
   */
  public Short closeStatusCode() { 
    Short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * @return 
   */
  public String closeReason() { 
    String ret = delegate.closeReason();
    return ret;
  }

  /**
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance(delegate.headers());
    return ret;
  }

  /**
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writePing(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writePing(data.getDelegate());
    return this;
  }

  /**
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writePong(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writePong(data.getDelegate());
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.WebSocketBase __textMessageHandler(Handler<String> handler) { 
    delegate.textMessageHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase textMessageHandler(Consumer<String> handler) {
    return __textMessageHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.WebSocketBase __binaryMessageHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.binaryMessageHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase binaryMessageHandler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __binaryMessageHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.WebSocketBase __pongHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.pongHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase pongHandler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __pongHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler 
   */
  private void __end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Calls {@link io.vertx.mutiny.core.http.WebSocketBase#close}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * @param handler 
   */
  private void __close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * @param statusCode 
   * @param handler 
   */
  private void __close(short statusCode, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statusCode 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close(short statusCode) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(statusCode, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statusCode 
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait(short statusCode) { 
    return (Void) close(statusCode).await().indefinitely();
  }

  /**
   * @param statusCode 
   * @param reason 
   * @param handler 
   */
  private void __close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, reason, handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statusCode 
   * @param reason 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close(short statusCode, String reason) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(statusCode, reason, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statusCode 
   * @param reason 
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait(short statusCode, String reason) { 
    return (Void) close(statusCode, reason).await().indefinitely();
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.mutiny.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  private io.vertx.mutiny.core.http.WebSocket __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.http.WebSocket __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket handler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.mutiny.core.http.WebSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private io.vertx.mutiny.core.http.WebSocket __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  private io.vertx.mutiny.core.http.WebSocket __write(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

  public Uni<Void> write(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(data, handler);
    });
  }

  public Void writeAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) write(data).await().indefinitely();
  }

  public io.vertx.mutiny.core.http.WebSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  private io.vertx.mutiny.core.http.WebSocket __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket drainHandler(Consumer<Void> handler) {
    return __drainHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.http.WebSocket __writeFrame(io.vertx.mutiny.core.http.WebSocketFrame frame, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFrame(frame.getDelegate(), handler);
    return this;
  }

  public Uni<Void> writeFrame(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeFrame(frame, handler);
    });
  }

  public Void writeFrameAndAwait(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    return (Void) writeFrame(frame).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.WebSocket __writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalTextFrame(text, handler);
    return this;
  }

  public Uni<Void> writeFinalTextFrame(String text) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeFinalTextFrame(text, handler);
    });
  }

  public Void writeFinalTextFrameAndAwait(String text) { 
    return (Void) writeFinalTextFrame(text).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.WebSocket __writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
    return this;
  }

  public Uni<Void> writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeFinalBinaryFrame(data, handler);
    });
  }

  public Void writeFinalBinaryFrameAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) writeFinalBinaryFrame(data).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.WebSocket __writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeBinaryMessage(data.getDelegate(), handler);
    return this;
  }

  public Uni<Void> writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeBinaryMessage(data, handler);
    });
  }

  public Void writeBinaryMessageAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) writeBinaryMessage(data).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.WebSocket __writeTextMessage(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeTextMessage(text, handler);
    return this;
  }

  public Uni<Void> writeTextMessage(String text) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeTextMessage(text, handler);
    });
  }

  public Void writeTextMessageAndAwait(String text) { 
    return (Void) writeTextMessage(text).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.WebSocket __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket closeHandler(Consumer<Void> handler) {
    return __closeHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.http.WebSocket __frameHandler(Handler<io.vertx.mutiny.core.http.WebSocketFrame> handler) { 
    delegate.frameHandler(new Handler<io.vertx.core.http.WebSocketFrame>() {
      public void handle(io.vertx.core.http.WebSocketFrame event) {
        handler.handle(io.vertx.mutiny.core.http.WebSocketFrame.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket frameHandler(Consumer<io.vertx.mutiny.core.http.WebSocketFrame> handler) {
    return __frameHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public SSLSession sslSession() { 
    SSLSession ret = delegate.sslSession();
    return ret;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data the data to write
   */
  public void endAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer>)} but you don't need to compose it with other operations.
   * @param dst 
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#end} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#end}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#end} but you don't need to compose it with other operations.
   */
  public void endAndForget() { 
    delegate.end();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close(short)} but you don't need to compose it with other operations.
   * @param statusCode Status code
   */
  public void closeAndForget(short statusCode) { 
    delegate.close(statusCode);
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.WebSocketBase#close(short,String)} but you don't need to compose it with other operations.
   * @param statusCode Status code
   * @param reason reason of closure
   */
  public void closeAndForget(short statusCode, String reason) { 
    delegate.close(statusCode, reason);
  }

  public io.vertx.mutiny.core.http.WebSocket writeAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket writeFrameAndForget(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    delegate.writeFrame(frame.getDelegate());
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket writeFinalTextFrameAndForget(String text) { 
    delegate.writeFinalTextFrame(text);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket writeFinalBinaryFrameAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writeFinalBinaryFrame(data.getDelegate());
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket writeBinaryMessageAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writeBinaryMessage(data.getDelegate());
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket writeTextMessageAndForget(String text) { 
    delegate.writeTextMessage(text);
    return this;
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private io.vertx.mutiny.core.net.SocketAddress cached_1;
  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  public static  WebSocket newInstance(io.vertx.core.http.WebSocket arg) {
    return arg != null ? new WebSocket(arg) : null;
  }

}
