package io.vertx.mutiny.core.http;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebsocketVersion;
import java.util.function.Function;
import java.util.List;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An asynchronous HTTP client.
 * <p>
 * It allows you to make requests to HTTP servers, and a single client can make requests to any server.
 * <p>
 * It also allows you to open WebSockets to servers.
 * <p>
 * The client can also pool HTTP connections.
 * <p>
 * For pooling to occur, keep-alive must be true on the {@link io.vertx.core.http.HttpClientOptions} (default is true).
 * In this case connections will be pooled and re-used if there are pending HTTP requests waiting to get a connection,
 * otherwise they will be closed.
 * <p>
 * This gives the benefits of keep alive when the client is loaded but means we don't keep connections hanging around
 * unnecessarily when there would be no benefits anyway.
 * <p>
 * The client also supports pipe-lining of requests. Pipe-lining means another request is sent on the same connection
 * before the response from the preceding one has returned. Pipe-lining is not appropriate for all requests.
 * <p>
 * To enable pipe-lining, it must be enabled on the {@link io.vertx.core.http.HttpClientOptions} (default is false).
 * <p>
 * When pipe-lining is enabled the connection will be automatically closed when all in-flight responses have returned
 * and there are no outstanding pending requests to write.
 * <p>
 * The client is designed to be reused between requests.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpClient.class)
public class HttpClient implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpClient((io.vertx.core.http.HttpClient) obj),
    HttpClient::getDelegate
  );

  private final io.vertx.core.http.HttpClient delegate;
  
  public HttpClient(io.vertx.core.http.HttpClient delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  HttpClient() {    this.delegate = null;
  }

  public io.vertx.core.http.HttpClient getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_0 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_14 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_4 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_8 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_13 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_7 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_10 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_5 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_3 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_11 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_2 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_6 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_9 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_1 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_12 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_16 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket> TYPE_ARG_15 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.WebSocket>(o1 -> io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpClient that = (HttpClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param options 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, RequestOptions options) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), options));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param options the request options
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, RequestOptions options) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, options));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, int port, String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, port, host, requestURI));
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param port 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, int port, String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), port, host, requestURI));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, host, requestURI));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param options the request options
   * @param responseHandler 
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __request(HttpMethod method, RequestOptions options, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, options, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param options the request options
   * @param responseHandler 
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, RequestOptions options, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __request(method, options, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param options 
   * @param responseHandler 
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpClientRequest __request(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, RequestOptions options, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), options, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param options 
   * @param responseHandler 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, RequestOptions options, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __request(method, serverAddress, options, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __request(HttpMethod method, int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, port, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __request(method, port, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param port 
   * @param host 
   * @param requestURI 
   * @param responseHandler 
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpClientRequest __request(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), port, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param port 
   * @param host 
   * @param requestURI 
   * @param responseHandler 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __request(method, serverAddress, port, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __request(HttpMethod method, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __request(method, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param method the HTTP method
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, requestURI));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __request(HttpMethod method, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.request(method, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest request(HttpMethod method, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __request(method, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param method the HTTP method
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest requestAbs(HttpMethod method, String absoluteURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.requestAbs(method, absoluteURI));
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param absoluteURI 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpClientRequest requestAbs(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, String absoluteURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.requestAbs(method, serverAddress.getDelegate(), absoluteURI));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __requestAbs(HttpMethod method, String absoluteURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.requestAbs(method, absoluteURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest requestAbs(HttpMethod method, String absoluteURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __requestAbs(method, absoluteURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param absoluteURI 
   * @param responseHandler 
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpClientRequest __requestAbs(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, String absoluteURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.requestAbs(method, serverAddress.getDelegate(), absoluteURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param absoluteURI 
   * @param responseHandler 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpClientRequest requestAbs(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, String absoluteURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __requestAbs(method, serverAddress, absoluteURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param options the request options
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest get(RequestOptions options) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.get(options));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest get(int port, String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.get(port, host, requestURI));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest get(String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.get(host, requestURI));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __get(RequestOptions options, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.get(options, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest get(RequestOptions options, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __get(options, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __get(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.get(port, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest get(int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __get(port, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __get(String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.get(host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest get(String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __get(host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest get(String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.get(requestURI));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __get(String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.get(requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest get(String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __get(requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest getAbs(String absoluteURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.getAbs(absoluteURI));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __getAbs(String absoluteURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.getAbs(absoluteURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest getAbs(String absoluteURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __getAbs(absoluteURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __getNow(RequestOptions options, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.getNow(options, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient getNow(RequestOptions options, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __getNow(options, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __getNow(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.getNow(port, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient getNow(int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __getNow(port, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __getNow(String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.getNow(host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient getNow(String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __getNow(host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __getNow(String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.getNow(requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient getNow(String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __getNow(requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param options the request options
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest post(RequestOptions options) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.post(options));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest post(int port, String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.post(port, host, requestURI));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest post(String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.post(host, requestURI));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __post(RequestOptions options, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.post(options, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest post(RequestOptions options, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __post(options, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __post(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.post(port, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest post(int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __post(port, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __post(String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.post(host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest post(String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __post(host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest post(String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.post(requestURI));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __post(String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.post(requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest post(String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __post(requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest postAbs(String absoluteURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.postAbs(absoluteURI));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __postAbs(String absoluteURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.postAbs(absoluteURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest postAbs(String absoluteURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __postAbs(absoluteURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param options the request options
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest head(RequestOptions options) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.head(options));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest head(int port, String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.head(port, host, requestURI));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest head(String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.head(host, requestURI));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __head(RequestOptions options, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.head(options, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest head(RequestOptions options, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __head(options, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __head(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.head(port, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest head(int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __head(port, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __head(String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.head(host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest head(String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __head(host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest head(String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.head(requestURI));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __head(String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.head(requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest head(String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __head(requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest headAbs(String absoluteURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.headAbs(absoluteURI));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __headAbs(String absoluteURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.headAbs(absoluteURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest headAbs(String absoluteURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __headAbs(absoluteURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __headNow(RequestOptions options, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.headNow(options, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient headNow(RequestOptions options, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __headNow(options, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __headNow(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.headNow(port, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient headNow(int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __headNow(port, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __headNow(String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.headNow(host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient headNow(String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __headNow(host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __headNow(String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.headNow(requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient headNow(String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __headNow(requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param options the request options
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest options(RequestOptions options) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.options(options));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest options(int port, String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.options(port, host, requestURI));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest options(String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.options(host, requestURI));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __options(RequestOptions options, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.options(options, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest options(RequestOptions options, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __options(options, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __options(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.options(port, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest options(int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __options(port, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __options(String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.options(host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest options(String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __options(host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest options(String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.options(requestURI));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __options(String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.options(requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest options(String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __options(requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest optionsAbs(String absoluteURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.optionsAbs(absoluteURI));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __optionsAbs(String absoluteURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.optionsAbs(absoluteURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest optionsAbs(String absoluteURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __optionsAbs(absoluteURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __optionsNow(RequestOptions options, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.optionsNow(options, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient optionsNow(RequestOptions options, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __optionsNow(options, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __optionsNow(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.optionsNow(port, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient optionsNow(int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __optionsNow(port, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __optionsNow(String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.optionsNow(host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient optionsNow(String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __optionsNow(host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __optionsNow(String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    delegate.optionsNow(requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient optionsNow(String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __optionsNow(requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param options the request options
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest put(RequestOptions options) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.put(options));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest put(int port, String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.put(port, host, requestURI));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest put(String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.put(host, requestURI));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __put(RequestOptions options, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.put(options, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest put(RequestOptions options, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __put(options, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __put(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.put(port, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest put(int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __put(port, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __put(String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.put(host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest put(String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __put(host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest put(String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.put(requestURI));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __put(String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.put(requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest put(String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __put(requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest putAbs(String absoluteURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.putAbs(absoluteURI));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __putAbs(String absoluteURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.putAbs(absoluteURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest putAbs(String absoluteURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __putAbs(absoluteURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param options the request options
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest delete(RequestOptions options) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.delete(options));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest delete(int port, String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.delete(port, host, requestURI));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest delete(String host, String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.delete(host, requestURI));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __delete(RequestOptions options, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.delete(options, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param options the request options
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest delete(RequestOptions options, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __delete(options, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __delete(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.delete(port, host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest delete(int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __delete(port, host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __delete(String host, String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.delete(host, requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest delete(String host, String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __delete(host, requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest delete(String requestURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.delete(requestURI));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __delete(String requestURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.delete(requestURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest delete(String requestURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __delete(requestURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.core.http.HttpClientRequest deleteAbs(String absoluteURI) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.deleteAbs(absoluteURI));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClientRequest __deleteAbs(String absoluteURI, Handler<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) { 
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance(delegate.deleteAbs(absoluteURI, new Handler<io.vertx.core.http.HttpClientResponse>() {
      public void handle(io.vertx.core.http.HttpClientResponse event) {
        responseHandler.handle(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @param responseHandler the response handler
   * @return an HTTP client request object
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClientRequest deleteAbs(String absoluteURI, Consumer<io.vertx.mutiny.core.http.HttpClientResponse> responseHandler) {
    return __deleteAbs(absoluteURI, responseHandler != null ? responseHandler::accept : null);
  }

  /**
   * @param options the request options
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(RequestOptions options, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(options, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param options the request options
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(RequestOptions options, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(options, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(port, host, requestURI, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(int port, String host, String requestURI, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(port, host, requestURI, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param options the request options
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(RequestOptions options, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(options, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param options the request options
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(RequestOptions options, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(options, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(port, host, requestURI, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(int port, String host, String requestURI, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(port, host, requestURI, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String host, String requestURI, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(host, requestURI, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String host, String requestURI, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(host, requestURI, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String host, String requestURI, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(host, requestURI, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String host, String requestURI, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(host, requestURI, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(options, headers.getDelegate(), new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(options, headers, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(port, host, requestURI, headers.getDelegate(), new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(port, host, requestURI, headers, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(options, headers.getDelegate(), new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(options, headers, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(port, host, requestURI, headers.getDelegate(), new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(port, host, requestURI, headers, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(host, requestURI, headers.getDelegate(), new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(host, requestURI, headers, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(host, requestURI, headers.getDelegate(), new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(host, requestURI, headers, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(options, headers.getDelegate(), version, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(options, headers, version, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(port, host, requestURI, headers.getDelegate(), version, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(port, host, requestURI, headers, version, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(options, headers.getDelegate(), version, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(options, headers, version, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(port, host, requestURI, headers.getDelegate(), version, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(port, host, requestURI, headers, version, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(host, requestURI, headers.getDelegate(), version, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(host, requestURI, headers, version, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(host, requestURI, headers.getDelegate(), version, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(host, requestURI, headers, version, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(options, headers.getDelegate(), version, subProtocols, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(options, headers, version, subProtocols, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(port, host, requestURI, headers.getDelegate(), version, subProtocols, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(port, host, requestURI, headers, version, subProtocols, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param url the absolute url
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocketAbs(String url, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocketAbs(url, headers.getDelegate(), version, subProtocols, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param url the absolute url
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocketAbs(String url, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocketAbs(url, headers, version, subProtocols, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(options, headers.getDelegate(), version, subProtocols, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(options, headers, version, subProtocols, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(port, host, requestURI, headers.getDelegate(), version, subProtocols, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(port, host, requestURI, headers, version, subProtocols, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(host, requestURI, headers.getDelegate(), version, subProtocols, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(host, requestURI, headers, version, subProtocols, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(host, requestURI, headers.getDelegate(), version, subProtocols, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(host, requestURI, headers, version, subProtocols, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String requestURI, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(requestURI, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String requestURI, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(requestURI, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String requestURI, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(requestURI, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param requestURI the relative URI
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String requestURI, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(requestURI, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(requestURI, headers.getDelegate(), new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(requestURI, headers, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(requestURI, headers.getDelegate(), new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(requestURI, headers, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(requestURI, headers.getDelegate(), version, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(requestURI, headers, version, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(requestURI, headers.getDelegate(), version, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(requestURI, headers, version, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect) { 
    delegate.websocket(requestURI, headers.getDelegate(), version, subProtocols, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Consumer<io.vertx.mutiny.core.http.WebSocket> wsConnect) {
    return __websocket(requestURI, headers, version, subProtocols, wsConnect != null ? wsConnect::accept : null);
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private io.vertx.mutiny.core.http.HttpClient __websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Handler<Throwable> failureHandler) { 
    delegate.websocket(requestURI, headers.getDelegate(), version, subProtocols, new Handler<io.vertx.core.http.WebSocket>() {
      public void handle(io.vertx.core.http.WebSocket event) {
        wsConnect.handle(io.vertx.mutiny.core.http.WebSocket.newInstance(event));
      }
    }, failureHandler);
    return this;
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols
   * @param wsConnect handler that will be called with the WebSocket when connected
   * @param failureHandler handler that will be called if WebSocket connection fails
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public io.vertx.mutiny.core.http.HttpClient websocket(String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols, Handler<io.vertx.mutiny.core.http.WebSocket> wsConnect, Consumer<Throwable> failureHandler) {
    return __websocket(requestURI, headers, version, subProtocols, wsConnect, failureHandler != null ? failureHandler::accept : null);
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param handler handler that will be called with the WebSocket when connected
   */
  private void __webSocket(int port, String host, String requestURI, Handler<AsyncResult<io.vertx.mutiny.core.http.WebSocket>> handler) { 
    delegate.webSocket(port, host, requestURI, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>() {
      public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.WebSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Connect a WebSocket to the specified port, host and relative request URI
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.WebSocket> webSocket(int port, String host, String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __webSocket(port, host, requestURI, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(int,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return the WebSocket instance produced by the operation
   */
  public io.vertx.mutiny.core.http.WebSocket webSocketAndAwait(int port, String host, String requestURI) { 
    return (io.vertx.mutiny.core.http.WebSocket) webSocket(port, host, requestURI).await().indefinitely();
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param handler handler that will be called with the WebSocket when connected
   */
  private void __webSocket(String host, String requestURI, Handler<AsyncResult<io.vertx.mutiny.core.http.WebSocket>> handler) { 
    delegate.webSocket(host, requestURI, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>() {
      public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.WebSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Connect a WebSocket to the host and relative request URI and default port
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param host the host
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.WebSocket> webSocket(String host, String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __webSocket(host, requestURI, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param host the host
   * @param requestURI the relative URI
   * @return the WebSocket instance produced by the operation
   */
  public io.vertx.mutiny.core.http.WebSocket webSocketAndAwait(String host, String requestURI) { 
    return (io.vertx.mutiny.core.http.WebSocket) webSocket(host, requestURI).await().indefinitely();
  }

  /**
   * @param requestURI the relative URI
   * @param handler handler that will be called with the WebSocket when connected
   */
  private void __webSocket(String requestURI, Handler<AsyncResult<io.vertx.mutiny.core.http.WebSocket>> handler) { 
    delegate.webSocket(requestURI, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>() {
      public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.WebSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Connect a WebSocket at the relative request URI using the default host and port
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.WebSocket> webSocket(String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __webSocket(requestURI, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param requestURI the relative URI
   * @return the WebSocket instance produced by the operation
   */
  public io.vertx.mutiny.core.http.WebSocket webSocketAndAwait(String requestURI) { 
    return (io.vertx.mutiny.core.http.WebSocket) webSocket(requestURI).await().indefinitely();
  }

  /**
   * @param options the request options
   * @param handler 
   */
  private void __webSocket(WebSocketConnectOptions options, Handler<AsyncResult<io.vertx.mutiny.core.http.WebSocket>> handler) { 
    delegate.webSocket(options, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>() {
      public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.WebSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Connect a WebSocket with the specified options.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the request options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.WebSocket> webSocket(WebSocketConnectOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __webSocket(options, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(WebSocketConnectOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the request options
   * @return the WebSocket instance produced by the operation
   */
  public io.vertx.mutiny.core.http.WebSocket webSocketAndAwait(WebSocketConnectOptions options) { 
    return (io.vertx.mutiny.core.http.WebSocket) webSocket(options).await().indefinitely();
  }

  /**
   * @param url the absolute url
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @param handler handler that will be called if WebSocket connection fails
   */
  private void __webSocketAbs(String url, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, List<String> subProtocols, Handler<AsyncResult<io.vertx.mutiny.core.http.WebSocket>> handler) { 
    delegate.webSocketAbs(url, headers.getDelegate(), version, subProtocols, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>() {
      public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.WebSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Connect a WebSocket with the specified absolute url, with the specified headers, using
   * the specified version of WebSockets, and the specified WebSocket sub protocols.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param url the absolute url
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.http.WebSocket> webSocketAbs(String url, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, List<String> subProtocols) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __webSocketAbs(url, headers, version, subProtocols, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocketAbs(String,io.vertx.mutiny.core.MultiMap,WebsocketVersion,List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param url the absolute url
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @return the WebSocket instance produced by the operation
   */
  public io.vertx.mutiny.core.http.WebSocket webSocketAbsAndAwait(String url, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, List<String> subProtocols) { 
    return (io.vertx.mutiny.core.http.WebSocket) webSocketAbs(url, headers, version, subProtocols).await().indefinitely();
  }

  /**
   * @param options the request options
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(RequestOptions options) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(options), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(int port, String host, String requestURI) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(port, host, requestURI), TYPE_ARG_1);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(String host, String requestURI) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(host, requestURI), TYPE_ARG_2);
    return ret;
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(RequestOptions options, io.vertx.mutiny.core.MultiMap headers) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(options, headers.getDelegate()), TYPE_ARG_3);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(port, host, requestURI, headers.getDelegate()), TYPE_ARG_4);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(host, requestURI, headers.getDelegate()), TYPE_ARG_5);
    return ret;
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param version the WebSocket version
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(options, headers.getDelegate(), version), TYPE_ARG_6);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(port, host, requestURI, headers.getDelegate(), version), TYPE_ARG_7);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(host, requestURI, headers.getDelegate(), version), TYPE_ARG_8);
    return ret;
  }

  /**
   * @param url the absolute url
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStreamAbs(String url, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStreamAbs(url, headers.getDelegate(), version, subProtocols), TYPE_ARG_9);
    return ret;
  }

  /**
   * @param options the request options
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(RequestOptions options, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(options, headers.getDelegate(), version, subProtocols), TYPE_ARG_10);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(int port, String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(port, host, requestURI, headers.getDelegate(), version, subProtocols), TYPE_ARG_11);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(String host, String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(host, requestURI, headers.getDelegate(), version, subProtocols), TYPE_ARG_12);
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(String requestURI) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(requestURI), TYPE_ARG_13);
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(String requestURI, io.vertx.mutiny.core.MultiMap headers) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(requestURI, headers.getDelegate()), TYPE_ARG_14);
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(requestURI, headers.getDelegate(), version), TYPE_ARG_15);
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols
   * @return a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
   */
  @Deprecated
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> websocketStream(String requestURI, io.vertx.mutiny.core.MultiMap headers, WebsocketVersion version, String subProtocols) { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.WebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(requestURI, headers.getDelegate(), version, subProtocols), TYPE_ARG_16);
    return ret;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpClient __connectionHandler(Handler<io.vertx.mutiny.core.http.HttpConnection> handler) { 
    delegate.connectionHandler(new Handler<io.vertx.core.http.HttpConnection>() {
      public void handle(io.vertx.core.http.HttpConnection event) {
        handler.handle(io.vertx.mutiny.core.http.HttpConnection.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpClient connectionHandler(Consumer<io.vertx.mutiny.core.http.HttpConnection> handler) {
    return __connectionHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the new redirect handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpClient redirectHandler(Function<io.vertx.mutiny.core.http.HttpClientResponse, io.vertx.mutiny.core.Future<io.vertx.mutiny.core.http.HttpClientRequest>> handler) { 
    delegate.redirectHandler(new java.util.function.Function<io.vertx.core.http.HttpClientResponse,io.vertx.core.Future<io.vertx.core.http.HttpClientRequest>>() {
      public io.vertx.core.Future<io.vertx.core.http.HttpClientRequest> apply(io.vertx.core.http.HttpClientResponse arg) {
        io.vertx.mutiny.core.Future<io.vertx.mutiny.core.http.HttpClientRequest> ret = handler.apply(io.vertx.mutiny.core.http.HttpClientResponse.newInstance(arg));
        return ret.getDelegate();
      }
    });
    return this;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  public static  HttpClient newInstance(io.vertx.core.http.HttpClient arg) {
    return arg != null ? new HttpClient(arg) : null;
  }

}
