package io.vertx.mutiny.core;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.dns.DnsClientOptions;
import java.util.function.Supplier;
import io.vertx.core.AsyncResult;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.netty.channel.EventLoopGroup;
import io.vertx.core.VertxOptions;
import java.util.Set;
import io.vertx.core.Verticle;
import io.vertx.core.net.NetClientOptions;
import java.util.concurrent.TimeUnit;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.Handler;

/**
 * The entry point into the Vert.x Core API.
 * <p>
 * You use an instance of this class for functionality including:
 * <ul>
 *   <li>Creating TCP clients and servers</li>
 *   <li>Creating HTTP clients and servers</li>
 *   <li>Creating DNS clients</li>
 *   <li>Creating Datagram sockets</li>
 *   <li>Setting and cancelling periodic and one-shot timers</li>
 *   <li>Getting a reference to the event bus API</li>
 *   <li>Getting a reference to the file system API</li>
 *   <li>Getting a reference to the shared data API</li>
 *   <li>Deploying and undeploying verticles</li>
 * </ul>
 * <p>
 * Most functionality in Vert.x core is fairly low level.
 * <p>
 * To create an instance of this class you can use the static factory methods: {@link io.vertx.mutiny.core.Vertx#vertx},
 * {@link io.vertx.mutiny.core.Vertx#vertx} and {@link io.vertx.mutiny.core.Vertx#clusteredVertx}.
 * <p>
 * Please see the user manual for more detailed usage information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Vertx original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.Vertx.class)
public class Vertx implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<Vertx> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Vertx((io.vertx.core.Vertx) obj),
    Vertx::getDelegate
  );

  private final io.vertx.core.Vertx delegate;
  
  public Vertx(io.vertx.core.Vertx delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  Vertx() {    this.delegate = null;
  }

  public io.vertx.core.Vertx getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Vertx that = (Vertx) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * @return the instance
   */
  public static io.vertx.mutiny.core.Vertx vertx() { 
    io.vertx.mutiny.core.Vertx ret = io.vertx.mutiny.core.Vertx.newInstance(io.vertx.core.Vertx.vertx());
    return ret;
  }

  /**
   * @param options the options to use
   * @return the instance
   */
  public static io.vertx.mutiny.core.Vertx vertx(VertxOptions options) { 
    io.vertx.mutiny.core.Vertx ret = io.vertx.mutiny.core.Vertx.newInstance(io.vertx.core.Vertx.vertx(options));
    return ret;
  }

  /**
   * @param options the options to use
   * @param resultHandler the result handler that will receive the result
   */
  private static void __clusteredVertx(VertxOptions options, Handler<AsyncResult<io.vertx.mutiny.core.Vertx>> resultHandler) { 
    io.vertx.core.Vertx.clusteredVertx(options, new Handler<AsyncResult<io.vertx.core.Vertx>>() {
      public void handle(AsyncResult<io.vertx.core.Vertx> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.Vertx.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the resultHandler is called with the result when it is ready.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the options to use
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public static Uni<io.vertx.mutiny.core.Vertx> clusteredVertx(VertxOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __clusteredVertx(options, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Vertx#clusteredVertx(VertxOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the options to use
   * @return the Vertx instance produced by the operation
   */
  public static io.vertx.mutiny.core.Vertx clusteredVertxAndAwait(VertxOptions options) { 
    return (io.vertx.mutiny.core.Vertx) clusteredVertx(options).await().indefinitely();
  }

  /**
   * @return The current context or null if no current context
   */
  public static io.vertx.mutiny.core.Context currentContext() { 
    io.vertx.mutiny.core.Context ret = io.vertx.mutiny.core.Context.newInstance(io.vertx.core.Vertx.currentContext());
    return ret;
  }

  /**
   * @return The current context (created if didn't exist)
   */
  public io.vertx.mutiny.core.Context getOrCreateContext() { 
    io.vertx.mutiny.core.Context ret = io.vertx.mutiny.core.Context.newInstance(delegate.getOrCreateContext());
    return ret;
  }

  /**
   * @param options the options to use
   * @return the server
   */
  public io.vertx.mutiny.core.net.NetServer createNetServer(NetServerOptions options) { 
    io.vertx.mutiny.core.net.NetServer ret = io.vertx.mutiny.core.net.NetServer.newInstance(delegate.createNetServer(options));
    return ret;
  }

  /**
   * @return the server
   */
  public io.vertx.mutiny.core.net.NetServer createNetServer() { 
    io.vertx.mutiny.core.net.NetServer ret = io.vertx.mutiny.core.net.NetServer.newInstance(delegate.createNetServer());
    return ret;
  }

  /**
   * @param options the options to use
   * @return the client
   */
  public io.vertx.mutiny.core.net.NetClient createNetClient(NetClientOptions options) { 
    io.vertx.mutiny.core.net.NetClient ret = io.vertx.mutiny.core.net.NetClient.newInstance(delegate.createNetClient(options));
    return ret;
  }

  /**
   * @return the client
   */
  public io.vertx.mutiny.core.net.NetClient createNetClient() { 
    io.vertx.mutiny.core.net.NetClient ret = io.vertx.mutiny.core.net.NetClient.newInstance(delegate.createNetClient());
    return ret;
  }

  /**
   * @param options the options to use
   * @return the server
   */
  public io.vertx.mutiny.core.http.HttpServer createHttpServer(HttpServerOptions options) { 
    io.vertx.mutiny.core.http.HttpServer ret = io.vertx.mutiny.core.http.HttpServer.newInstance(delegate.createHttpServer(options));
    return ret;
  }

  /**
   * @return the server
   */
  public io.vertx.mutiny.core.http.HttpServer createHttpServer() { 
    io.vertx.mutiny.core.http.HttpServer ret = io.vertx.mutiny.core.http.HttpServer.newInstance(delegate.createHttpServer());
    return ret;
  }

  /**
   * @param options the options to use
   * @return the client
   */
  public io.vertx.mutiny.core.http.HttpClient createHttpClient(HttpClientOptions options) { 
    io.vertx.mutiny.core.http.HttpClient ret = io.vertx.mutiny.core.http.HttpClient.newInstance(delegate.createHttpClient(options));
    return ret;
  }

  /**
   * @return the client
   */
  public io.vertx.mutiny.core.http.HttpClient createHttpClient() { 
    io.vertx.mutiny.core.http.HttpClient ret = io.vertx.mutiny.core.http.HttpClient.newInstance(delegate.createHttpClient());
    return ret;
  }

  /**
   * @param options the options to use
   * @return the socket
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket createDatagramSocket(DatagramSocketOptions options) { 
    io.vertx.mutiny.core.datagram.DatagramSocket ret = io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(delegate.createDatagramSocket(options));
    return ret;
  }

  /**
   * @return the socket
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket createDatagramSocket() { 
    io.vertx.mutiny.core.datagram.DatagramSocket ret = io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(delegate.createDatagramSocket());
    return ret;
  }

  /**
   * @return the filesystem object
   */
  public io.vertx.mutiny.core.file.FileSystem fileSystem() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.file.FileSystem ret = io.vertx.mutiny.core.file.FileSystem.newInstance(delegate.fileSystem());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the event bus object
   */
  public io.vertx.mutiny.core.eventbus.EventBus eventBus() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.eventbus.EventBus ret = io.vertx.mutiny.core.eventbus.EventBus.newInstance(delegate.eventBus());
    cached_1 = ret;
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @return the DNS client
   */
  public io.vertx.mutiny.core.dns.DnsClient createDnsClient(int port, String host) { 
    io.vertx.mutiny.core.dns.DnsClient ret = io.vertx.mutiny.core.dns.DnsClient.newInstance(delegate.createDnsClient(port, host));
    return ret;
  }

  /**
   * @return the DNS client
   */
  public io.vertx.mutiny.core.dns.DnsClient createDnsClient() { 
    io.vertx.mutiny.core.dns.DnsClient ret = io.vertx.mutiny.core.dns.DnsClient.newInstance(delegate.createDnsClient());
    return ret;
  }

  /**
   * @param options the client options
   * @return the DNS client
   */
  public io.vertx.mutiny.core.dns.DnsClient createDnsClient(DnsClientOptions options) { 
    io.vertx.mutiny.core.dns.DnsClient ret = io.vertx.mutiny.core.dns.DnsClient.newInstance(delegate.createDnsClient(options));
    return ret;
  }

  /**
   * @return the shared data object
   */
  public io.vertx.mutiny.core.shareddata.SharedData sharedData() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.mutiny.core.shareddata.SharedData ret = io.vertx.mutiny.core.shareddata.SharedData.newInstance(delegate.sharedData());
    cached_2 = ret;
    return ret;
  }

  /**
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  private long __setTimer(long delay, Handler<Long> handler) { 
    long ret = delegate.setTimer(delay, handler);
    return ret;
  }

  /**
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setTimer(long delay, Consumer<Long> handler) {
    return __setTimer(delay, handler != null ? handler::accept : null);
  }

  /**
   * @param delay the delay in milliseconds, after which the timer will fire
   * @return the timer stream
   */
  public io.vertx.mutiny.core.TimeoutStream timerStream(long delay) { 
    io.vertx.mutiny.core.TimeoutStream ret = io.vertx.mutiny.core.TimeoutStream.newInstance(delegate.timerStream(delay));
    return ret;
  }

  /**
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  private long __setPeriodic(long delay, Handler<Long> handler) { 
    long ret = delegate.setPeriodic(delay, handler);
    return ret;
  }

  /**
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setPeriodic(long delay, Consumer<Long> handler) {
    return __setPeriodic(delay, handler != null ? handler::accept : null);
  }

  /**
   * @param delay the delay in milliseconds, after which the timer will fire
   * @return the periodic stream
   */
  public io.vertx.mutiny.core.TimeoutStream periodicStream(long delay) { 
    io.vertx.mutiny.core.TimeoutStream ret = io.vertx.mutiny.core.TimeoutStream.newInstance(delegate.periodicStream(delay));
    return ret;
  }

  /**
   * @param id The id of the timer to cancel
   * @return true if the timer was successfully cancelled, or false if the timer does not exist.
   */
  public boolean cancelTimer(long id) { 
    boolean ret = delegate.cancelTimer(id);
    return ret;
  }

  /**
   * @param action - a handler representing the action to execute
   */
  private void __runOnContext(Handler<Void> action) { 
    delegate.runOnContext(action);
  }

  /**
   * @param action - a handler representing the action to execute
   */
  public void runOnContext(Consumer<Void> action) {
    __runOnContext(action != null ? action::accept : null);
  }

  /**
   * @param completionHandler The handler will be notified when the close is complete.
   */
  private void __close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.Vertx#close} but the completionHandler will be called when the close is complete
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Vertx#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * @param name The identifier
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  private void __deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(name, completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name The identifier
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<String> deployVerticle(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __deployVerticle(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Vertx#deployVerticle(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name The identifier
   * @return the String instance produced by the operation
   */
  public String deployVerticleAndAwait(String name) { 
    return (String) deployVerticle(name).await().indefinitely();
  }

  /**
   * @param name the name
   * @param options the deployment options.
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  private void __deployVerticle(String name, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(name, options, completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the name
   * @param options the deployment options.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<String> deployVerticle(String name, DeploymentOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __deployVerticle(name, options, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Vertx#deployVerticle(String,DeploymentOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the name
   * @param options the deployment options.
   * @return the String instance produced by the operation
   */
  public String deployVerticleAndAwait(String name, DeploymentOptions options) { 
    return (String) deployVerticle(name, options).await().indefinitely();
  }

  /**
   * @param deploymentID the deployment ID
   * @param completionHandler a handler which will be notified when the undeployment is complete
   */
  private void __undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.undeploy(deploymentID, completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.Vertx #undeploy(String)} but the completionHandler will be notified when the undeployment is complete.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param deploymentID the deployment ID
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> undeploy(String deploymentID) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __undeploy(deploymentID, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Vertx#undeploy(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param deploymentID the deployment ID
   * @return the Void instance produced by the operation
   */
  public Void undeployAndAwait(String deploymentID) { 
    return (Void) undeploy(deploymentID).await().indefinitely();
  }

  /**
   * @return Set of deployment IDs
   */
  public Set<String> deploymentIDs() { 
    Set<String> ret = delegate.deploymentIDs();
    return ret;
  }

  /**
   * @return true if clustered
   */
  public boolean isClustered() { 
    boolean ret = delegate.isClustered();
    return ret;
  }

  /**
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @param resultHandler handler that will be called when the blocking code is complete
   */
  private <T> void __executeBlocking(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        blockingCodeHandler.handle(io.vertx.mutiny.core.Promise.newInstance(event, io.smallrye.mutiny.vertx.TypeArg.unknown()));
      }
    }, ordered, resultHandler);
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (e.g. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.mutiny.core.Promise#complete} or {@link io.vertx.mutiny.core.Promise#complete} method, or the {@link io.vertx.mutiny.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * <p>
   * The blocking code should block for a reasonable amount of time (i.e no more than a few seconds). Long blocking operations
   * or polling operations (i.e a thread that spin in a loop polling events in a blocking fashion) are precluded.
   * <p>
   * When the blocking operation lasts more than the 10 seconds, a message will be printed on the console by the
   * blocked thread checker.
   * <p>
   * Long blocking operations should use a dedicated thread managed by the application, which can interact with
   * verticles using the event-bus or {@link io.vertx.mutiny.core.Context#runOnContext}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public <T> Uni<T> executeBlocking(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler, boolean ordered) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __executeBlocking(blockingCodeHandler, ordered, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Vertx#executeBlocking(Handler<Promise<T>>,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return the T instance produced by the operation
   */
  public <T> T executeBlockingAndAwait(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler, boolean ordered) { 
    return (T) executeBlocking(blockingCodeHandler, ordered).await().indefinitely();
  }

  /**
   * @param blockingCodeHandler 
   * @param resultHandler 
   */
  private <T> void __executeBlocking(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        blockingCodeHandler.handle(io.vertx.mutiny.core.Promise.newInstance(event, io.smallrye.mutiny.vertx.TypeArg.unknown()));
      }
    }, resultHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.Vertx#executeBlocking} called with ordered = true.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param blockingCodeHandler 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public <T> Uni<T> executeBlocking(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __executeBlocking(blockingCodeHandler, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Vertx#executeBlocking(Handler<Promise<T>>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param blockingCodeHandler 
   * @return the T instance produced by the operation
   */
  public <T> T executeBlockingAndAwait(Handler<io.vertx.mutiny.core.Promise<T>> blockingCodeHandler) { 
    return (T) executeBlocking(blockingCodeHandler).await().indefinitely();
  }

  /**
   * @param name 
   * @return 
   */
  public io.vertx.mutiny.core.WorkerExecutor createSharedWorkerExecutor(String name) { 
    io.vertx.mutiny.core.WorkerExecutor ret = io.vertx.mutiny.core.WorkerExecutor.newInstance(delegate.createSharedWorkerExecutor(name));
    return ret;
  }

  /**
   * @param name 
   * @param poolSize 
   * @return 
   */
  public io.vertx.mutiny.core.WorkerExecutor createSharedWorkerExecutor(String name, int poolSize) { 
    io.vertx.mutiny.core.WorkerExecutor ret = io.vertx.mutiny.core.WorkerExecutor.newInstance(delegate.createSharedWorkerExecutor(name, poolSize));
    return ret;
  }

  /**
   * @param name 
   * @param poolSize 
   * @param maxExecuteTime 
   * @return 
   */
  public io.vertx.mutiny.core.WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) { 
    io.vertx.mutiny.core.WorkerExecutor ret = io.vertx.mutiny.core.WorkerExecutor.newInstance(delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime));
    return ret;
  }

  /**
   * @param name the name of the worker executor
   * @param poolSize the size of the pool
   * @param maxExecuteTime the value of max worker execute time
   * @param maxExecuteTimeUnit the value of unit of max worker execute time
   * @return the named worker executor
   */
  public io.vertx.mutiny.core.WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) { 
    io.vertx.mutiny.core.WorkerExecutor ret = io.vertx.mutiny.core.WorkerExecutor.newInstance(delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime, maxExecuteTimeUnit));
    return ret;
  }

  /**
   * @return whether the native transport is used
   */
  public boolean isNativeTransportEnabled() { 
    if (cached_3 != null) {
      return cached_3;
    }
    boolean ret = delegate.isNativeTransportEnabled();
    cached_3 = ret;
    return ret;
  }

  /**
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.Vertx __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.Vertx exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param verticle the verticle instance to deploy
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  private void __deployVerticle(Verticle verticle, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(verticle, completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a string representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param verticle the verticle instance to deploy
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<String> deployVerticle(Verticle verticle) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __deployVerticle(verticle, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Vertx#deployVerticle(Verticle)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param verticle the verticle instance to deploy
   * @return the String instance produced by the operation
   */
  public String deployVerticleAndAwait(Verticle verticle) { 
    return (String) deployVerticle(verticle).await().indefinitely();
  }

  /**
   * @param verticle the verticle instance to deploy
   * @param options the deployment options.
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  private void __deployVerticle(Verticle verticle, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(verticle, options, completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param verticle the verticle instance to deploy
   * @param options the deployment options.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<String> deployVerticle(Verticle verticle, DeploymentOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __deployVerticle(verticle, options, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Vertx#deployVerticle(Verticle,DeploymentOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param verticle the verticle instance to deploy
   * @param options the deployment options.
   * @return the String instance produced by the operation
   */
  public String deployVerticleAndAwait(Verticle verticle, DeploymentOptions options) { 
    return (String) deployVerticle(verticle, options).await().indefinitely();
  }

  /**
   * @param verticleSupplier 
   * @param options 
   * @param completionHandler 
   */
  private void __deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(verticleSupplier, options, completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.Vertx#deployVerticle} but {@link io.vertx.core.Verticle} instance is created by
   * invoking the <code>verticleSupplier</code>.
   * <p>
   * The supplier will be invoked as many times as {@link io.vertx.core.DeploymentOptions}.
   * It must not return the same instance twice.
   * <p>
   * Note that the supplier will be invoked on the caller thread.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param verticleSupplier 
   * @param options 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<String> deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __deployVerticle(verticleSupplier, options, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Vertx#deployVerticle(Supplier<Verticle>,DeploymentOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param verticleSupplier 
   * @param options 
   * @return the String instance produced by the operation
   */
  public String deployVerticleAndAwait(Supplier<Verticle> verticleSupplier, DeploymentOptions options) { 
    return (String) deployVerticle(verticleSupplier, options).await().indefinitely();
  }

  /**
   * @param factory the factory to register
   */
  public void registerVerticleFactory(VerticleFactory factory) { 
    delegate.registerVerticleFactory(factory);
  }

  /**
   * @param factory the factory to unregister
   */
  public void unregisterVerticleFactory(VerticleFactory factory) { 
    delegate.unregisterVerticleFactory(factory);
  }

  /**
   * @return the set of verticle factories
   */
  public Set<VerticleFactory> verticleFactories() { 
    Set<VerticleFactory> ret = delegate.verticleFactories();
    return ret;
  }

  /**
   * @return the EventLoopGroup
   */
  public EventLoopGroup nettyEventLoopGroup() { 
    EventLoopGroup ret = delegate.nettyEventLoopGroup();
    return ret;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.Vertx#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.Vertx#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.Vertx#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.Vertx#deployVerticle(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.Vertx#deployVerticle(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.Vertx#deployVerticle(String)} but you don't need to compose it with other operations.
   * @param name the name.
   */
  public void deployVerticleAndForget(String name) { 
    delegate.deployVerticle(name);
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.Vertx#deployVerticle(String,DeploymentOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.Vertx#deployVerticle(String,DeploymentOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.Vertx#deployVerticle(String,DeploymentOptions)} but you don't need to compose it with other operations.
   * @param name the name
   * @param options the deployment options.
   */
  public void deployVerticleAndForget(String name, DeploymentOptions options) { 
    delegate.deployVerticle(name, options);
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.Vertx#undeploy(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.Vertx#undeploy(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.Vertx#undeploy(String)} but you don't need to compose it with other operations.
   * @param deploymentID the deployment ID
   */
  public void undeployAndForget(String deploymentID) { 
    delegate.undeploy(deploymentID);
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.Vertx#deployVerticle(Verticle)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.Vertx#deployVerticle(Verticle)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.Vertx#deployVerticle(Verticle)} but you don't need to compose it with other operations.
   * @param verticle the verticle instance to deploy.
   */
  public void deployVerticleAndForget(Verticle verticle) { 
    delegate.deployVerticle(verticle);
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.Vertx#deployVerticle(Verticle,DeploymentOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.Vertx#deployVerticle(Verticle,DeploymentOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.Vertx#deployVerticle(Verticle,DeploymentOptions)} but you don't need to compose it with other operations.
   * @param verticle the verticle instance to deploy
   * @param options the deployment options.
   */
  public void deployVerticleAndForget(Verticle verticle, DeploymentOptions options) { 
    delegate.deployVerticle(verticle, options);
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.Vertx#deployVerticle(Supplier<Verticle>,DeploymentOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.Vertx#deployVerticle(Supplier<Verticle>,DeploymentOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.Vertx#deployVerticle(Supplier<Verticle>,DeploymentOptions)} but you don't need to compose it with other operations.
   * @param verticleSupplier 
   * @param options 
   */
  public void deployVerticleAndForget(Supplier<Verticle> verticleSupplier, DeploymentOptions options) { 
    delegate.deployVerticle(verticleSupplier, options);
  }

  private io.vertx.mutiny.core.file.FileSystem cached_0;
  private io.vertx.mutiny.core.eventbus.EventBus cached_1;
  private io.vertx.mutiny.core.shareddata.SharedData cached_2;
  private java.lang.Boolean cached_3;
  public static  Vertx newInstance(io.vertx.core.Vertx arg) {
    return arg != null ? new Vertx(arg) : null;
  }

}
