/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.Gatherer;
import io.smallrye.mutiny.groups.Gatherers;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.MultiGather;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

@Experimental(value="This API is still being designed and may change in the future")
public class MultiOnItemGather<I> {
    private final Multi<I> upstream;

    public MultiOnItemGather(Multi<I> upstream) {
        this.upstream = upstream;
    }

    @CheckReturnValue
    public <ACC> InitialAccumulatorStep<I, ACC> into(Supplier<ACC> initialAccumulatorSupplier) {
        ParameterValidation.nonNull(initialAccumulatorSupplier, "initialAccumulatorSupplier");
        return new InitialAccumulatorStep<I, ACC>(this.upstream, initialAccumulatorSupplier);
    }

    public static class InitialAccumulatorStep<I, ACC> {
        private final Multi<I> upstream;
        private final Supplier<ACC> initialAccumulatorSupplier;

        private InitialAccumulatorStep(Multi<I> upstream, Supplier<ACC> initialAccumulatorSupplier) {
            this.upstream = upstream;
            this.initialAccumulatorSupplier = initialAccumulatorSupplier;
        }

        @CheckReturnValue
        public ExtractStep<I, ACC> accumulate(BiFunction<ACC, I, ACC> accumulator) {
            ParameterValidation.nonNull(accumulator, "accumulator");
            return new ExtractStep<I, ACC>(this.upstream, this.initialAccumulatorSupplier, accumulator);
        }
    }

    public static class FinalizerStep<I, ACC, O> {
        private final Multi<I> upstream;
        private final Supplier<ACC> initialAccumulatorSupplier;
        private final BiFunction<ACC, I, ACC> accumulator;
        private final BiFunction<ACC, Boolean, Optional<Gatherer.Extraction<ACC, O>>> extractor;

        private FinalizerStep(Multi<I> upstream, Supplier<ACC> initialAccumulatorSupplier, BiFunction<ACC, I, ACC> accumulator, BiFunction<ACC, Boolean, Optional<Gatherer.Extraction<ACC, O>>> extractor) {
            this.upstream = upstream;
            this.initialAccumulatorSupplier = initialAccumulatorSupplier;
            this.accumulator = accumulator;
            this.extractor = extractor;
        }

        @CheckReturnValue
        public Multi<O> finalize(Function<ACC, Optional<O>> finalizer) {
            ParameterValidation.nonNull(finalizer, "finalizer");
            return new MultiGather<I, ACC, O>(this.upstream, Gatherers.of(this.initialAccumulatorSupplier, this.accumulator, this.extractor, finalizer));
        }
    }

    public static class ExtractStep<I, ACC> {
        private final Multi<I> upstream;
        private final Supplier<ACC> initialAccumulatorSupplier;
        private final BiFunction<ACC, I, ACC> accumulator;

        private ExtractStep(Multi<I> upstream, Supplier<ACC> initialAccumulatorSupplier, BiFunction<ACC, I, ACC> accumulator) {
            this.upstream = upstream;
            this.initialAccumulatorSupplier = initialAccumulatorSupplier;
            this.accumulator = accumulator;
        }

        @CheckReturnValue
        public <O> FinalizerStep<I, ACC, O> extract(BiFunction<ACC, Boolean, Optional<Gatherer.Extraction<ACC, O>>> extractor) {
            ParameterValidation.nonNull(extractor, "extractor");
            return new FinalizerStep<I, ACC, O>(this.upstream, this.initialAccumulatorSupplier, this.accumulator, extractor);
        }
    }
}

