/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.extras.reflect;

import io.smallrye.classfile.extras.reflect.ClassFileFormatVersion;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class AccessFlag
extends Enum<AccessFlag> {
    public static final /* enum */ AccessFlag PUBLIC = new AccessFlag(1, true, Location.SET_CLASS_FIELD_METHOD_INNER_CLASS, List.of(Map.entry(ClassFileFormatVersion.RELEASE_0, Location.SET_CLASS_FIELD_METHOD)));
    public static final /* enum */ AccessFlag PRIVATE = new AccessFlag(2, true, Location.SET_FIELD_METHOD_INNER_CLASS, List.of(Map.entry(ClassFileFormatVersion.RELEASE_0, Location.SET_FIELD_METHOD)));
    public static final /* enum */ AccessFlag PROTECTED = new AccessFlag(4, true, Location.SET_FIELD_METHOD_INNER_CLASS, List.of(Map.entry(ClassFileFormatVersion.RELEASE_0, Location.SET_FIELD_METHOD)));
    public static final /* enum */ AccessFlag STATIC = new AccessFlag(8, true, Location.SET_FIELD_METHOD_INNER_CLASS, List.of(Map.entry(ClassFileFormatVersion.RELEASE_0, Location.SET_FIELD_METHOD)));
    public static final /* enum */ AccessFlag FINAL = new AccessFlag(16, true, Location.SET_FINAL_8, List.of(Map.entry(ClassFileFormatVersion.RELEASE_7, Location.SET_CLASS_FIELD_METHOD_INNER_CLASS), Map.entry(ClassFileFormatVersion.RELEASE_0, Location.SET_CLASS_FIELD_METHOD)));
    public static final /* enum */ AccessFlag SUPER = new AccessFlag(32, false, Location.SET_CLASS, List.of());
    public static final /* enum */ AccessFlag OPEN = new AccessFlag(32, false, Location.SET_MODULE, List.of(Map.entry(ClassFileFormatVersion.RELEASE_8, Location.EMPTY_SET)));
    public static final /* enum */ AccessFlag TRANSITIVE = new AccessFlag(32, false, Location.SET_MODULE_REQUIRES, List.of(Map.entry(ClassFileFormatVersion.RELEASE_8, Location.EMPTY_SET)));
    public static final /* enum */ AccessFlag SYNCHRONIZED = new AccessFlag(32, true, Location.SET_METHOD, List.of());
    public static final /* enum */ AccessFlag STATIC_PHASE = new AccessFlag(64, false, Location.SET_MODULE_REQUIRES, List.of(Map.entry(ClassFileFormatVersion.RELEASE_8, Location.EMPTY_SET)));
    public static final /* enum */ AccessFlag VOLATILE = new AccessFlag(64, true, Location.SET_FIELD, List.of());
    public static final /* enum */ AccessFlag BRIDGE = new AccessFlag(64, false, Location.SET_METHOD, List.of(Map.entry(ClassFileFormatVersion.RELEASE_4, Location.EMPTY_SET)));
    public static final /* enum */ AccessFlag TRANSIENT = new AccessFlag(128, true, Location.SET_FIELD, List.of());
    public static final /* enum */ AccessFlag VARARGS = new AccessFlag(128, false, Location.SET_METHOD, List.of(Map.entry(ClassFileFormatVersion.RELEASE_4, Location.EMPTY_SET)));
    public static final /* enum */ AccessFlag NATIVE = new AccessFlag(256, true, Location.SET_METHOD, List.of());
    public static final /* enum */ AccessFlag INTERFACE = new AccessFlag(512, false, Location.SET_CLASS_INNER_CLASS, List.of(Map.entry(ClassFileFormatVersion.RELEASE_0, Location.SET_CLASS)));
    public static final /* enum */ AccessFlag ABSTRACT = new AccessFlag(1024, true, Location.SET_CLASS_METHOD_INNER_CLASS, List.of(Map.entry(ClassFileFormatVersion.RELEASE_0, Location.SET_CLASS_METHOD)));
    public static final /* enum */ AccessFlag STRICT = new AccessFlag(2048, true, Location.EMPTY_SET, List.of(Map.entry(ClassFileFormatVersion.RELEASE_16, Location.SET_METHOD), Map.entry(ClassFileFormatVersion.RELEASE_1, Location.EMPTY_SET)));
    public static final /* enum */ AccessFlag SYNTHETIC = new AccessFlag(4096, false, Location.SET_SYNTHETIC_9, List.of(Map.entry(ClassFileFormatVersion.RELEASE_8, Location.SET_SYNTHETIC_8), Map.entry(ClassFileFormatVersion.RELEASE_7, Location.SET_SYNTHETIC_5), Map.entry(ClassFileFormatVersion.RELEASE_4, Location.EMPTY_SET)));
    public static final /* enum */ AccessFlag ANNOTATION = new AccessFlag(8192, false, Location.SET_CLASS_INNER_CLASS, List.of(Map.entry(ClassFileFormatVersion.RELEASE_4, Location.EMPTY_SET)));
    public static final /* enum */ AccessFlag ENUM = new AccessFlag(16384, false, Location.SET_CLASS_FIELD_INNER_CLASS, List.of(Map.entry(ClassFileFormatVersion.RELEASE_4, Location.EMPTY_SET)));
    public static final /* enum */ AccessFlag MANDATED = new AccessFlag(32768, false, Location.SET_MANDATED_9, List.of(Map.entry(ClassFileFormatVersion.RELEASE_8, Location.SET_METHOD_PARAM), Map.entry(ClassFileFormatVersion.RELEASE_7, Location.EMPTY_SET)));
    public static final /* enum */ AccessFlag MODULE = new AccessFlag(32768, false, Location.SET_CLASS, List.of(Map.entry(ClassFileFormatVersion.RELEASE_8, Location.EMPTY_SET)));
    private final int mask;
    private final boolean sourceModifier;
    private final Set<Location> locations;
    private final List<Map.Entry<ClassFileFormatVersion, Set<Location>>> historicalLocations;
    private static final AccessFlag[] CLASS_FLAGS;
    private static final AccessFlag[] FIELD_FLAGS;
    private static final AccessFlag[] METHOD_FLAGS;
    private static final AccessFlag[] INNER_CLASS_FLAGS;
    private static final AccessFlag[] METHOD_PARAMETER_FLAGS;
    private static final AccessFlag[] MODULE_FLAGS;
    private static final AccessFlag[] MODULE_REQUIRES_FLAGS;
    private static final AccessFlag[] MODULE_EXPORTS_FLAGS;
    private static final AccessFlag[] MODULE_OPENS_FLAGS;
    private static final /* synthetic */ AccessFlag[] $VALUES;

    public static AccessFlag[] values() {
        return (AccessFlag[])$VALUES.clone();
    }

    public static AccessFlag valueOf(String name) {
        return Enum.valueOf(AccessFlag.class, name);
    }

    private AccessFlag(int mask, boolean sourceModifier, Set<Location> locations, List<Map.Entry<ClassFileFormatVersion, Set<Location>>> historicalLocations) {
        this.mask = mask;
        this.sourceModifier = sourceModifier;
        this.locations = locations;
        this.historicalLocations = Location.ensureHistoryOrdered(historicalLocations);
    }

    public int mask() {
        return this.mask;
    }

    public boolean sourceModifier() {
        return this.sourceModifier;
    }

    public Set<Location> locations() {
        return this.locations;
    }

    public Set<Location> locations(ClassFileFormatVersion cffv) {
        return Location.findInHistory(this.locations, this.historicalLocations, cffv);
    }

    public static Set<AccessFlag> maskToAccessFlags(int mask, Location location) {
        AccessFlag[] definition = AccessFlag.findDefinition(location);
        int unmatchedMask = mask & ~location.flagsMask();
        if (unmatchedMask != 0) {
            throw new IllegalArgumentException("Unmatched bit position 0x" + Integer.toHexString(unmatchedMask) + " for location " + String.valueOf((Object)location));
        }
        return new AccessFlagSet(definition, mask);
    }

    public static Set<AccessFlag> maskToAccessFlags(int mask, Location location, ClassFileFormatVersion cffv) {
        AccessFlag[] definition = AccessFlag.findDefinition(location);
        int unmatchedMask = mask & ~location.flagsMask(cffv);
        if (unmatchedMask != 0) {
            throw new IllegalArgumentException("Unmatched bit position 0x" + Integer.toHexString(unmatchedMask) + " for location " + String.valueOf((Object)location) + " for class file format " + String.valueOf((Object)cffv));
        }
        return new AccessFlagSet(definition, mask);
    }

    private static AccessFlag[] createDefinition(AccessFlag ... known) {
        AccessFlag[] ret = new AccessFlag[16];
        for (AccessFlag flag : known) {
            int mask = flag.mask;
            int pos = Integer.numberOfTrailingZeros(mask);
            assert (ret[pos] == null) : String.valueOf((Object)ret[pos]) + " " + String.valueOf((Object)flag);
            ret[pos] = flag;
        }
        return ret;
    }

    private static AccessFlag[] findDefinition(Location location) {
        return switch (location.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> CLASS_FLAGS;
            case 1 -> FIELD_FLAGS;
            case 2 -> METHOD_FLAGS;
            case 3 -> INNER_CLASS_FLAGS;
            case 4 -> METHOD_PARAMETER_FLAGS;
            case 5 -> MODULE_FLAGS;
            case 6 -> MODULE_REQUIRES_FLAGS;
            case 7 -> MODULE_EXPORTS_FLAGS;
            case 8 -> MODULE_OPENS_FLAGS;
        };
    }

    private static int undefinedMask(AccessFlag[] definition, int mask) {
        assert (definition.length == 16);
        int definedMask = 0;
        for (int i = 0; i < 16; ++i) {
            if (definition[i] == null) continue;
            definedMask |= 1 << i;
        }
        return mask & ~definedMask;
    }

    private static /* synthetic */ AccessFlag[] $values() {
        return new AccessFlag[]{PUBLIC, PRIVATE, PROTECTED, STATIC, FINAL, SUPER, OPEN, TRANSITIVE, SYNCHRONIZED, STATIC_PHASE, VOLATILE, BRIDGE, TRANSIENT, VARARGS, NATIVE, INTERFACE, ABSTRACT, STRICT, SYNTHETIC, ANNOTATION, ENUM, MANDATED, MODULE};
    }

    static {
        $VALUES = AccessFlag.$values();
        CLASS_FLAGS = AccessFlag.createDefinition(PUBLIC, FINAL, SUPER, INTERFACE, ABSTRACT, SYNTHETIC, ANNOTATION, ENUM, MODULE);
        FIELD_FLAGS = AccessFlag.createDefinition(PUBLIC, PRIVATE, PROTECTED, STATIC, FINAL, VOLATILE, TRANSIENT, SYNTHETIC, ENUM);
        METHOD_FLAGS = AccessFlag.createDefinition(PUBLIC, PRIVATE, PROTECTED, STATIC, FINAL, SYNCHRONIZED, BRIDGE, VARARGS, NATIVE, ABSTRACT, STRICT, SYNTHETIC);
        INNER_CLASS_FLAGS = AccessFlag.createDefinition(PUBLIC, PRIVATE, PROTECTED, STATIC, FINAL, INTERFACE, ABSTRACT, SYNTHETIC, ANNOTATION, ENUM);
        METHOD_PARAMETER_FLAGS = AccessFlag.createDefinition(FINAL, SYNTHETIC, MANDATED);
        MODULE_FLAGS = AccessFlag.createDefinition(OPEN, SYNTHETIC, MANDATED);
        MODULE_REQUIRES_FLAGS = AccessFlag.createDefinition(TRANSITIVE, STATIC_PHASE, SYNTHETIC, MANDATED);
        MODULE_EXPORTS_FLAGS = AccessFlag.createDefinition(SYNTHETIC, MANDATED);
        MODULE_OPENS_FLAGS = AccessFlag.createDefinition(SYNTHETIC, MANDATED);
    }

    public static enum Location {
        CLASS(63025, List.of(Map.entry(ClassFileFormatVersion.RELEASE_8, 30257), Map.entry(ClassFileFormatVersion.RELEASE_4, 1585))),
        FIELD(20703, List.of(Map.entry(ClassFileFormatVersion.RELEASE_4, 223))),
        METHOD(5631, List.of(Map.entry(ClassFileFormatVersion.RELEASE_16, 7679), Map.entry(ClassFileFormatVersion.RELEASE_4, 3391), Map.entry(ClassFileFormatVersion.RELEASE_1, 1343))),
        INNER_CLASS(30239, List.of(Map.entry(ClassFileFormatVersion.RELEASE_4, 1567), Map.entry(ClassFileFormatVersion.RELEASE_0, 0))),
        METHOD_PARAMETER(36880, List.of(Map.entry(ClassFileFormatVersion.RELEASE_7, 0))),
        MODULE(36896, List.of(Map.entry(ClassFileFormatVersion.RELEASE_8, 0))),
        MODULE_REQUIRES(36960, List.of(Map.entry(ClassFileFormatVersion.RELEASE_8, 0))),
        MODULE_EXPORTS(36864, List.of(Map.entry(ClassFileFormatVersion.RELEASE_8, 0))),
        MODULE_OPENS(36864, List.of(Map.entry(ClassFileFormatVersion.RELEASE_8, 0)));

        private static final Set<Location> EMPTY_SET;
        private static final Set<Location> SET_MODULE;
        private static final Set<Location> SET_CLASS_METHOD_INNER_CLASS;
        private static final Set<Location> SET_CLASS_FIELD_METHOD;
        private static final Set<Location> SET_CLASS_FIELD_INNER_CLASS;
        private static final Set<Location> SET_CLASS_FIELD_METHOD_INNER_CLASS;
        private static final Set<Location> SET_CLASS_METHOD;
        private static final Set<Location> SET_FIELD_METHOD;
        private static final Set<Location> SET_FIELD_METHOD_INNER_CLASS;
        private static final Set<Location> SET_METHOD;
        private static final Set<Location> SET_METHOD_PARAM;
        private static final Set<Location> SET_FIELD;
        private static final Set<Location> SET_CLASS;
        private static final Set<Location> SET_CLASS_INNER_CLASS;
        private static final Set<Location> SET_MODULE_REQUIRES;
        private static final Set<Location> SET_FINAL_8;
        private static final Set<Location> SET_SYNTHETIC_5;
        private static final Set<Location> SET_SYNTHETIC_8;
        private static final Set<Location> SET_SYNTHETIC_9;
        private static final Set<Location> SET_MANDATED_9;
        private final int flagsMask;
        private final List<Map.Entry<ClassFileFormatVersion, Integer>> historicalFlagsMasks;

        private Location(int flagsMask, List<Map.Entry<ClassFileFormatVersion, Integer>> historicalFlagsMasks) {
            this.flagsMask = flagsMask;
            this.historicalFlagsMasks = Location.ensureHistoryOrdered(historicalFlagsMasks);
        }

        private static <T> List<Map.Entry<ClassFileFormatVersion, T>> ensureHistoryOrdered(List<Map.Entry<ClassFileFormatVersion, T>> history) {
            ClassFileFormatVersion lastVersion = ClassFileFormatVersion.latest();
            for (Map.Entry<ClassFileFormatVersion, T> e : history) {
                ClassFileFormatVersion historyVersion = e.getKey();
                if (lastVersion.compareTo(historyVersion) <= 0) {
                    throw new IllegalArgumentException("Versions out of order");
                }
                lastVersion = historyVersion;
            }
            return history;
        }

        private static <T> T findInHistory(T candidate, List<Map.Entry<ClassFileFormatVersion, T>> history, ClassFileFormatVersion cffv) {
            Objects.requireNonNull(cffv);
            for (Map.Entry<ClassFileFormatVersion, T> e : history) {
                if (e.getKey().compareTo(cffv) < 0) {
                    return candidate;
                }
                candidate = e.getValue();
            }
            return candidate;
        }

        public int flagsMask() {
            return this.flagsMask;
        }

        public int flagsMask(ClassFileFormatVersion cffv) {
            return Location.findInHistory(this.flagsMask, this.historicalFlagsMasks, cffv);
        }

        public Set<AccessFlag> flags() {
            return new AccessFlagSet(AccessFlag.findDefinition(this), this.flagsMask());
        }

        public Set<AccessFlag> flags(ClassFileFormatVersion cffv) {
            return new AccessFlagSet(AccessFlag.findDefinition(this), this.flagsMask(cffv));
        }

        static {
            EMPTY_SET = Set.of();
            SET_MODULE = Set.of(MODULE);
            SET_CLASS_METHOD_INNER_CLASS = Set.of(CLASS, METHOD, INNER_CLASS);
            SET_CLASS_FIELD_METHOD = Set.of(CLASS, FIELD, METHOD);
            SET_CLASS_FIELD_INNER_CLASS = Set.of(CLASS, FIELD, INNER_CLASS);
            SET_CLASS_FIELD_METHOD_INNER_CLASS = Set.of(CLASS, FIELD, METHOD, INNER_CLASS);
            SET_CLASS_METHOD = Set.of(CLASS, METHOD);
            SET_FIELD_METHOD = Set.of(FIELD, METHOD);
            SET_FIELD_METHOD_INNER_CLASS = Set.of(FIELD, METHOD, INNER_CLASS);
            SET_METHOD = Set.of(METHOD);
            SET_METHOD_PARAM = Set.of(METHOD_PARAMETER);
            SET_FIELD = Set.of(FIELD);
            SET_CLASS = Set.of(CLASS);
            SET_CLASS_INNER_CLASS = Set.of(CLASS, INNER_CLASS);
            SET_MODULE_REQUIRES = Set.of(MODULE_REQUIRES);
            SET_FINAL_8 = Set.of(CLASS, FIELD, METHOD, INNER_CLASS, METHOD_PARAMETER);
            SET_SYNTHETIC_5 = Set.of(CLASS, FIELD, METHOD, INNER_CLASS);
            SET_SYNTHETIC_8 = Set.of(CLASS, FIELD, METHOD, INNER_CLASS, METHOD_PARAMETER);
            SET_SYNTHETIC_9 = Set.of(CLASS, FIELD, METHOD, INNER_CLASS, METHOD_PARAMETER, MODULE, MODULE_REQUIRES, MODULE_EXPORTS, MODULE_OPENS);
            SET_MANDATED_9 = Set.of(METHOD_PARAMETER, MODULE, MODULE_REQUIRES, MODULE_EXPORTS, MODULE_OPENS);
        }
    }

    private static final class AccessFlagSet
    extends AbstractSet<AccessFlag> {
        private final AccessFlag[] definition;
        private final int mask;

        @Override
        public boolean add(AccessFlag e) {
            throw AccessFlagSet.uoe();
        }

        @Override
        public boolean addAll(Collection<? extends AccessFlag> c) {
            throw AccessFlagSet.uoe();
        }

        @Override
        public void clear() {
            throw AccessFlagSet.uoe();
        }

        @Override
        public boolean remove(Object o) {
            throw AccessFlagSet.uoe();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw AccessFlagSet.uoe();
        }

        @Override
        public boolean removeIf(Predicate<? super AccessFlag> filter) {
            throw AccessFlagSet.uoe();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw AccessFlagSet.uoe();
        }

        private static UnsupportedOperationException uoe() {
            return new UnsupportedOperationException();
        }

        private AccessFlagSet(AccessFlag[] definition, int mask) {
            assert (AccessFlag.undefinedMask(definition, mask) == 0) : mask;
            this.definition = definition;
            this.mask = mask;
        }

        @Override
        public Iterator<AccessFlag> iterator() {
            return new AccessFlagIterator(this.definition, this.mask);
        }

        @Override
        public void forEach(Consumer<? super AccessFlag> action) {
            Objects.requireNonNull(action);
            for (int i = 0; i < 16; ++i) {
                if ((this.mask & 1 << i) == 0) continue;
                action.accept(this.definition[i]);
            }
        }

        @Override
        public int size() {
            return Integer.bitCount(this.mask);
        }

        @Override
        public boolean contains(Object o) {
            Object object = Objects.requireNonNull(o);
            if (object instanceof AccessFlag) {
                AccessFlag flag = (AccessFlag)((Object)object);
                int bit = flag.mask;
                return (bit & this.mask) != 0 && this.definition[Integer.numberOfTrailingZeros(bit)] == flag;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.mask == 0;
        }

        private static final class AccessFlagIterator
        implements Iterator<AccessFlag> {
            private final AccessFlag[] definition;
            private int remainingMask;

            private AccessFlagIterator(AccessFlag[] definition, int remainingMask) {
                this.definition = definition;
                this.remainingMask = remainingMask;
            }

            @Override
            public boolean hasNext() {
                return this.remainingMask != 0;
            }

            @Override
            public AccessFlag next() {
                int flagBit = Integer.lowestOneBit(this.remainingMask);
                if (flagBit == 0) {
                    throw new NoSuchElementException();
                }
                this.remainingMask &= ~flagBit;
                return this.definition[Integer.numberOfTrailingZeros(flagBit)];
            }
        }
    }
}

