/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.loadbalance.Quantile;
import java.util.SplittableRandom;

class FrugalQuantile
implements Quantile {
    final double increment;
    final SplittableRandom rnd;
    int step;
    int sign;
    double quantile;
    volatile double estimate;

    public FrugalQuantile(double quantile, double increment) {
        this.increment = increment;
        this.quantile = quantile;
        this.estimate = 0.0;
        this.step = 1;
        this.sign = 0;
        this.rnd = new SplittableRandom(System.nanoTime());
    }

    public FrugalQuantile(double quantile) {
        this(quantile, 1.0);
    }

    public synchronized void reset(double quantile) {
        this.quantile = quantile;
        this.estimate = 0.0;
        this.step = 1;
        this.sign = 0;
    }

    @Override
    public double estimation() {
        return this.estimate;
    }

    @Override
    public synchronized void insert(double x) {
        if (this.sign == 0) {
            this.estimate = x;
            this.sign = 1;
        } else {
            double v = this.rnd.nextDouble();
            double estimate = this.estimate;
            if (x > estimate && v > 1.0 - this.quantile) {
                this.higher(x);
            } else if (x < estimate && v > this.quantile) {
                this.lower(x);
            }
        }
    }

    private void higher(double x) {
        double estimate = this.estimate;
        this.step = (int)((double)this.step + (double)this.sign * this.increment);
        estimate = this.step > 0 ? (estimate += (double)this.step) : (estimate += 1.0);
        if (estimate > x) {
            this.step = (int)((double)this.step + (x - estimate));
            estimate = x;
        }
        if (this.sign < 0) {
            this.step = 1;
        }
        this.sign = 1;
        this.estimate = estimate;
    }

    private void lower(double x) {
        double estimate = this.estimate;
        this.step = (int)((double)this.step - (double)this.sign * this.increment);
        estimate = this.step > 0 ? (estimate -= (double)this.step) : (estimate -= 1.0);
        if (estimate < x) {
            this.step = (int)((double)this.step + (estimate - x));
            estimate = x;
        }
        if (this.sign > 0) {
            this.step = 1;
        }
        this.sign = -1;
        this.estimate = estimate;
    }

    public String toString() {
        return "FrugalQuantile(q=" + this.quantile + ", v=" + this.estimate + ")";
    }
}

