/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.rsocket.RSocketErrorException;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import java.nio.charset.StandardCharsets;

public class ErrorFrameCodec {
    public static final int INVALID_SETUP = 1;
    public static final int UNSUPPORTED_SETUP = 2;
    public static final int REJECTED_SETUP = 3;
    public static final int REJECTED_RESUME = 4;
    public static final int CONNECTION_ERROR = 257;
    public static final int CONNECTION_CLOSE = 258;
    public static final int APPLICATION_ERROR = 513;
    public static final int REJECTED = 514;
    public static final int CANCELED = 515;
    public static final int INVALID = 516;
    public static final int MIN_USER_ALLOWED_ERROR_CODE = 769;
    public static final int MAX_USER_ALLOWED_ERROR_CODE = -2;

    public static ByteBuf encode(ByteBufAllocator allocator, int streamId, Throwable t, ByteBuf data) {
        ByteBuf header = FrameHeaderCodec.encode(allocator, streamId, FrameType.ERROR, 0);
        int errorCode = t instanceof RSocketErrorException ? ((RSocketErrorException)t).errorCode() : 513;
        header.writeInt(errorCode);
        return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{header, data});
    }

    public static ByteBuf encode(ByteBufAllocator allocator, int streamId, Throwable t) {
        String message = t.getMessage() == null ? "" : t.getMessage();
        ByteBuf data = ByteBufUtil.writeUtf8((ByteBufAllocator)allocator, (CharSequence)message);
        return ErrorFrameCodec.encode(allocator, streamId, t, data);
    }

    public static int errorCode(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderCodec.size());
        int i = byteBuf.readInt();
        byteBuf.resetReaderIndex();
        return i;
    }

    public static ByteBuf data(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderCodec.size() + 4);
        ByteBuf slice = byteBuf.slice();
        byteBuf.resetReaderIndex();
        return slice;
    }

    public static String dataUtf8(ByteBuf byteBuf) {
        return ErrorFrameCodec.data(byteBuf).toString(StandardCharsets.UTF_8);
    }
}

