/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;

public class OperatorOnBackpressureDrop<T>
implements Observable.Operator<T, T> {
    public static <T> OperatorOnBackpressureDrop<T> instance() {
        return Holder.INSTANCE;
    }

    private OperatorOnBackpressureDrop() {
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final AtomicLong requested = new AtomicLong();
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                requested.getAndAdd(n);
            }
        });
        return new Subscriber<T>(child){

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                child.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onNext(T t) {
                if (requested.get() > 0L) {
                    child.onNext(t);
                    requested.decrementAndGet();
                }
            }
        };
    }

    private static final class Holder {
        static final OperatorOnBackpressureDrop<Object> INSTANCE = new OperatorOnBackpressureDrop();

        private Holder() {
        }
    }
}

