/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.ErrorInitializer;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

final class SectionInitContextImpl
implements SectionHelperFactory.SectionInitContext {
    private final EngineImpl engine;
    private final List<SectionBlock> blocks;
    private final ErrorInitializer errorInitializer;
    private final Supplier<Template> currentTemplate;
    private final String name;

    SectionInitContextImpl(EngineImpl engine, List<SectionBlock> blocks, ErrorInitializer errorInitializer, Supplier<Template> currentTemplate, String name) {
        this.engine = engine;
        this.blocks = blocks;
        this.errorInitializer = errorInitializer;
        this.currentTemplate = currentTemplate;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.blocks.isEmpty() ? Collections.emptyMap() : this.blocks.get((int)0).parameters;
    }

    @Override
    public boolean hasParameter(String name) {
        return this.getParameters().containsKey(name);
    }

    @Override
    public String getParameter(String name) {
        return this.getParameters().get(name);
    }

    @Override
    public Expression getExpression(String parameterName) {
        return this.blocks.isEmpty() ? null : this.blocks.get((int)0).expressions.get(parameterName);
    }

    @Override
    public ExpressionImpl parseValue(String value) {
        return ExpressionImpl.from(value);
    }

    @Override
    public List<SectionBlock> getBlocks() {
        return this.blocks;
    }

    @Override
    public EngineImpl getEngine() {
        return this.engine;
    }

    @Override
    public Supplier<Template> getCurrentTemplate() {
        return this.currentTemplate;
    }

    @Override
    public TemplateException.Builder error(String message) {
        return this.errorInitializer.error(message).origin(this.getOrigin());
    }
}

