/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.deployment;

import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.ConvertWith;
import java.util.Optional;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.Converter;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public class ServletConfig {
    @ConfigItem
    @ConvertWith(value=ContextPathConverter.class)
    Optional<String> contextPath;
    @ConfigItem(defaultValue="UTF-8")
    public String defaultCharset;

    @Priority(value=200)
    public static class ContextPathConverter
    implements Converter<String> {
        private static final String SLASH = "/";

        public String convert(String value) throws IllegalArgumentException, NullPointerException {
            if (value == null) {
                return SLASH;
            }
            if (SLASH.equals(value = ((String)value).trim())) {
                return value;
            }
            if (!((String)value).startsWith(SLASH)) {
                value = SLASH + (String)value;
            }
            return value;
        }
    }
}

