/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Objects;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class TypeCheckExcludeBuildItem
extends MultiBuildItem {
    private final Predicate<TypeCheck> predicate;

    public TypeCheckExcludeBuildItem(Predicate<TypeCheck> predicate) {
        this.predicate = Objects.requireNonNull(predicate);
    }

    public Predicate<TypeCheck> getPredicate() {
        return this.predicate;
    }

    public static class TypeCheck {
        public final String name;
        public final ClassInfo clazz;
        public final int numberOfParameters;

        public TypeCheck(String name, ClassInfo clazz, int parameters) {
            this.name = Objects.requireNonNull(name, "Name must not be null");
            this.clazz = clazz;
            this.numberOfParameters = parameters;
        }

        public boolean nameIn(String ... values) {
            for (String value : values) {
                if (!this.name.equals(value)) continue;
                return true;
            }
            return false;
        }

        public boolean isProperty() {
            return this.numberOfParameters == -1;
        }

        public boolean classNameEquals(DotName name) {
            return this.clazz != null ? this.clazz.name().equals((Object)name) : false;
        }
    }
}

