/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx;

import io.vertx.core.http.HttpServerRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VertxUtil {
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final Pattern FORWARDED_FOR_PATTERN = Pattern.compile("for=\"?([^;,\"]+)\"?");
    private static final String FORWARDED = "Forwarded";
    private static final String COMMA_SPLITTER = ",";
    private static final char COLON_SPLITTER = ':';
    private static final int SPLIT_LIMIT = -1;

    private VertxUtil() {
    }

    private static String getForwardedHeaderValue(HttpServerRequest httpServerRequest) {
        String forwardedHeader = httpServerRequest.getHeader(FORWARDED);
        if (forwardedHeader == null) {
            return null;
        }
        Matcher forwardedHeaderMatcher = FORWARDED_FOR_PATTERN.matcher(forwardedHeader);
        if (forwardedHeaderMatcher.find()) {
            return forwardedHeaderMatcher.group(1).trim();
        }
        return null;
    }

    private static String getXForwardedHeaderValue(HttpServerRequest httpServerRequest) {
        String xForwardedForHeader = httpServerRequest.getHeader(X_FORWARDED_FOR);
        if (xForwardedForHeader == null) {
            return null;
        }
        return xForwardedForHeader.split(COMMA_SPLITTER, -1)[0];
    }

    public static String extractClientIP(HttpServerRequest httpServerRequest) {
        String forwardedHeaderValue = VertxUtil.getForwardedHeaderValue(httpServerRequest);
        if (forwardedHeaderValue != null) {
            return forwardedHeaderValue;
        }
        String xForwardedHeaderValue = VertxUtil.getXForwardedHeaderValue(httpServerRequest);
        if (xForwardedHeaderValue != null) {
            return xForwardedHeaderValue;
        }
        return httpServerRequest.remoteAddress() != null ? httpServerRequest.remoteAddress().host() : null;
    }

    public static String extractRemoteHostname(HttpServerRequest httpRequest) {
        String header = httpRequest.getHeader("host");
        if (header == null) {
            return null;
        }
        String hostname = VertxUtil.beforeDelimiter(header, ':');
        if (hostname != null) {
            return hostname;
        }
        return httpRequest.remoteAddress() != null ? httpRequest.remoteAddress().hostName() : null;
    }

    public static Long extractRemoteHostPort(HttpServerRequest httpRequest) {
        String header = httpRequest.getHeader("host");
        if (header == null) {
            return null;
        }
        String portString = VertxUtil.afterDelimiter(header, ':');
        if (portString != null) {
            try {
                return Long.parseLong(portString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (httpRequest.remoteAddress() != null) {
            return Integer.toUnsignedLong(httpRequest.remoteAddress().port());
        }
        return null;
    }

    public static String extractHostname(String address) {
        if (address == null) {
            return "";
        }
        return VertxUtil.beforeDelimiter(address, ':');
    }

    public static Integer extractPort(String address) {
        if (address == null) {
            return -1;
        }
        String portString = VertxUtil.afterDelimiter(address, ':');
        if (portString != null) {
            try {
                return Integer.parseInt(portString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static String beforeDelimiter(String str, char delimiter) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        int index = str.indexOf(delimiter);
        return index >= 0 ? str.substring(0, index) : str;
    }

    private static String afterDelimiter(String str, char delimiter) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        int index = str.indexOf(delimiter);
        if (index < 0) {
            return null;
        }
        if (index >= 0 && index + 1 < str.length()) {
            return str.substring(index + 1);
        }
        return "";
    }
}

