/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jackson.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.jackson.runtime.JacksonSupport;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.shutdown.ShutdownListener;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

@Recorder
public class JacksonRecorder {
    public Supplier<JacksonSupport> supplier(final Optional<String> propertyNamingStrategyClassName) {
        return new Supplier<JacksonSupport>(){

            @Override
            public JacksonSupport get() {
                return new JacksonSupport(){

                    @Override
                    public Optional<PropertyNamingStrategies.NamingBase> configuredNamingStrategy() {
                        if (propertyNamingStrategyClassName.isPresent()) {
                            try {
                                PropertyNamingStrategies.NamingBase value = (PropertyNamingStrategies.NamingBase)Class.forName((String)propertyNamingStrategyClassName.get(), true, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                return Optional.of(value);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return Optional.empty();
                    }
                };
            }
        };
    }

    public Supplier<ObjectMapperCustomizer> customizerSupplier(final Map<Class<?>, Class<?>> mixinsMap) {
        return new Supplier<ObjectMapperCustomizer>(){

            @Override
            public ObjectMapperCustomizer get() {
                return new ObjectMapperCustomizer(){

                    @Override
                    public void customize(ObjectMapper objectMapper) {
                        for (Map.Entry entry : mixinsMap.entrySet()) {
                            objectMapper.addMixIn((Class)entry.getKey(), (Class)entry.getValue());
                        }
                    }

                    @Override
                    public int priority() {
                        return 1;
                    }
                };
            }
        };
    }

    public ShutdownListener clearCachesOnShutdown() {
        return new ShutdownListener(){

            public void shutdown(ShutdownListener.ShutdownNotification notification) {
                TypeFactory.defaultInstance().clearCache();
            }
        };
    }
}

