/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.deployment.devmode.HotReplacementSetup;
import io.quarkus.dev.ClassLoaderCompiler;
import io.quarkus.dev.CompilationProvider;
import io.quarkus.dev.DevModeContext;
import io.quarkus.dev.RuntimeUpdatesProcessor;
import io.quarkus.runner.RuntimeRunner;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.Timing;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class DevModeMain
implements Closeable {
    public static final String DEV_MODE_CONTEXT = "META-INF/dev-mode-context.dat";
    private static final Logger log = Logger.getLogger(DevModeMain.class);
    private static volatile ClassLoader currentAppClassLoader;
    private static volatile URLClassLoader runtimeCl;
    private final DevModeContext context;
    private static volatile Closeable runner;
    static volatile Throwable deploymentProblem;
    static volatile Throwable compileProblem;
    static volatile RuntimeUpdatesProcessor runtimeUpdatesProcessor;
    private List<HotReplacementSetup> hotReplacement = new ArrayList<HotReplacementSetup>();
    private final Map<Class<?>, Object> liveReloadContext = new ConcurrentHashMap();

    public DevModeMain(DevModeContext context) {
        this.context = context;
    }

    public static void main(String ... args) throws Exception {
        Timing.staticInitStarted();
        try (InputStream devModeCp = DevModeMain.class.getClassLoader().getResourceAsStream(DEV_MODE_CONTEXT);){
            DevModeContext context = (DevModeContext)new ObjectInputStream(new DataInputStream(devModeCp)).readObject();
            new DevModeMain(context).start();
            LockSupport.park();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() throws Exception {
        for (Map.Entry<String, String> i : this.context.getSystemProperties().entrySet()) {
            if (System.getProperties().containsKey(i.getKey())) continue;
            System.setProperty(i.getKey(), i.getValue());
        }
        for (HotReplacementSetup service : ServiceLoader.load(HotReplacementSetup.class)) {
            this.hotReplacement.add(service);
        }
        runtimeUpdatesProcessor = this.setupRuntimeCompilation(this.context);
        if (runtimeUpdatesProcessor != null) {
            runtimeUpdatesProcessor.checkForChangedClasses();
        }
        this.doStart(false, Collections.emptySet());
        if ((deploymentProblem != null || compileProblem != null) && this.context.isAbortOnFailedStart()) {
            throw new RuntimeException(deploymentProblem == null ? compileProblem : deploymentProblem);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DevModeMain> clazz = DevModeMain.class;
                synchronized (DevModeMain.class) {
                    if (runner != null) {
                        try {
                            runner.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (runtimeCl != null) {
                        try {
                            runtimeCl.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }, "Quarkus Shutdown Thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doStart(boolean liveReload, Set<String> changedResources) {
        try {
            URL[] urls = new URL[this.context.getClassesRoots().size()];
            for (int i = 0; i < this.context.getClassesRoots().size(); ++i) {
                urls[i] = this.context.getClassesRoots().get(i).toURI().toURL();
            }
            runtimeCl = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
            currentAppClassLoader = runtimeCl;
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(runtimeCl);
                RuntimeRunner.Builder builder = RuntimeRunner.builder().setLaunchMode(LaunchMode.DEVELOPMENT).setLiveReloadState(new LiveReloadBuildItem(liveReload, changedResources, this.liveReloadContext)).setClassLoader((ClassLoader)runtimeCl).setTarget(this.context.getClassesRoots().get(0).toPath()).setTransformerCache(this.context.getCacheDir().toPath());
                if (this.context.getFrameworkClassesDir() != null) {
                    builder.setFrameworkClassesPath(this.context.getFrameworkClassesDir().toPath());
                }
                final ArrayList<Path> addAdditionalHotDeploymentPaths = new ArrayList<Path>();
                for (DevModeContext.ModuleInfo i : this.context.getModules()) {
                    if (i.getClassesPath() == null) continue;
                    Path classesPath = Paths.get(i.getClassesPath(), new String[0]);
                    addAdditionalHotDeploymentPaths.add(classesPath);
                    builder.addAdditionalHotDeploymentPath(classesPath);
                }
                builder.addChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

                    @Override
                    public void accept(BuildChainBuilder buildChainBuilder) {
                        buildChainBuilder.addBuildStep(new BuildStep(){

                            public void execute(BuildContext context) {
                                context.produce((BuildItem)new ApplicationClassPredicateBuildItem(n -> DevModeMain.getClassInApplicationClassPaths(n, addAdditionalHotDeploymentPaths) != null));
                            }
                        }).produces(ApplicationClassPredicateBuildItem.class).build();
                    }
                });
                Properties buildSystemProperties = new Properties();
                buildSystemProperties.putAll(this.context.getBuildSystemProperties());
                builder.setBuildSystemProperties(buildSystemProperties);
                RuntimeRunner runner = builder.build();
                runner.run();
                DevModeMain.runner = runner;
                deploymentProblem = null;
            }
            catch (Throwable t) {
                deploymentProblem = t;
                if (this.context.isAbortOnFailedStart() || liveReload) {
                    log.error((Object)"Failed to start quarkus", t);
                } else {
                    log.error((Object)"Failed to start Quarkus", t);
                    log.info((Object)"Attempting to start hot replacement endpoint to recover from previous Quarkus startup failure");
                    if (runtimeUpdatesProcessor != null) {
                        runtimeUpdatesProcessor.startupFailed();
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        catch (Throwable t) {
            deploymentProblem = t;
            log.error((Object)"Failed to start quarkus", t);
        }
    }

    public synchronized void restartApp(Set<String> changedResources) {
        this.stop();
        Timing.restart();
        this.doStart(true, changedResources);
    }

    public static ClassLoader getCurrentAppClassLoader() {
        return currentAppClassLoader;
    }

    private static Path getClassInApplicationClassPaths(String name, List<Path> addAdditionalHotDeploymentPaths) {
        String fileName = name.replace('.', '/') + ".class";
        for (Path i : addAdditionalHotDeploymentPaths) {
            Path classLocation = i.resolve(fileName);
            if (!Files.exists(classLocation, new LinkOption[0])) continue;
            return classLocation;
        }
        return null;
    }

    private RuntimeUpdatesProcessor setupRuntimeCompilation(DevModeContext context) throws Exception {
        if (!context.getModules().isEmpty()) {
            ClassLoaderCompiler compiler;
            ServiceLoader<CompilationProvider> serviceLoader = ServiceLoader.load(CompilationProvider.class);
            ArrayList<CompilationProvider> compilationProviders = new ArrayList<CompilationProvider>();
            for (CompilationProvider provider : serviceLoader) {
                compilationProviders.add(provider);
                context.getModules().forEach(moduleInfo -> moduleInfo.addSourcePaths(provider.handledSourcePaths()));
            }
            try {
                compiler = new ClassLoaderCompiler(Thread.currentThread().getContextClassLoader(), compilationProviders, context);
            }
            catch (Exception e) {
                log.error((Object)"Failed to create compiler, runtime compilation will be unavailable", (Throwable)e);
                return null;
            }
            RuntimeUpdatesProcessor processor = new RuntimeUpdatesProcessor(context, compiler, this);
            for (HotReplacementSetup service : this.hotReplacement) {
                service.setupHotDeployment((HotReplacementContext)processor);
                processor.addHotReplacementSetup(service);
            }
            return processor;
        }
        return null;
    }

    public void stop() {
        if (runner != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(runtimeCl);
            try {
                runner.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        SmallRyeConfigProviderResolver.instance().releaseConfig(SmallRyeConfigProviderResolver.instance().getConfig());
        runner = null;
    }

    @Override
    public void close() {
        try {
            this.stop();
        }
        finally {
            for (HotReplacementSetup i : this.hotReplacement) {
                i.close();
            }
        }
    }
}

