/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.filesystem;

import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.deployment.dev.filesystem.QuarkusFileManager;
import io.quarkus.runtime.util.ClassPathUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Vector;
import java.util.function.Supplier;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class ReloadableFileManager
extends QuarkusFileManager {
    private final StandardJavaFileManager reloadableFileManager;

    public ReloadableFileManager(Supplier<StandardJavaFileManager> supplier, QuarkusFileManager.Context context) {
        this(supplier.get(), supplier.get(), context);
    }

    protected ReloadableFileManager(StandardJavaFileManager fileManager, StandardJavaFileManager reloadableFileManager, QuarkusFileManager.Context context) {
        super(fileManager, context);
        this.reloadableFileManager = reloadableFileManager;
        try {
            this.reloadableFileManager.setLocation(StandardLocation.CLASS_PATH, context.getReloadableClassPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot initialize reloadable file manager", e);
        }
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        if (this.reloadableFileManager == null) {
            return super.getClassLoader(location);
        }
        ClassLoader staticClassLoader = super.getClassLoader(location);
        if (staticClassLoader == null) {
            return this.reloadableFileManager.getClassLoader(location);
        }
        ClassLoader reloadableClassLoader = this.reloadableFileManager.getClassLoader(location);
        if (reloadableClassLoader == null) {
            return staticClassLoader;
        }
        return new JoinClassLoader(staticClassLoader.getParent(), staticClassLoader, reloadableClassLoader);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return this.combinedIterable(() -> {
            try {
                return super.list(location, packageName, kinds, recurse);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, this.reloadableFileManager == null ? null : () -> {
            try {
                return this.reloadableFileManager.list(location, packageName, kinds, recurse);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        String result = super.inferBinaryName(location, file);
        if (result == null && this.reloadableFileManager != null) {
            return this.reloadableFileManager.inferBinaryName(location, file);
        }
        return result;
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        boolean result = super.handleOption(current, remaining);
        if (!result && this.reloadableFileManager != null) {
            result = this.reloadableFileManager.handleOption(current, remaining);
        }
        return result;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return super.hasLocation(location) || this.reloadableFileManager != null && this.reloadableFileManager.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavaFileObject result = super.getJavaFileForInput(location, className, kind);
        if (result == null && this.reloadableFileManager != null) {
            result = this.reloadableFileManager.getJavaFileForInput(location, className, kind);
        }
        return result;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavaFileObject result = super.getJavaFileForOutput(location, className, kind, sibling);
        if (result == null && this.reloadableFileManager != null) {
            result = this.reloadableFileManager.getJavaFileForOutput(location, className, kind, sibling);
        }
        return result;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        FileObject result = super.getFileForInput(location, packageName, relativeName);
        if (result == null && this.reloadableFileManager != null) {
            result = this.reloadableFileManager.getFileForInput(location, packageName, relativeName);
        }
        return result;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        FileObject result = super.getFileForOutput(location, packageName, relativeName, sibling);
        if (result == null && this.reloadableFileManager != null) {
            result = this.reloadableFileManager.getFileForOutput(location, packageName, relativeName, sibling);
        }
        return result;
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        if (this.reloadableFileManager == null) {
            return super.getLocationForModule(location, moduleName);
        }
        JavaFileManager.Location loc = super.getLocationForModule(location, moduleName);
        return loc != null ? loc : this.reloadableFileManager.getLocationForModule(location, moduleName);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        if (this.reloadableFileManager == null) {
            return super.getLocationForModule(location, fo);
        }
        JavaFileManager.Location loc = super.getLocationForModule(location, fo);
        return loc != null ? loc : this.reloadableFileManager.getLocationForModule(location, fo);
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> service) throws IOException {
        if (this.reloadableFileManager == null) {
            return super.getServiceLoader(location, service);
        }
        ServiceLoader<S> result = super.getServiceLoader(location, service);
        return result != null ? result : this.reloadableFileManager.getServiceLoader(location, service);
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        if (this.reloadableFileManager == null) {
            return super.inferModuleName(location);
        }
        String result = super.inferModuleName(location);
        return result != null ? result : this.reloadableFileManager.inferModuleName(location);
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) {
        return this.combinedIterable(() -> {
            try {
                return super.listLocationsForModules(location);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, this.reloadableFileManager == null ? null : () -> {
            try {
                return this.reloadableFileManager.listLocationsForModules(location);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private <T> Iterable<T> combinedIterable(Supplier<Iterable<T>> required, Supplier<Iterable<T>> optional) {
        if (optional == null) {
            return required.get();
        }
        Iterable requiredIterable = required.get();
        if (requiredIterable == null) {
            return optional.get();
        }
        Iterable optionalIterable = optional.get();
        if (optionalIterable == null) {
            return requiredIterable;
        }
        return () -> {
            final Iterator requiredI = requiredIterable.iterator();
            final Iterator optionalI = optionalIterable.iterator();
            if (!requiredI.hasNext()) {
                return optionalI;
            }
            if (!optionalI.hasNext()) {
                return requiredI;
            }
            return new Iterator<T>(){
                boolean currentIsStatic = true;

                @Override
                public boolean hasNext() {
                    return requiredI.hasNext() || optionalI.hasNext();
                }

                @Override
                public T next() {
                    this.currentIsStatic = requiredI.hasNext();
                    if (this.currentIsStatic) {
                        return requiredI.next();
                    }
                    return optionalI.next();
                }

                @Override
                public void remove() {
                    if (this.currentIsStatic) {
                        requiredI.remove();
                    } else {
                        optionalI.remove();
                    }
                }
            };
        };
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fo) throws IOException {
        return super.contains(location, fo) || this.reloadableFileManager != null && this.reloadableFileManager.contains(location, fo);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaSources(Iterable<? extends File> files) {
        return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromFiles(files);
    }

    @Override
    public void reset(QuarkusFileManager.Context context) {
        try {
            this.reloadableFileManager.close();
            this.reloadableFileManager.setLocation(StandardLocation.CLASS_PATH, context.getReloadableClassPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot reset reloadable file manager", e);
        }
        super.reset(context);
    }

    @Override
    public void close() throws IOException {
        this.reloadableFileManager.close();
        super.close();
    }

    public static class JoinClassLoader
    extends ClassLoader {
        private final ClassLoader[] delegateClassLoaders;

        public JoinClassLoader(ClassLoader parent, ClassLoader ... delegateClassLoaders) {
            super(parent);
            this.delegateClassLoaders = delegateClassLoaders;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            ByteBuffer byteCode;
            String path = ClassLoaderHelper.fromClassNameToResourceName((String)name);
            URL url = this.findResource(path);
            if (url == null) {
                throw new ClassNotFoundException(name);
            }
            try {
                byteCode = this.loadResource(url);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
            return this.defineClass(name, byteCode, null);
        }

        private ByteBuffer loadResource(URL url) throws IOException {
            return (ByteBuffer)ClassPathUtils.readStream((URL)url, stream -> {
                try {
                    return ByteBuffer.wrap(stream.readAllBytes());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }

        @Override
        protected URL findResource(String name) {
            for (ClassLoader delegate : this.delegateClassLoaders) {
                URL resource = delegate.getResource(name);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            Vector<URL> vector = new Vector<URL>();
            for (ClassLoader delegate : this.delegateClassLoaders) {
                Enumeration<URL> enumeration = delegate.getResources(name);
                while (enumeration.hasMoreElements()) {
                    vector.add(enumeration.nextElement());
                }
            }
            return vector.elements();
        }
    }
}

