/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.objectweb.asm.ClassVisitor;

public final class BytecodeTransformerBuildItem
extends MultiBuildItem {
    final boolean eager;
    final String classToTransform;
    final BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction;
    final BiFunction<String, byte[], byte[]> inputTransformer;
    final Set<String> requireConstPoolEntry;
    final boolean cacheable;
    final int classReaderOptions;

    public BytecodeTransformerBuildItem(String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction) {
        this(classToTransform, visitorFunction, null);
    }

    public BytecodeTransformerBuildItem(String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction, Set<String> requireConstPoolEntry) {
        this(false, classToTransform, visitorFunction, requireConstPoolEntry);
    }

    public BytecodeTransformerBuildItem(boolean eager, String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction) {
        this(eager, classToTransform, visitorFunction, null);
    }

    public BytecodeTransformerBuildItem(boolean eager, String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction, boolean cacheable) {
        this(eager, classToTransform, visitorFunction, null, cacheable);
    }

    public BytecodeTransformerBuildItem(boolean eager, String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction, Set<String> requireConstPoolEntry) {
        this(eager, classToTransform, visitorFunction, requireConstPoolEntry, false);
    }

    public BytecodeTransformerBuildItem(boolean eager, String classToTransform, BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction, Set<String> requireConstPoolEntry, boolean cacheable) {
        Objects.requireNonNull(visitorFunction, "visitorFunction");
        this.eager = eager;
        this.classToTransform = classToTransform;
        this.visitorFunction = visitorFunction;
        this.requireConstPoolEntry = requireConstPoolEntry;
        this.cacheable = cacheable;
        this.inputTransformer = null;
        this.classReaderOptions = 0;
    }

    public BytecodeTransformerBuildItem(Builder builder) {
        this.eager = builder.eager;
        this.classToTransform = builder.classToTransform;
        this.visitorFunction = builder.visitorFunction;
        this.requireConstPoolEntry = builder.requireConstPoolEntry;
        this.cacheable = builder.cacheable;
        this.inputTransformer = builder.inputTransformer;
        this.classReaderOptions = builder.classReaderOptions;
        if (this.visitorFunction == null && this.inputTransformer == null) {
            throw new IllegalArgumentException("One of either visitorFunction or inputTransformer must be set");
        }
    }

    public String getClassToTransform() {
        return this.classToTransform;
    }

    public BiFunction<String, ClassVisitor, ClassVisitor> getVisitorFunction() {
        return this.visitorFunction;
    }

    public Set<String> getRequireConstPoolEntry() {
        return this.requireConstPoolEntry;
    }

    public boolean isEager() {
        return this.eager;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public int getClassReaderOptions() {
        return this.classReaderOptions;
    }

    public BiFunction<String, byte[], byte[]> getInputTransformer() {
        return this.inputTransformer;
    }

    public static class Builder {
        public BiFunction<String, byte[], byte[]> inputTransformer;
        private String classToTransform;
        private BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction;
        private Set<String> requireConstPoolEntry = null;
        private boolean eager = false;
        private boolean cacheable = false;
        private int classReaderOptions = 0;

        public Builder setInputTransformer(BiFunction<String, byte[], byte[]> inputTransformer) {
            this.inputTransformer = inputTransformer;
            return this;
        }

        public Builder setClassToTransform(String classToTransform) {
            this.classToTransform = classToTransform;
            return this;
        }

        public Builder setVisitorFunction(BiFunction<String, ClassVisitor, ClassVisitor> visitorFunction) {
            this.visitorFunction = visitorFunction;
            return this;
        }

        public Builder setRequireConstPoolEntry(Set<String> requireConstPoolEntry) {
            this.requireConstPoolEntry = requireConstPoolEntry;
            return this;
        }

        public Builder setEager(boolean eager) {
            this.eager = eager;
            return this;
        }

        public Builder setCacheable(boolean cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        public Builder setClassReaderOptions(int classReaderOptions) {
            this.classReaderOptions = classReaderOptions;
            return this;
        }

        public BytecodeTransformerBuildItem build() {
            return new BytecodeTransformerBuildItem(this);
        }
    }
}

