/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner.bootstrap;

import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.deployment.index.ConstPoolScanner;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.runner.bootstrap.ForkJoinClassLoading;
import io.quarkus.runner.bootstrap.RunningQuarkusApplicationImpl;
import io.quarkus.runtime.Quarkus;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;

public class StartupActionImpl
implements StartupAction {
    private static final Logger log = Logger.getLogger(StartupActionImpl.class);
    private final CuratedApplication curatedApplication;
    private final BuildResult buildResult;
    private final QuarkusClassLoader runtimeClassLoader;

    public StartupActionImpl(CuratedApplication curatedApplication, BuildResult buildResult, ClassLoader deploymentClassLoader) {
        QuarkusClassLoader runtimeClassLoader;
        this.curatedApplication = curatedApplication;
        this.buildResult = buildResult;
        HashSet<String> eagerClasses = new HashSet<String>();
        HashMap<String, Predicate<byte[]>> transformerPredicates = new HashMap<String, Predicate<byte[]>>();
        Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> bytecodeTransformers = this.extractTransformers(eagerClasses, transformerPredicates);
        QuarkusClassLoader baseClassLoader = curatedApplication.getBaseRuntimeClassLoader();
        if (curatedApplication.getQuarkusBootstrap().getMode() == QuarkusBootstrap.Mode.DEV) {
            baseClassLoader.reset(this.extractGeneratedResources(false), bytecodeTransformers, transformerPredicates, deploymentClassLoader);
            runtimeClassLoader = curatedApplication.createRuntimeClassLoader(baseClassLoader, bytecodeTransformers, transformerPredicates, deploymentClassLoader, this.extractGeneratedResources(true));
        } else {
            HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
            resources.putAll(this.extractGeneratedResources(false));
            resources.putAll(this.extractGeneratedResources(true));
            baseClassLoader.reset(resources, bytecodeTransformers, transformerPredicates, deploymentClassLoader);
            runtimeClassLoader = baseClassLoader;
        }
        this.runtimeClassLoader = runtimeClassLoader;
        this.handleEagerClasses(runtimeClassLoader, eagerClasses);
    }

    private void handleEagerClasses(final QuarkusClassLoader runtimeClassLoader, Set<String> eagerClasses) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        if (availableProcessors == 1) {
            return;
        }
        final ExecutorService loadingExecutor = Executors.newFixedThreadPool(availableProcessors - 1);
        for (final String i : eagerClasses) {
            loadingExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.currentThread().setContextClassLoader((ClassLoader)runtimeClassLoader);
                        runtimeClassLoader.loadClass(i);
                    }
                    catch (ClassNotFoundException e) {
                        log.debug((Object)"Failed to eagerly load class", (Throwable)e);
                    }
                }
            });
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                loadingExecutor.shutdown();
            }
        });
        t.start();
    }

    public RunningQuarkusApplication runMainClass(final String ... args) throws Exception {
        ForkJoinClassLoading.setForkJoinClassLoader((ClassLoader)this.runtimeClassLoader);
        ApplicationStateNotification.reset();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.runtimeClassLoader);
        String className = ((MainClassBuildItem)this.buildResult.consume(MainClassBuildItem.class)).getClassName();
        try {
            Class<?> appClass = Class.forName(className, true, (ClassLoader)this.runtimeClassLoader);
            final Method start = appClass.getMethod("main", String[].class);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        Thread.currentThread().setContextClassLoader((ClassLoader)StartupActionImpl.this.runtimeClassLoader);
                        try {
                            start.invoke(null, new Object[]{args == null ? new String[]{} : args});
                        }
                        catch (Throwable e) {
                            log.error((Object)"Error running Quarkus", e);
                            if (ApplicationStateNotification.getState() != ApplicationStateNotification.State.INITIAL) break block2;
                            ApplicationStateNotification.notifyStartupFailed((Throwable)e);
                        }
                    }
                }
            }, "Quarkus Main Thread");
            t.start();
            ApplicationStateNotification.waitForApplicationStart();
            RunningQuarkusApplicationImpl runningQuarkusApplicationImpl = new RunningQuarkusApplicationImpl(new Closeable(){

                @Override
                public void close() throws IOException {
                    try {
                        StartupActionImpl.this.runtimeClassLoader.loadClass(Quarkus.class.getName()).getMethod("blockingExit", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        log.error((Object)"Failed to stop Quarkus", (Throwable)e);
                    }
                    finally {
                        ForkJoinClassLoading.setForkJoinClassLoader(ClassLoader.getSystemClassLoader());
                        if (StartupActionImpl.this.curatedApplication.getQuarkusBootstrap().getMode() == QuarkusBootstrap.Mode.TEST) {
                            StartupActionImpl.this.curatedApplication.close();
                        }
                    }
                }
            }, (ClassLoader)this.runtimeClassLoader);
            return runningQuarkusApplicationImpl;
        }
        catch (Throwable t) {
            try {
                Class<?> configClass = Class.forName("io.quarkus.runtime.generated.Config", true, (ClassLoader)this.runtimeClassLoader);
                configClass.getDeclaredMethod(RunTimeConfigurationGenerator.C_CREATE_BOOTSTRAP_CONFIG.getName(), new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public RunningQuarkusApplication run(String ... args) throws Exception {
        ForkJoinClassLoading.setForkJoinClassLoader((ClassLoader)this.runtimeClassLoader);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> appClass;
            Thread.currentThread().setContextClassLoader((ClassLoader)this.runtimeClassLoader);
            String className = ((ApplicationClassNameBuildItem)this.buildResult.consume(ApplicationClassNameBuildItem.class)).getClassName();
            try {
                appClass = Class.forName(className, true, (ClassLoader)this.runtimeClassLoader);
            }
            catch (Throwable t) {
                try {
                    Class<?> configClass = Class.forName("io.quarkus.runtime.generated.Config", true, (ClassLoader)this.runtimeClassLoader);
                    configClass.getDeclaredMethod(RunTimeConfigurationGenerator.C_CREATE_BOOTSTRAP_CONFIG.getName(), new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
            Method start = appClass.getMethod("start", String[].class);
            Object application = appClass.newInstance();
            start.invoke(application, new Object[]{args});
            final Closeable closeTask = (Closeable)application;
            RunningQuarkusApplicationImpl runningQuarkusApplicationImpl = new RunningQuarkusApplicationImpl(new Closeable(){

                @Override
                public void close() throws IOException {
                    try {
                        ClassLoader original = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader((ClassLoader)StartupActionImpl.this.runtimeClassLoader);
                            closeTask.close();
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(original);
                            StartupActionImpl.this.runtimeClassLoader.close();
                        }
                    }
                    finally {
                        ForkJoinClassLoading.setForkJoinClassLoader(ClassLoader.getSystemClassLoader());
                        if (StartupActionImpl.this.curatedApplication.getQuarkusBootstrap().getMode() == QuarkusBootstrap.Mode.TEST) {
                            StartupActionImpl.this.curatedApplication.close();
                        }
                    }
                }
            }, (ClassLoader)this.runtimeClassLoader);
            return runningQuarkusApplicationImpl;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new RuntimeException("Failed to start Quarkus", e.getCause());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public ClassLoader getClassLoader() {
        return this.runtimeClassLoader;
    }

    private Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> extractTransformers(Set<String> eagerClasses, Map<String, Predicate<byte[]>> transformerPredicates) {
        HashMap<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> bytecodeTransformers = new HashMap<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>>();
        HashSet<String> noConstScanning = new HashSet<String>();
        HashMap<String, Set> constScanning = new HashMap<String, Set>();
        List transformers = this.buildResult.consumeMulti(BytecodeTransformerBuildItem.class);
        for (BytecodeTransformerBuildItem bytecodeTransformerBuildItem : transformers) {
            ArrayList<BiFunction<String, ClassVisitor, ClassVisitor>> list = (ArrayList<BiFunction<String, ClassVisitor, ClassVisitor>>)bytecodeTransformers.get(bytecodeTransformerBuildItem.getClassToTransform());
            if (list == null) {
                list = new ArrayList<BiFunction<String, ClassVisitor, ClassVisitor>>();
                bytecodeTransformers.put(bytecodeTransformerBuildItem.getClassToTransform(), list);
            }
            list.add(bytecodeTransformerBuildItem.getVisitorFunction());
            if (bytecodeTransformerBuildItem.isEager()) {
                eagerClasses.add(bytecodeTransformerBuildItem.getClassToTransform());
            }
            if (bytecodeTransformerBuildItem.getRequireConstPoolEntry() == null || bytecodeTransformerBuildItem.getRequireConstPoolEntry().isEmpty()) {
                noConstScanning.add(bytecodeTransformerBuildItem.getClassToTransform());
                continue;
            }
            constScanning.computeIfAbsent(bytecodeTransformerBuildItem.getClassToTransform(), s -> new HashSet()).addAll(bytecodeTransformerBuildItem.getRequireConstPoolEntry());
        }
        for (String string : noConstScanning) {
            constScanning.remove(string);
        }
        for (final Map.Entry entry : constScanning.entrySet()) {
            transformerPredicates.put((String)entry.getKey(), new Predicate<byte[]>(){

                @Override
                public boolean test(byte[] bytes) {
                    return ConstPoolScanner.constPoolEntryPresent(bytes, (Set)entry.getValue());
                }
            });
        }
        return bytecodeTransformers;
    }

    private Map<String, byte[]> extractGeneratedResources(boolean applicationClasses) {
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        for (MultiBuildItem i : this.buildResult.consumeMulti(GeneratedClassBuildItem.class)) {
            String debugSourcesDir;
            if (i.isApplicationClass() != applicationClasses) continue;
            data.put(i.getName().replace(".", "/") + ".class", i.getClassData());
            if (BootstrapDebug.DEBUG_CLASSES_DIR != null) {
                try {
                    File debugPath = new File(BootstrapDebug.DEBUG_CLASSES_DIR);
                    if (!debugPath.exists()) {
                        debugPath.mkdir();
                    }
                    File classFile = new File(debugPath, i.getName() + ".class");
                    classFile.getParentFile().mkdirs();
                    try (FileOutputStream classWriter = new FileOutputStream(classFile);){
                        classWriter.write(i.getClassData());
                    }
                    log.infof("Wrote %s", (Object)classFile.getAbsolutePath());
                }
                catch (Exception t) {
                    log.errorf((Throwable)t, "Failed to write debug class files %s", (Object)i.getName());
                }
            }
            if ((debugSourcesDir = BootstrapDebug.DEBUG_SOURCES_DIR) == null) continue;
            try {
                if (i.getSource() != null) {
                    File debugPath = new File(debugSourcesDir);
                    if (!debugPath.exists()) {
                        debugPath.mkdir();
                    }
                    File sourceFile = new File(debugPath, i.getName() + ".zig");
                    sourceFile.getParentFile().mkdirs();
                    Files.write(sourceFile.toPath(), i.getSource().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                    log.infof("Wrote source %s", (Object)sourceFile.getAbsolutePath());
                    continue;
                }
                log.infof("Source not available: %s", (Object)i.getName());
            }
            catch (Exception t) {
                log.errorf((Throwable)t, "Failed to write debug source file %s", (Object)i.getName());
            }
        }
        if (applicationClasses) {
            for (MultiBuildItem i : this.buildResult.consumeMulti(GeneratedResourceBuildItem.class)) {
                data.put(i.getName(), i.getClassData());
            }
        }
        return data;
    }
}

