/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;

public class IDEDevModeMain
implements BiConsumer<CuratedApplication, Map<String, Object>> {
    private static final Logger log = Logger.getLogger((String)IDEDevModeMain.class.getName());

    @Override
    public void accept(CuratedApplication curatedApplication, Map<String, Object> stringObjectMap) {
        Path appClasses = (Path)stringObjectMap.get("app-classes");
        DevModeContext devModeContext = new DevModeContext();
        devModeContext.setArgs((String[])stringObjectMap.get("args"));
        try {
            LocalProject project = LocalProject.loadWorkspace((Path)appClasses);
            DevModeContext.ModuleInfo root = this.toModule(project);
            devModeContext.setApplicationRoot(root);
            for (Map.Entry module : project.getWorkspace().getProjects().entrySet()) {
                if (((AppArtifactKey)module.getKey()).equals((Object)project.getKey())) continue;
                devModeContext.getAdditionalModules().add(this.toModule((LocalProject)module.getValue()));
            }
        }
        catch (BootstrapMavenException e) {
            log.error((Object)"Failed to load workspace, hot reload will not be available", (Throwable)e);
        }
        new IsolatedDevModeMain().accept(curatedApplication, Collections.singletonMap(DevModeContext.class.getName(), devModeContext));
    }

    private DevModeContext.ModuleInfo toModule(LocalProject project) {
        return new DevModeContext.ModuleInfo(project.getKey(), project.getArtifactId(), project.getDir().toAbsolutePath().toString(), Collections.singleton(project.getSourcesSourcesDir().toAbsolutePath().toString()), project.getClassesDir().toAbsolutePath().toString(), project.getResourcesSourcesDir().toAbsolutePath().toString());
    }
}

