/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public final class ReflectiveHierarchyBuildItem
extends MultiBuildItem {
    private final Type type;
    private IndexView index;
    private final Predicate<DotName> ignorePredicate;

    public ReflectiveHierarchyBuildItem(Type type) {
        this(type, DefaultIgnorePredicate.INSTANCE);
    }

    public ReflectiveHierarchyBuildItem(Type type, IndexView index) {
        this(type, index, DefaultIgnorePredicate.INSTANCE);
    }

    public ReflectiveHierarchyBuildItem(Type type, Predicate<DotName> ignorePredicate) {
        this.type = type;
        this.ignorePredicate = ignorePredicate;
    }

    public ReflectiveHierarchyBuildItem(Type type, IndexView index, Predicate<DotName> ignorePredicate) {
        this.type = type;
        this.index = index;
        this.ignorePredicate = ignorePredicate;
    }

    public Type getType() {
        return this.type;
    }

    public IndexView getIndex() {
        return this.index;
    }

    public Predicate<DotName> getIgnorePredicate() {
        return this.ignorePredicate;
    }

    public static class IgnoreWhiteListedPredicate
    implements Predicate<DotName> {
        public static IgnoreWhiteListedPredicate INSTANCE = new IgnoreWhiteListedPredicate();

        @Override
        public boolean test(DotName dotName) {
            return DefaultIgnorePredicate.WHITELISTED_FROM_IGNORED_PACKAGES.contains(dotName.toString());
        }
    }

    public static class DefaultIgnorePredicate
    implements Predicate<DotName> {
        public static final DefaultIgnorePredicate INSTANCE = new DefaultIgnorePredicate();
        private static final List<String> DEFAULT_IGNORED_PACKAGES = Arrays.asList("java.", "io.reactivex.", "org.reactivestreams.");
        static final Set<String> WHITELISTED_FROM_IGNORED_PACKAGES = new HashSet<String>(Arrays.asList("java.math.BigDecimal", "java.math.BigInteger"));
        static final List<String> PRIMITIVE = Arrays.asList("boolean", "byte", "char", "short", "int", "long", "float", "double");

        @Override
        public boolean test(DotName dotName) {
            String name = dotName.toString();
            if (PRIMITIVE.contains(name)) {
                return true;
            }
            for (String containerPackageName : DEFAULT_IGNORED_PACKAGES) {
                if (!name.startsWith(containerPackageName)) continue;
                return !WHITELISTED_FROM_IGNORED_PACKAGES.contains(name);
            }
            return false;
        }
    }
}

