/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.deployment.index.ArtifactResolver;
import io.quarkus.deployment.index.ResolvedArtifact;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassPathArtifactResolver
implements ArtifactResolver {
    private static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";
    private final List<StoredUrl> pathList = new ArrayList<StoredUrl>();

    public ClassPathArtifactResolver(ClassLoader classLoader) {
        ClassLoader cl = classLoader;
        try {
            Enumeration<URL> res = cl.getResources(META_INF_MANIFEST_MF);
            while (res.hasMoreElements()) {
                URL jarUrl = res.nextElement();
                String path = jarUrl.getPath();
                if (!path.startsWith("file:")) continue;
                this.pathList.add(new StoredUrl(Paths.get(new URI(path.substring(0, path.length() - META_INF_MANIFEST_MF.length() - 2)))));
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResolvedArtifact getArtifact(String groupId, String artifactId, String classifier) {
        Pattern filePatten = classifier == null || classifier.isEmpty() ? Pattern.compile(artifactId + "-(\\d.*)\\.jar") : Pattern.compile(artifactId + "-" + classifier + "-(\\d.*)\\.jar");
        List<BiFunction<StoredUrl, Matcher, ResolvedArtifact>> resolvers = this.createResolvers(groupId, artifactId, classifier);
        for (StoredUrl url : this.pathList) {
            Matcher matcher = filePatten.matcher(url.fileName);
            if (!matcher.matches()) continue;
            for (BiFunction<StoredUrl, Matcher, ResolvedArtifact> resolver : resolvers) {
                ResolvedArtifact result = resolver.apply(url, matcher);
                if (result == null) continue;
                return result;
            }
        }
        throw new RuntimeException("Could not resolve artifact " + groupId + ":" + artifactId + ":" + classifier + ". Please make sure it is present and contains a META-INF/MANIFEST.MF file. Note that artifacts that are part of the same project may not always be resolvable, in this case you should generate a META-INF/jandex.idx file instead using the Jandex Maven plugin.");
    }

    private List<BiFunction<StoredUrl, Matcher, ResolvedArtifact>> createResolvers(String groupId, String artifactId, String classifier) {
        return Arrays.asList(this.createMavenResolver(groupId, artifactId, classifier), this.createGradleResolver(groupId, artifactId, classifier));
    }

    private BiFunction<StoredUrl, Matcher, ResolvedArtifact> createGradleResolver(final String groupId, final String artifactId, final String classifier) {
        return new BiFunction<StoredUrl, Matcher, ResolvedArtifact>(){

            @Override
            public ResolvedArtifact apply(StoredUrl url, Matcher matcher) {
                if (url.path.getNameCount() < 5) {
                    return null;
                }
                String fileArtifact = url.path.getName(url.path.getNameCount() - 4).toString();
                String fileGroup = url.path.getName(url.path.getNameCount() - 5).toString();
                if (fileGroup.equals(groupId) && fileArtifact.equals(artifactId)) {
                    try {
                        return new ResolvedArtifact(groupId, artifactId, matcher.group(1), classifier, url.path);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
    }

    public BiFunction<StoredUrl, Matcher, ResolvedArtifact> createMavenResolver(final String groupId, final String artifactId, final String classifier) {
        return new BiFunction<StoredUrl, Matcher, ResolvedArtifact>(){

            @Override
            public ResolvedArtifact apply(StoredUrl url, Matcher matcher) {
                String[] groupParts = groupId.split("\\.");
                if (url.path.getNameCount() < groupParts.length + 2) {
                    return null;
                }
                boolean matches = true;
                for (int i = 0; i < groupParts.length; ++i) {
                    String up = url.path.getName(url.path.getNameCount() - groupParts.length - 3 + i).toString();
                    if (up.equals(groupParts[i])) continue;
                    matches = false;
                    break;
                }
                if (matches) {
                    try {
                        return new ResolvedArtifact(groupId, artifactId, matcher.group(1), classifier, url.path);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
    }

    static class StoredUrl {
        final Path path;
        final String fileName;

        private StoredUrl(Path path) {
            this.path = path;
            this.fileName = path.getFileName().toString();
        }

        public String toString() {
            return "StoredUrl{path=" + this.path + '}';
        }
    }
}

