/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public final class JandexUtil {
    private static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());

    private JandexUtil() {
    }

    public static List<Type> resolveTypeParameters(DotName input, DotName target, IndexView index) {
        ClassInfo targetClassInfo;
        ClassInfo inputClassInfo = JandexUtil.fetchFromIndex(input, index);
        RecursiveMatchResult recursiveMatchResult = JandexUtil.matchParametersRecursively(inputClassInfo, target, Modifier.isInterface((targetClassInfo = JandexUtil.fetchFromIndex(target, index)).flags()), index, new LinkedList<RecursiveMatchLevel>());
        if (recursiveMatchResult == null) {
            return Collections.emptyList();
        }
        ArrayList<Type> result = new ArrayList<Type>();
        block0: for (int i = 0; i < recursiveMatchResult.argumentsOfMatch.size(); ++i) {
            Type argument = (Type)recursiveMatchResult.argumentsOfMatch.get(i);
            if (JandexUtil.isDirectlyHandledType(argument)) {
                result.add(argument);
                continue;
            }
            if (!(argument instanceof TypeVariable)) continue;
            String unmatchedParameter = argument.asTypeVariable().identifier();
            for (RecursiveMatchLevel recursiveMatchLevel : recursiveMatchResult.recursiveMatchLevels) {
                Type matchingCapturedType = null;
                for (int j = 0; j < recursiveMatchLevel.definitions.size(); ++j) {
                    Type definition = (Type)recursiveMatchLevel.definitions.get(j);
                    if (!(definition instanceof TypeVariable) || !unmatchedParameter.equals(definition.asTypeVariable().identifier())) continue;
                    matchingCapturedType = (Type)recursiveMatchLevel.captures.get(j);
                    break;
                }
                if (matchingCapturedType == null) {
                    throw new IllegalStateException("Error retrieving generic types");
                }
                if (JandexUtil.isDirectlyHandledType(matchingCapturedType)) {
                    result.add(matchingCapturedType);
                    continue block0;
                }
                if (!(matchingCapturedType instanceof TypeVariable)) continue;
                unmatchedParameter = matchingCapturedType.asTypeVariable().identifier();
            }
        }
        if (result.size() != recursiveMatchResult.argumentsOfMatch.size()) {
            throw new IllegalStateException("Unable to properly match generic types");
        }
        return result;
    }

    private static boolean isDirectlyHandledType(Type matchingCapturedType) {
        return matchingCapturedType instanceof ClassType || matchingCapturedType instanceof ParameterizedType;
    }

    private static RecursiveMatchResult matchParametersRecursively(ClassInfo inputClassInfo, DotName target, boolean isTargetAnInterface, IndexView index, List<RecursiveMatchLevel> visitedTypes) {
        Type superClassType;
        if (isTargetAnInterface) {
            List interfaceTypes = inputClassInfo.interfaceTypes();
            ArrayList<Type> nonMatchingInterfaces = new ArrayList<Type>();
            for (Type interfaceType : interfaceTypes) {
                if (target.equals((Object)interfaceType.name())) {
                    return JandexUtil.getRecursiveMatchResult(visitedTypes, interfaceType);
                }
                nonMatchingInterfaces.add(interfaceType);
            }
            for (Type otherInterface : nonMatchingInterfaces) {
                RecursiveMatchResult recursiveMatchResult = JandexUtil.matchParametersRecursively(JandexUtil.fetchFromIndex(otherInterface.name(), index), target, isTargetAnInterface, index, JandexUtil.addArgumentIfNeeded(otherInterface, index, visitedTypes));
                if (recursiveMatchResult == null) continue;
                return recursiveMatchResult;
            }
        }
        if (target.equals((Object)(superClassType = inputClassInfo.superClassType()).name())) {
            return JandexUtil.getRecursiveMatchResult(visitedTypes, superClassType);
        }
        if (OBJECT.equals((Object)superClassType.name())) {
            return null;
        }
        return JandexUtil.matchParametersRecursively(JandexUtil.fetchFromIndex(superClassType.name(), index), target, isTargetAnInterface, index, JandexUtil.addArgumentIfNeeded(superClassType, index, visitedTypes));
    }

    private static RecursiveMatchResult getRecursiveMatchResult(List<RecursiveMatchLevel> visitedTypes, Type superClassType) {
        if (superClassType instanceof ParameterizedType) {
            return new RecursiveMatchResult(superClassType.asParameterizedType().arguments(), visitedTypes);
        }
        return null;
    }

    private static ClassInfo fetchFromIndex(DotName dotName, IndexView index) {
        ClassInfo classInfo = index.getClassByName(dotName);
        if (classInfo == null) {
            throw new IllegalArgumentException("Class " + dotName + " was not found in the index");
        }
        return classInfo;
    }

    private static List<RecursiveMatchLevel> addArgumentIfNeeded(Type type, IndexView index, List<RecursiveMatchLevel> visitedTypes) {
        LinkedList<RecursiveMatchLevel> newVisitedTypes = new LinkedList<RecursiveMatchLevel>(visitedTypes);
        if (type instanceof ParameterizedType) {
            ClassInfo classInfo = JandexUtil.fetchFromIndex(type.name(), index);
            RecursiveMatchLevel recursiveMatchLevel = new RecursiveMatchLevel(classInfo.typeParameters(), type.asParameterizedType().arguments());
            newVisitedTypes.add(0, recursiveMatchLevel);
        }
        return newVisitedTypes;
    }

    private static class RecursiveMatchLevel {
        private final List<? extends Type> definitions;
        private final List<? extends Type> captures;

        public RecursiveMatchLevel(List<? extends Type> definitions, List<? extends Type> captures) {
            this.definitions = definitions;
            this.captures = captures;
        }
    }

    private static class RecursiveMatchResult {
        private final List<Type> argumentsOfMatch;
        private final List<RecursiveMatchLevel> recursiveMatchLevels;

        public RecursiveMatchResult(List<Type> argumentsOfMatch, List<RecursiveMatchLevel> recursiveMatchLevels) {
            this.argumentsOfMatch = argumentsOfMatch;
            this.recursiveMatchLevels = recursiveMatchLevels;
        }
    }
}

