/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeInitializedClassBuildItem;
import io.quarkus.runtime.annotations.RegisterForReflection;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class RegisterForReflectionBuildStep {
    @Inject
    BuildProducer<RuntimeInitializedClassBuildItem> runtimeInit;
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;

    @BuildStep
    public void build() throws Exception {
        for (AnnotationInstance i : this.combinedIndexBuildItem.getIndex().getAnnotations(DotName.createSimple((String)RegisterForReflection.class.getName()))) {
            Type[] targets;
            ClassInfo target = i.target().asClass();
            boolean methods = i.value("methods") == null || i.value("methods").asBoolean();
            boolean fields = i.value("fields") == null || i.value("fields").asBoolean();
            AnnotationValue targetsValue = i.value("targets");
            if (targetsValue == null) {
                this.reflectiveClass.produce(new ReflectiveClassBuildItem(methods, fields, target.name().toString()));
                continue;
            }
            for (Type type : targets = targetsValue.asClassArray()) {
                this.reflectiveClass.produce(new ReflectiveClassBuildItem(methods, fields, type.name().toString()));
            }
        }
    }
}

