/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.util;

import io.quarkus.bootstrap.BootstrapGradleException;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.model.gradle.ArtifactCoords;
import io.quarkus.bootstrap.model.gradle.Dependency;
import io.quarkus.bootstrap.model.gradle.QuarkusModel;
import io.quarkus.bootstrap.model.gradle.WorkspaceModule;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.util.IoUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class QuarkusModelHelper {
    public static final String SERIALIZED_QUARKUS_MODEL = "quarkus-internal.serialized-quarkus-model.path";
    public static final String[] DEVMODE_REQUIRED_TASKS = new String[]{"classes"};
    public static final String[] TEST_REQUIRED_TASKS = new String[]{"classes", "testClasses"};
    public static final List<String> ENABLE_JAR_PACKAGING = Collections.singletonList("-Dorg.gradle.java.compile-classpath-packaging=true");

    private QuarkusModelHelper() {
    }

    public static void exportModel(QuarkusModel model, boolean test) throws AppModelResolverException, IOException {
        Path serializedModel = QuarkusModelHelper.serializeAppModel(model, test);
        System.setProperty(test ? "quarkus-internal-test.serialized-app-model.path" : "quarkus-internal.serialized-app-model.path", serializedModel.toString());
    }

    public static Path serializeAppModel(QuarkusModel model, boolean test) throws AppModelResolverException, IOException {
        Path serializedModel = File.createTempFile("quarkus-" + (test ? "test-" : "") + "app-model", ".dat").toPath();
        ArtifactCoords artifactCoords = model.getWorkspace().getMainModule().getArtifactCoords();
        AppArtifact appArtifact = new AppArtifact(artifactCoords.getGroupId(), artifactCoords.getArtifactId(), artifactCoords.getVersion());
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(serializedModel, new OpenOption[0]));){
            out.writeObject(QuarkusModelHelper.convert(model, appArtifact));
        }
        return serializedModel;
    }

    public static Path serializeQuarkusModel(QuarkusModel model) throws IOException {
        Path serializedModel = File.createTempFile("quarkus-model", ".dat").toPath();
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(serializedModel, new OpenOption[0]));){
            out.writeObject(model);
        }
        return serializedModel;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static QuarkusModel deserializeQuarkusModel(Path modelPath) throws BootstrapGradleException {
        if (Files.exists(modelPath, new LinkOption[0])) {
            try (InputStream existing = Files.newInputStream(modelPath, new OpenOption[0]);){
                QuarkusModel quarkusModel;
                try (ObjectInputStream object = new ObjectInputStream(existing);){
                    QuarkusModel model = (QuarkusModel)object.readObject();
                    IoUtils.recursiveDelete((Path)modelPath);
                    quarkusModel = model;
                }
                return quarkusModel;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new BootstrapGradleException("Failed to deserialize quarkus model", e);
            }
        }
        throw new BootstrapGradleException("Unable to locate quarkus model");
    }

    public static Path getClassPath(WorkspaceModule model) throws BootstrapGradleException {
        Optional<Path> classDir = model.getSourceSet().getSourceDirectories().stream().filter(File::exists).map(File::toPath).findFirst();
        if (!classDir.isPresent()) {
            throw new BootstrapGradleException("Failed to locate class directory");
        }
        return classDir.get();
    }

    public static AppModel convert(QuarkusModel model, AppArtifact appArtifact) throws AppModelResolverException {
        AppModel.Builder appBuilder = new AppModel.Builder();
        HashMap<String, Object> capabilities = new HashMap<String, Object>();
        HashMap<String, CapabilityContract> capabilitiesContracts = new HashMap<String, CapabilityContract>();
        for (Dependency extensionDependency : model.getDependencies()) {
            boolean extension = false;
            for (File f : extensionDependency.getPaths()) {
                Path artifactPath = f.toPath();
                if (!Files.exists(artifactPath, new LinkOption[0]) || !extensionDependency.getType().equals("jar")) continue;
                if (Files.isDirectory(artifactPath, new LinkOption[0])) {
                    extension |= QuarkusModelHelper.processQuarkusDir(extensionDependency, artifactPath.resolve("META-INF"), appBuilder, capabilities, capabilitiesContracts);
                    continue;
                }
                try {
                    FileSystem artifactFs = FileSystems.newFileSystem(artifactPath, QuarkusModelHelper.class.getClassLoader());
                    try {
                        extension |= QuarkusModelHelper.processQuarkusDir(extensionDependency, artifactFs.getPath("META-INF", new String[0]), appBuilder, capabilities, capabilitiesContracts);
                    }
                    finally {
                        if (artifactFs == null) continue;
                        artifactFs.close();
                    }
                }
                catch (IOException e) {
                    throw new AppModelResolverException("Failed to process " + artifactPath, (Throwable)e);
                }
            }
            appBuilder.addDependency(QuarkusModelHelper.toAppDependency(extensionDependency, extensionDependency.getFlags(), extension ? 16 : 0));
        }
        appBuilder.setCapabilitiesContracts(capabilitiesContracts);
        if (!appArtifact.isResolved()) {
            PathsCollection.Builder paths = PathsCollection.builder();
            WorkspaceModule module = model.getWorkspace().getMainModule();
            module.getSourceSet().getSourceDirectories().stream().filter(File::exists).map(File::toPath).forEach(arg_0 -> ((PathsCollection.Builder)paths).add(arg_0));
            module.getSourceSet().getResourceDirectories().stream().filter(File::exists).map(File::toPath).forEach(arg_0 -> ((PathsCollection.Builder)paths).add(arg_0));
            appArtifact.setPaths(paths.build());
        }
        for (WorkspaceModule module : model.getWorkspace().getAllModules()) {
            ArtifactCoords coords = module.getArtifactCoords();
            appBuilder.addLocalProjectArtifact(new AppArtifactKey(coords.getGroupId(), coords.getArtifactId(), null, coords.getType()));
        }
        appBuilder.setAppArtifact(appArtifact).setPlatformImports(model.getPlatformImports());
        return appBuilder.build();
    }

    public static AppDependency toAppDependency(Dependency dependency, int ... flags) {
        int allFlags = dependency.getFlags();
        for (int f : flags) {
            allFlags |= f;
        }
        return new AppDependency(QuarkusModelHelper.toAppArtifact(dependency), "runtime", new int[]{allFlags});
    }

    private static AppArtifact toAppArtifact(Dependency dependency) {
        AppArtifact artifact = new AppArtifact(dependency.getGroupId(), dependency.getName(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
        artifact.setPaths(QuarkusModelHelper.toPathsCollection(dependency.getPaths()));
        return artifact;
    }

    public static PathsCollection toPathsCollection(Collection<File> files) {
        PathsCollection.Builder paths = PathsCollection.builder();
        for (File f : files) {
            paths.add(f.toPath());
        }
        return paths.build();
    }

    public static Properties resolveDescriptor(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        Properties rtProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            rtProps.load(reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load extension description " + path, e);
        }
        return rtProps;
    }

    private static boolean processQuarkusDir(Dependency d, Path quarkusDir, AppModel.Builder appBuilder, Map<String, Object> capabilities, Map<String, CapabilityContract> capabilitiesContracts) {
        if (!Files.exists(quarkusDir, new LinkOption[0])) {
            return false;
        }
        Path quarkusDescr = quarkusDir.resolve("quarkus-extension.properties");
        if (!Files.exists(quarkusDescr, new LinkOption[0])) {
            return false;
        }
        Properties extProps = QuarkusModelHelper.resolveDescriptor(quarkusDescr);
        if (extProps == null) {
            return false;
        }
        String extensionCoords = d.getGroupId() + ":" + d.getName() + ":" + (d.getClassifier() == null ? "" : d.getClassifier()) + ":" + (d.getType() == null || d.getType().isEmpty() ? "jar" : d.getType()) + ":" + d.getVersion();
        appBuilder.handleExtensionProperties(extProps, extensionCoords);
        String providesCapabilities = extProps.getProperty("provides-capabilities");
        if (providesCapabilities != null) {
            capabilitiesContracts.put(extensionCoords, CapabilityContract.providesCapabilities((String)extensionCoords, (String)providesCapabilities));
        }
        return true;
    }

    static AppDependency alignVersion(AppDependency dependency, Map<AppArtifactKey, AppDependency> versionMap) {
        AppArtifactKey appKey = new AppArtifactKey(dependency.getArtifact().getGroupId(), dependency.getArtifact().getArtifactId());
        if (versionMap.containsKey(appKey)) {
            return versionMap.get(appKey);
        }
        return dependency;
    }
}

