/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface ApplicationModel {
    public static final String PARENT_FIRST_ARTIFACTS = "parent-first-artifacts";
    public static final String RUNNER_PARENT_FIRST_ARTIFACTS = "runner-parent-first-artifacts";
    public static final String EXCLUDED_ARTIFACTS = "excluded-artifacts";
    public static final String LESSER_PRIORITY_ARTIFACTS = "lesser-priority-artifacts";

    public ResolvedDependency getAppArtifact();

    public Collection<ResolvedDependency> getDependencies();

    default public Collection<ResolvedDependency> getRuntimeDependencies() {
        return this.getDependencies().stream().filter(Dependency::isRuntimeCp).collect(Collectors.toList());
    }

    public PlatformImports getPlatforms();

    default public Map<String, String> getPlatformProperties() {
        PlatformImports platformImports = this.getPlatforms();
        return platformImports == null ? Collections.emptyMap() : platformImports.getPlatformProperties();
    }

    public Collection<ExtensionCapabilities> getExtensionCapabilities();

    public Set<ArtifactKey> getParentFirst();

    public Set<ArtifactKey> getRunnerParentFirst();

    public Set<ArtifactKey> getLowerPriorityArtifacts();

    public Set<ArtifactKey> getReloadableWorkspaceDependencies();

    default public WorkspaceModule getApplicationModule() {
        return this.getAppArtifact().getWorkspaceModule();
    }

    default public Collection<WorkspaceModule> getWorkspaceModules() {
        HashMap<WorkspaceModuleId, WorkspaceModule> modules = new HashMap<WorkspaceModuleId, WorkspaceModule>();
        for (ResolvedDependency d : this.getDependencies()) {
            WorkspaceModule module = d.getWorkspaceModule();
            if (module == null) continue;
            modules.putIfAbsent(module.getId(), module);
        }
        return modules.values();
    }
}

