/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import io.undertow.websockets.jsr.BinaryOutputStream;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.SendHandlerAdapter;
import io.undertow.websockets.jsr.SendResultFuture;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.WebSocketWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;

final class WebSocketSessionRemoteEndpoint
implements RemoteEndpoint {
    private final UndertowSession undertowSession;
    private final RemoteEndpoint.Async async = new AsyncWebSocketSessionRemoteEndpoint();
    private final RemoteEndpoint.Basic basic = new BasicWebSocketSessionRemoteEndpoint();
    private final Encoding encoding;

    WebSocketSessionRemoteEndpoint(UndertowSession session, Encoding encoding) {
        this.undertowSession = session;
        this.encoding = encoding;
    }

    public RemoteEndpoint.Async getAsync() {
        return this.async;
    }

    public RemoteEndpoint.Basic getBasic() {
        return this.basic;
    }

    public void flushBatch() {
    }

    public void setBatchingAllowed(boolean allowed) throws IOException {
    }

    public boolean getBatchingAllowed() {
        return false;
    }

    public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        if (applicationData == null) {
            throw JsrWebSocketMessages.MESSAGES.messageInNull();
        }
        if (applicationData.remaining() > 125) {
            throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
        }
        this.undertowSession.getChannel().writeAndFlush((Object)new PingWebSocketFrame(Unpooled.copiedBuffer((ByteBuffer)applicationData)));
    }

    public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        if (applicationData == null) {
            throw JsrWebSocketMessages.MESSAGES.messageInNull();
        }
        if (applicationData.remaining() > 125) {
            throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
        }
        this.undertowSession.getChannel().writeAndFlush((Object)new PongWebSocketFrame(Unpooled.copiedBuffer((ByteBuffer)applicationData)));
    }

    class BasicWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Basic {
        boolean inTextFragment = false;
        boolean inBinaryFragment = false;

        BasicWebSocketSessionRemoteEndpoint() {
        }

        public void assertNotInFragment() {
            if (this.inTextFragment || this.inBinaryFragment) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
        }

        public void sendText(String text) throws IOException {
            if (text == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.assertNotInFragment();
            try {
                WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new TextWebSocketFrame(text)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }

        public void sendBinary(ByteBuffer data) throws IOException {
            if (data == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.assertNotInFragment();
            try {
                WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.copiedBuffer((ByteBuffer)data))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
            data.clear();
        }

        public void sendText(String partialMessage, boolean isLast) throws IOException {
            if (partialMessage == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (this.inBinaryFragment) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            boolean fragmented = this.inTextFragment;
            this.inTextFragment = !isLast;
            try {
                if (fragmented) {
                    WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new ContinuationWebSocketFrame(isLast, 0, partialMessage)).get();
                } else {
                    WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new TextWebSocketFrame(isLast, 0, partialMessage)).get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }

        public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
            if (partialByte == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (this.inTextFragment) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            boolean fragmented = this.inBinaryFragment;
            this.inBinaryFragment = !isLast;
            try {
                if (fragmented) {
                    WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new ContinuationWebSocketFrame(isLast, 0, Unpooled.copiedBuffer((ByteBuffer)partialByte))).get();
                } else {
                    WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new BinaryWebSocketFrame(isLast, 0, Unpooled.copiedBuffer((ByteBuffer)partialByte))).get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
            partialByte.clear();
        }

        public OutputStream getSendStream() throws IOException {
            this.assertNotInFragment();
            return new BinaryOutputStream(this);
        }

        public Writer getSendWriter() throws IOException {
            this.assertNotInFragment();
            return new WebSocketWriter(this);
        }

        public void sendObject(Object data) throws IOException, EncodeException {
            if (data == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.sendObjectImpl(data);
        }

        private void sendObjectImpl(Object o) throws IOException, EncodeException {
            if (o instanceof String) {
                this.sendText((String)o);
            } else if (o instanceof byte[]) {
                this.sendBinary(ByteBuffer.wrap((byte[])o));
            } else if (o instanceof ByteBuffer) {
                this.sendBinary((ByteBuffer)o);
            } else if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeText(o.getClass())) {
                this.sendText(WebSocketSessionRemoteEndpoint.this.encoding.encodeText(o));
            } else if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeBinary(o.getClass())) {
                this.sendBinary(WebSocketSessionRemoteEndpoint.this.encoding.encodeBinary(o));
            } else {
                throw new EncodeException(o, "No suitable encoder found");
            }
        }

        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        public boolean getBatchingAllowed() {
            return false;
        }

        public void flushBatch() throws IOException {
        }

        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            try {
                WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new PingWebSocketFrame(Unpooled.copiedBuffer((ByteBuffer)applicationData))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }

        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            try {
                WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new PongWebSocketFrame(Unpooled.copiedBuffer((ByteBuffer)applicationData))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }
    }

    class AsyncWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Async {
        private long sendTimeout = 0L;

        AsyncWebSocketSessionRemoteEndpoint() {
        }

        public long getSendTimeout() {
            return this.sendTimeout;
        }

        public void setSendTimeout(long timeoutmillis) {
            this.sendTimeout = timeoutmillis;
        }

        public void sendText(String text, SendHandler handler) {
            if (handler == null) {
                throw JsrWebSocketMessages.MESSAGES.handlerIsNull();
            }
            if (text == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new TextWebSocketFrame(text)).addListener((GenericFutureListener)new SendHandlerAdapter(handler));
        }

        public Future<Void> sendText(String text) {
            if (text == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            return WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new TextWebSocketFrame(text));
        }

        public Future<Void> sendBinary(ByteBuffer data) {
            if (data == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            return WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.copiedBuffer((ByteBuffer)data)));
        }

        public void sendBinary(ByteBuffer data, SendHandler completion) {
            if (completion == null) {
                throw JsrWebSocketMessages.MESSAGES.handlerIsNull();
            }
            if (data == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.copiedBuffer((ByteBuffer)data))).addListener((GenericFutureListener)new SendHandlerAdapter(completion));
        }

        public Future<Void> sendObject(Object o) {
            if (o == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            SendResultFuture future = new SendResultFuture();
            this.sendObjectImpl(o, future);
            return future;
        }

        public void sendObject(Object data, SendHandler handler) {
            if (handler == null) {
                throw JsrWebSocketMessages.MESSAGES.handlerIsNull();
            }
            if (data == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.sendObjectImpl(data, handler);
        }

        private void sendObjectImpl(Object o, SendHandler callback) {
            block7: {
                try {
                    if (o instanceof String) {
                        this.sendText((String)o, callback);
                        break block7;
                    }
                    if (o instanceof byte[]) {
                        this.sendBinary(ByteBuffer.wrap((byte[])o), callback);
                        break block7;
                    }
                    if (o instanceof ByteBuffer) {
                        this.sendBinary((ByteBuffer)o, callback);
                        break block7;
                    }
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeText(o.getClass())) {
                        this.sendText(WebSocketSessionRemoteEndpoint.this.encoding.encodeText(o), callback);
                        break block7;
                    }
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeBinary(o.getClass())) {
                        this.sendBinary(WebSocketSessionRemoteEndpoint.this.encoding.encodeBinary(o), callback);
                        break block7;
                    }
                    throw new EncodeException(o, "No suitable encoder found");
                }
                catch (Exception e) {
                    callback.onResult(new SendResult((Throwable)e));
                }
            }
        }

        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        public boolean getBatchingAllowed() {
            return false;
        }

        public void flushBatch() throws IOException {
        }

        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new PingWebSocketFrame(Unpooled.copiedBuffer((ByteBuffer)applicationData)));
        }

        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            WebSocketSessionRemoteEndpoint.this.undertowSession.getChannel().writeAndFlush((Object)new PongWebSocketFrame(Unpooled.copiedBuffer((ByteBuffer)applicationData)));
        }
    }
}

