/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.core.ContextClassLoaderSetupAction;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.websockets.jsr.JsrWebSocketFilter;
import io.undertow.websockets.jsr.SecurityActions;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.UndertowContainerProvider;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.websocket.DeploymentException;
import javax.websocket.Extension;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;

public class Bootstrap
implements ServletExtension {
    public static final String FILTER_NAME = "Undertow Web Socket Filter";

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        final WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)deploymentInfo.getServletContextAttributes().get("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
        if (info == null) {
            return;
        }
        ArrayList<ThreadSetupHandler> setup = new ArrayList<ThreadSetupHandler>();
        setup.add((ThreadSetupHandler)new ContextClassLoaderSetupAction(deploymentInfo.getClassLoader()));
        setup.addAll(deploymentInfo.getThreadSetupActions());
        InetSocketAddress bind = null;
        if (info.getClientBindAddress() != null) {
            bind = new InetSocketAddress(info.getClientBindAddress(), 0);
        }
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        final ServerWebSocketContainer container = new ServerWebSocketContainer(deploymentInfo.getClassIntrospecter(), servletContext.getClassLoader(), new Supplier<EventLoopGroup>(){

            @Override
            public EventLoopGroup get() {
                if (info.getEventLoopGroup() != null) {
                    return info.getEventLoopGroup();
                }
                return UndertowContainerProvider.getDefaultEventLoopGroup();
            }
        }, setup, info.isDispatchToWorkerThread(), bind, info.getReconnectHandler(), new Supplier<Executor>(){

            @Override
            public Executor get() {
                if (info.getExecutor() != null) {
                    return info.getExecutor().get();
                }
                return GlobalEventExecutor.INSTANCE;
            }
        }, extensions);
        try {
            for (Class<?> annotation : info.getAnnotatedEndpoints()) {
                container.addEndpoint(annotation);
            }
            for (ServerEndpointConfig programatic : info.getProgramaticEndpoints()) {
                container.addEndpoint(programatic);
            }
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
        servletContext.setAttribute(ServerContainer.class.getName(), (Object)container);
        info.containerReady(container);
        SecurityActions.addContainer(deploymentInfo.getClassLoader(), (WebSocketContainer)container);
        deploymentInfo.addListener(Servlets.listener(WebSocketListener.class));
        deploymentInfo.addDeploymentCompleteListener(new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                container.validateDeployment();
            }

            public void contextDestroyed(ServletContextEvent sce) {
            }
        });
    }

    private static final class WebSocketListener
    implements ServletContextListener {
        private ServerWebSocketContainer container;

        private WebSocketListener() {
        }

        public void contextInitialized(ServletContextEvent sce) {
            this.container = (ServerWebSocketContainer)sce.getServletContext().getAttribute(ServerContainer.class.getName());
            FilterRegistration.Dynamic filter = sce.getServletContext().addFilter(Bootstrap.FILTER_NAME, JsrWebSocketFilter.class);
            sce.getServletContext().addListener(JsrWebSocketFilter.LogoutListener.class);
            filter.setAsyncSupported(true);
            if (!this.container.getConfiguredServerEndpoints().isEmpty()) {
                filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
            } else {
                this.container.setContextToAddFilter((ServletContextImpl)sce.getServletContext());
            }
        }

        public void contextDestroyed(ServletContextEvent sce) {
            SecurityActions.removeContainer(sce.getServletContext().getClassLoader());
            this.container.close();
        }
    }
}

