/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.impl.BeanManagerProvider;
import io.quarkus.arc.impl.BeanMetadataProvider;
import io.quarkus.arc.impl.EventProvider;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.impl.InstanceProvider;
import io.quarkus.arc.impl.InterceptedBeanMetadataProvider;
import io.quarkus.arc.impl.ListProvider;
import io.quarkus.arc.impl.ResourceProvider;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public enum BuiltinBean {
    INSTANCE(BuiltinBean::generateInstanceBytecode, BuiltinBean::cdiAndRawTypeMatches, BuiltinBean::validateInstance, DotNames.INSTANCE, DotNames.PROVIDER, DotNames.INJECTABLE_INSTANCE),
    INJECTION_POINT(BuiltinBean::generateInjectionPointBytecode, BuiltinBean::cdiAndRawTypeMatches, BuiltinBean::validateInjectionPoint, DotNames.INJECTION_POINT),
    BEAN(BuiltinBean::generateBeanBytecode, (ip, names) -> BuiltinBean.cdiAndRawTypeMatches(ip, DotNames.BEAN, DotNames.INJECTABLE_BEAN) && ip.hasDefaultedQualifier(), DotNames.BEAN),
    INTERCEPTED_BEAN(BuiltinBean::generateInterceptedBeanBytecode, (ip, names) -> BuiltinBean.cdiAndRawTypeMatches(ip, DotNames.BEAN, DotNames.INJECTABLE_BEAN) && !ip.hasDefaultedQualifier() && ip.getRequiredQualifiers().size() == 1 && ip.getRequiredQualifiers().iterator().next().name().equals((Object)DotNames.INTERCEPTED), DotNames.BEAN),
    BEAN_MANAGER(BuiltinBean::generateBeanManagerBytecode, DotNames.BEAN_MANAGER, DotNames.BEAN_CONTAINER),
    EVENT(BuiltinBean::generateEventBytecode, DotNames.EVENT),
    RESOURCE(BuiltinBean::generateResourceBytecode, (ip, names) -> ip.getKind() == InjectionPointInfo.InjectionPointKind.RESOURCE, DotNames.OBJECT),
    EVENT_METADATA(Generator.NOOP, BuiltinBean::cdiAndRawTypeMatches, BuiltinBean::validateEventMetadata, DotNames.EVENT_METADATA),
    LIST(BuiltinBean::generateListBytecode, (ip, names) -> BuiltinBean.cdiAndRawTypeMatches(ip, DotNames.LIST) && ip.getRequiredQualifier(DotNames.ALL) != null, BuiltinBean::validateList, DotNames.LIST);

    private final DotName[] rawTypeDotNames;
    private final Generator generator;
    private final BiPredicate<InjectionPointInfo, DotName[]> matcher;
    private final Validator validator;

    private BuiltinBean(Generator generator, DotName ... rawTypeDotNames) {
        this(generator, BuiltinBean::cdiAndRawTypeMatches, rawTypeDotNames);
    }

    private BuiltinBean(Generator generator, BiPredicate<InjectionPointInfo, DotName[]> matcher, DotName ... rawTypeDotNames) {
        this(generator, matcher, Validator.NOOP, rawTypeDotNames);
    }

    private BuiltinBean(Generator generator, BiPredicate<InjectionPointInfo, DotName[]> matcher, Validator validator, DotName ... rawTypeDotNames) {
        this.rawTypeDotNames = rawTypeDotNames;
        this.generator = generator;
        this.matcher = matcher;
        this.validator = validator;
    }

    public boolean matches(InjectionPointInfo injectionPoint) {
        return this.matcher.test(injectionPoint, this.rawTypeDotNames);
    }

    void validate(InjectionTargetInfo injectionTarget, InjectionPointInfo injectionPoint, Consumer<Throwable> errors) {
        this.validator.validate(injectionTarget, injectionPoint, errors);
    }

    DotName[] getRawTypeDotNames() {
        return this.rawTypeDotNames;
    }

    boolean hasRawTypeDotName(DotName name) {
        for (DotName rawTypeDotName : this.rawTypeDotNames) {
            if (!rawTypeDotName.equals((Object)name)) continue;
            return true;
        }
        return false;
    }

    Generator getGenerator() {
        return this.generator;
    }

    public static boolean resolvesTo(InjectionPointInfo injectionPoint) {
        return BuiltinBean.resolve(injectionPoint) != null;
    }

    public static BuiltinBean resolve(InjectionPointInfo injectionPoint) {
        for (BuiltinBean bean : BuiltinBean.values()) {
            if (!bean.matches(injectionPoint)) continue;
            return bean;
        }
        return null;
    }

    private static boolean cdiAndRawTypeMatches(InjectionPointInfo injectionPoint, DotName ... rawTypeDotNames) {
        if (injectionPoint.getKind() != InjectionPointInfo.InjectionPointKind.CDI) {
            return false;
        }
        for (DotName rawTypeDotName : rawTypeDotNames) {
            if (!rawTypeDotName.equals((Object)injectionPoint.getType().name())) continue;
            return true;
        }
        return false;
    }

    private static void generateInstanceBytecode(GeneratorContext ctx) {
        ResultHandle beanHandle;
        ResultHandle qualifiers = BeanGenerator.collectInjectionPointQualifiers(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals);
        ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getType());
        ResultHandle annotationsHandle = BeanGenerator.collectInjectionPointAnnotations(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals, ctx.injectionPointAnnotationsPredicate);
        ResultHandle javaMemberHandle = BeanGenerator.getJavaMemberHandle(ctx.constructor, ctx.injectionPoint, ctx.reflectionRegistration);
        switch (ctx.targetInfo.kind()) {
            case OBSERVER: {
                beanHandle = ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, ctx.constructor.getMethodParam(0), new ResultHandle[0]);
                break;
            }
            case BEAN: {
                beanHandle = ctx.constructor.getThis();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported target info: " + ctx.targetInfo);
            }
        }
        ResultHandle instanceProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InstanceProvider.class, (Class[])new Class[]{Type.class, Set.class, InjectableBean.class, Set.class, Member.class, Integer.TYPE, Boolean.TYPE}), new ResultHandle[]{parameterizedType, qualifiers, beanHandle, annotationsHandle, javaMemberHandle, ctx.constructor.load(ctx.injectionPoint.getPosition()), ctx.constructor.load(ctx.injectionPoint.isTransient())});
        ResultHandle instanceProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{instanceProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), instanceProviderSupplier);
    }

    private static void generateEventBytecode(GeneratorContext ctx) {
        ResultHandle bean;
        ResultHandle qualifiers = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        if (!ctx.injectionPoint.getRequiredQualifiers().isEmpty()) {
            for (AnnotationInstance qualifierAnnotation : ctx.injectionPoint.getRequiredQualifiers()) {
                BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                if (qualifier != null) {
                    ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiers, new ResultHandle[]{qualifier.getLiteralInstance((BytecodeCreator)ctx.constructor)});
                    continue;
                }
                ClassInfo qualifierClass = ctx.beanDeployment.getQualifier(qualifierAnnotation.name());
                ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiers, new ResultHandle[]{ctx.annotationLiterals.create((BytecodeCreator)ctx.constructor, qualifierClass, qualifierAnnotation)});
            }
        }
        ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getType());
        ResultHandle annotations = BeanGenerator.collectInjectionPointAnnotations(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals, ctx.injectionPointAnnotationsPredicate);
        ResultHandle javaMember = BeanGenerator.getJavaMemberHandle(ctx.constructor, ctx.injectionPoint, ctx.reflectionRegistration);
        switch (ctx.targetInfo.kind()) {
            case OBSERVER: {
                bean = ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, ctx.constructor.getMethodParam(0), new ResultHandle[0]);
                break;
            }
            case BEAN: {
                bean = ctx.constructor.getThis();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported target info: " + ctx.targetInfo);
            }
        }
        ResultHandle injectionPoint = ctx.constructor.newInstance(MethodDescriptors.INJECTION_POINT_IMPL_CONSTRUCTOR, new ResultHandle[]{parameterizedType, parameterizedType, qualifiers, bean, annotations, javaMember, ctx.constructor.load(ctx.injectionPoint.getPosition()), ctx.constructor.load(ctx.injectionPoint.isTransient())});
        ResultHandle eventProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(EventProvider.class, (Class[])new Class[]{Type.class, Set.class, InjectionPoint.class}), new ResultHandle[]{parameterizedType, qualifiers, injectionPoint});
        ResultHandle eventProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{eventProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), eventProviderSupplier);
    }

    private static void generateInjectionPointBytecode(GeneratorContext ctx) {
        ResultHandle injectionPointProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InjectionPointProvider.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle injectionPointProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{injectionPointProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), injectionPointProviderSupplier);
    }

    private static void generateBeanBytecode(GeneratorContext ctx) {
        if (ctx.targetInfo.kind() != InjectionTargetInfo.TargetKind.BEAN) {
            throw new IllegalStateException("Invalid injection target info: " + ctx.targetInfo);
        }
        ResultHandle beanProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(BeanMetadataProvider.class, (Class[])new Class[]{String.class}), new ResultHandle[]{ctx.constructor.load(ctx.targetInfo.asBean().getIdentifier())});
        ResultHandle beanProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), beanProviderSupplier);
    }

    private static void generateInterceptedBeanBytecode(GeneratorContext ctx) {
        if (!(ctx.targetInfo instanceof InterceptorInfo)) {
            throw new IllegalStateException("Invalid injection target info: " + ctx.targetInfo);
        }
        ResultHandle interceptedBeanMetadataProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(InterceptedBeanMetadataProvider.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle interceptedBeanMetadataProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{interceptedBeanMetadataProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), interceptedBeanMetadataProviderSupplier);
    }

    private static void generateBeanManagerBytecode(GeneratorContext ctx) {
        ResultHandle beanManagerProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(BeanManagerProvider.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle injectionPointProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanManagerProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), injectionPointProviderSupplier);
    }

    private static void generateResourceBytecode(GeneratorContext ctx) {
        ResultHandle annotations = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        if (!ctx.injectionPoint.getRequiredQualifiers().isEmpty()) {
            for (AnnotationInstance annotation : ctx.injectionPoint.getRequiredQualifiers()) {
                ClassInfo annotationClass = IndexClassLookupUtils.getClassByName(ctx.beanDeployment.getBeanArchiveIndex(), annotation.name());
                if (annotationClass == null) continue;
                ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, annotations, new ResultHandle[]{ctx.annotationLiterals.create((BytecodeCreator)ctx.constructor, annotationClass, annotation)});
            }
        }
        ResultHandle parameterizedType = Types.getTypeHandle((BytecodeCreator)ctx.constructor, ctx.injectionPoint.getType());
        ResultHandle resourceProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(ResourceProvider.class, (Class[])new Class[]{Type.class, Set.class}), new ResultHandle[]{parameterizedType, annotations});
        ResultHandle resourceProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{resourceProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), resourceProviderSupplier);
    }

    private static void generateListBytecode(GeneratorContext ctx) {
        ResultHandle beanHandle;
        ResultHandle usesInstanceHandle;
        ResultHandle requiredType;
        InjectionPointInfo injectionPoint = ctx.injectionPoint;
        if (injectionPoint.isField()) {
            ctx.reflectionRegistration.registerField(injectionPoint.getTarget().asField());
        } else {
            ctx.reflectionRegistration.registerMethod(injectionPoint.getTarget().asMethod());
        }
        MethodCreator mc = ctx.constructor;
        ResultHandle injectionPointType = Types.getTypeHandle((BytecodeCreator)mc, ctx.injectionPoint.getType());
        org.jboss.jandex.Type type = (org.jboss.jandex.Type)ctx.injectionPoint.getType().asParameterizedType().arguments().get(0);
        if (type.name().equals((Object)DotNames.INSTANCE_HANDLE)) {
            requiredType = Types.getTypeHandle((BytecodeCreator)mc, (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0));
            usesInstanceHandle = mc.load(true);
        } else {
            requiredType = Types.getTypeHandle((BytecodeCreator)mc, type);
            usesInstanceHandle = mc.load(false);
        }
        ResultHandle qualifiers = BeanGenerator.collectInjectionPointQualifiers(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals);
        ResultHandle annotationsHandle = BeanGenerator.collectInjectionPointAnnotations(ctx.beanDeployment, ctx.constructor, ctx.injectionPoint, ctx.annotationLiterals, ctx.injectionPointAnnotationsPredicate);
        ResultHandle javaMemberHandle = BeanGenerator.getJavaMemberHandle(ctx.constructor, ctx.injectionPoint, ctx.reflectionRegistration);
        switch (ctx.targetInfo.kind()) {
            case OBSERVER: {
                beanHandle = ctx.constructor.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, ctx.constructor.getMethodParam(0), new ResultHandle[0]);
                break;
            }
            case BEAN: {
                beanHandle = ctx.constructor.getThis();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported target info: " + ctx.targetInfo);
            }
        }
        ResultHandle listProvider = ctx.constructor.newInstance(MethodDescriptor.ofConstructor(ListProvider.class, (Class[])new Class[]{Type.class, Type.class, Set.class, InjectableBean.class, Set.class, Member.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE}), new ResultHandle[]{requiredType, injectionPointType, qualifiers, beanHandle, annotationsHandle, javaMemberHandle, ctx.constructor.load(ctx.injectionPoint.getPosition()), ctx.constructor.load(ctx.injectionPoint.isTransient()), usesInstanceHandle});
        ResultHandle listProviderSupplier = ctx.constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{listProvider});
        ctx.constructor.writeInstanceField(FieldDescriptor.of((String)ctx.clazzCreator.getClassName(), (String)ctx.providerName, (String)Supplier.class.getName()), ctx.constructor.getThis(), listProviderSupplier);
    }

    private static void validateInstance(InjectionTargetInfo injectionTarget, InjectionPointInfo injectionPoint, Consumer<Throwable> errors) {
        if (injectionPoint.getType().kind() != Type.Kind.PARAMETERIZED_TYPE) {
            errors.accept((Throwable)new DefinitionException("An injection point of raw type jakarta.enterprise.inject.Instance is defined: " + injectionPoint.getTargetInfo()));
        } else if (injectionPoint.getRequiredType().kind() == Type.Kind.WILDCARD_TYPE) {
            errors.accept((Throwable)new DefinitionException("Wildcard is not a legal type argument for jakarta.enterprise.inject.Instance: " + injectionPoint.getTargetInfo()));
        } else if (injectionPoint.getRequiredType().kind() == Type.Kind.TYPE_VARIABLE) {
            errors.accept((Throwable)new DefinitionException("Type variable is not a legal type argument for jakarta.enterprise.inject.Instance: " + injectionPoint.getTargetInfo()));
        }
    }

    private static void validateList(InjectionTargetInfo injectionTarget, InjectionPointInfo injectionPoint, Consumer<Throwable> errors) {
        if (injectionPoint.getType().kind() != Type.Kind.PARAMETERIZED_TYPE) {
            errors.accept((Throwable)new DefinitionException("An injection point of raw type is defined: " + injectionPoint.getTargetInfo()));
        } else {
            org.jboss.jandex.Type typeParam = (org.jboss.jandex.Type)injectionPoint.getType().asParameterizedType().arguments().get(0);
            if (typeParam.kind() == Type.Kind.WILDCARD_TYPE) {
                ClassInfo declaringClass = injectionPoint.isField() ? injectionPoint.getTarget().asField().declaringClass() : injectionPoint.getTarget().asMethod().declaringClass();
                if (KotlinUtils.isKotlinClass(declaringClass)) {
                    errors.accept((Throwable)new DefinitionException("kotlin.collections.List cannot be used together with the @All qualifier, please use MutableList or java.util.List instead: " + injectionPoint.getTargetInfo()));
                } else {
                    errors.accept((Throwable)new DefinitionException("Wildcard is not a legal type argument for: " + injectionPoint.getTargetInfo()));
                }
            } else if (typeParam.kind() == Type.Kind.TYPE_VARIABLE) {
                errors.accept((Throwable)new DefinitionException("Type variable is not a legal type argument for: " + injectionPoint.getTargetInfo()));
            }
        }
    }

    private static void validateInjectionPoint(InjectionTargetInfo injectionTarget, InjectionPointInfo injectionPoint, Consumer<Throwable> errors) {
        if (injectionTarget.kind() != InjectionTargetInfo.TargetKind.BEAN || !BuiltinScope.DEPENDENT.is(injectionTarget.asBean().getScope())) {
            String msg = injectionPoint.getTargetInfo();
            if (msg.isBlank()) {
                msg = injectionTarget.toString();
            }
            errors.accept((Throwable)new DefinitionException("Only @Dependent beans can access metadata about an injection point: " + msg));
        }
    }

    private static void validateEventMetadata(InjectionTargetInfo injectionTarget, InjectionPointInfo injectionPoint, Consumer<Throwable> errors) {
        if (injectionTarget.kind() != InjectionTargetInfo.TargetKind.OBSERVER) {
            errors.accept((Throwable)new DefinitionException("EventMetadata can be only injected into an observer method: " + injectionPoint.getTargetInfo()));
        }
    }

    @FunctionalInterface
    static interface Validator {
        public static final Validator NOOP = (it, ip, e) -> {};

        public void validate(InjectionTargetInfo var1, InjectionPointInfo var2, Consumer<Throwable> var3);
    }

    @FunctionalInterface
    static interface Generator {
        public static final Generator NOOP = ctx -> {};

        public void generate(GeneratorContext var1);
    }

    public static class GeneratorContext {
        final ClassOutput classOutput;
        final BeanDeployment beanDeployment;
        final InjectionPointInfo injectionPoint;
        final ClassCreator clazzCreator;
        final MethodCreator constructor;
        final String providerName;
        final AnnotationLiteralProcessor annotationLiterals;
        final InjectionTargetInfo targetInfo;
        final ReflectionRegistration reflectionRegistration;
        final Predicate<DotName> injectionPointAnnotationsPredicate;

        public GeneratorContext(ClassOutput classOutput, BeanDeployment beanDeployment, InjectionPointInfo injectionPoint, ClassCreator clazzCreator, MethodCreator constructor, String providerName, AnnotationLiteralProcessor annotationLiterals, InjectionTargetInfo targetInfo, ReflectionRegistration reflectionRegistration, Predicate<DotName> injectionPointAnnotationsPredicate) {
            this.classOutput = classOutput;
            this.beanDeployment = beanDeployment;
            this.injectionPoint = injectionPoint;
            this.clazzCreator = clazzCreator;
            this.constructor = constructor;
            this.providerName = providerName;
            this.annotationLiterals = annotationLiterals;
            this.targetInfo = targetInfo;
            this.reflectionRegistration = reflectionRegistration;
            this.injectionPointAnnotationsPredicate = injectionPointAnnotationsPredicate;
        }
    }
}

