/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.Mockable;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AsmUtilCopy;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class ClientProxyGenerator
extends AbstractGenerator {
    static final String CLIENT_PROXY_SUFFIX = "_ClientProxy";
    static final String DELEGATE_METHOD_NAME = "arc$delegate";
    static final String SET_MOCK_METHOD_NAME = "arc$setMock";
    static final String CLEAR_MOCK_METHOD_NAME = "arc$clearMock";
    static final String GET_CONTEXTUAL_INSTANCE_METHOD_NAME = "arc_contextualInstance";
    static final String GET_BEAN = "arc_bean";
    static final String BEAN_FIELD = "bean";
    static final String MOCK_FIELD = "mock";
    static final String CONTEXT_FIELD = "context";
    private final Predicate<DotName> applicationClassPredicate;
    private final boolean mockable;
    private final ReflectionRegistration reflectionRegistration;
    private final Set<String> existingClasses;

    public ClientProxyGenerator(Predicate<DotName> applicationClassPredicate, boolean generateSources, boolean mockable, ReflectionRegistration reflectionRegistration, Set<String> existingClasses) {
        super(generateSources);
        this.applicationClassPredicate = applicationClassPredicate;
        this.mockable = mockable;
        this.reflectionRegistration = reflectionRegistration;
        this.existingClasses = existingClasses;
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean, String beanClassName, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        ResourceClassOutput classOutput = new ResourceClassOutput(this.applicationClassPredicate.test(bean.getBeanClass()), this.generateSources);
        BeanGenerator.ProviderType providerType = new BeanGenerator.ProviderType(bean.getProviderType());
        ClassInfo providerClass = IndexClassLookupUtils.getClassByName(bean.getDeployment().getBeanArchiveIndex(), providerType.name());
        String baseName = this.getBaseName(bean, beanClassName);
        String targetPackage = this.getPackageName(bean);
        String generatedName = ClientProxyGenerator.generatedNameFromTarget(targetPackage, baseName, CLIENT_PROXY_SUFFIX);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        ArrayList<String> interfaces = new ArrayList<String>();
        String superClass = Object.class.getName();
        interfaces.add(ClientProxy.class.getName());
        boolean isInterface = false;
        if (Modifier.isInterface(providerClass.flags())) {
            isInterface = true;
            interfaces.add(providerType.className());
        } else {
            superClass = providerType.className();
        }
        if (this.mockable) {
            interfaces.add(Mockable.class.getName());
        }
        ClassCreator clientProxy = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).superClass(superClass).interfaces(interfaces.toArray(new String[0])).build();
        if (AsmUtilCopy.needsSignature(providerClass)) {
            clientProxy.setSignature(AsmUtilCopy.getSignature(providerClass));
        }
        Map<ClassInfo, Map<TypeVariable, Type>> resolvedTypeVariables = Types.resolvedTypeVariables(providerClass, bean.getDeployment());
        FieldCreator beanField = (FieldCreator)clientProxy.getFieldCreator(BEAN_FIELD, DescriptorUtils.extToInt((String)beanClassName)).setModifiers(18);
        if (this.mockable) {
            clientProxy.getFieldCreator(MOCK_FIELD, Object.class).setModifiers(66);
        }
        FieldCreator contextField = null;
        if (BuiltinScope.APPLICATION.is(bean.getScope())) {
            contextField = (FieldCreator)clientProxy.getFieldCreator(CONTEXT_FIELD, InjectableContext.class).setModifiers(18);
        }
        this.createConstructor(clientProxy, beanClassName, superClass, beanField.getFieldDescriptor(), contextField != null ? contextField.getFieldDescriptor() : null);
        this.implementDelegate(clientProxy, providerType, beanField.getFieldDescriptor(), bean);
        this.implementGetContextualInstance(clientProxy, providerType);
        this.implementGetBean(clientProxy, beanField.getFieldDescriptor());
        if (this.mockable) {
            this.implementMockMethods(clientProxy);
        }
        for (MethodInfo method : this.getDelegatingMethods(bean, bytecodeTransformerConsumer, transformUnproxyableClasses)) {
            ResultHandle ret;
            MethodDescriptor originalMethodDescriptor = MethodDescriptor.of((MethodInfo)method);
            MethodCreator forward = clientProxy.getMethodCreator(originalMethodDescriptor);
            if (AsmUtilCopy.needsSignature(method)) {
                Map<TypeVariable, Type> methodClassVariables = resolvedTypeVariables.get(method.declaringClass());
                String signature = AsmUtilCopy.getSignature(method, typeVariable -> {
                    Type ret;
                    if (methodClassVariables != null && (ret = (Type)methodClassVariables.get(typeVariable)) != typeVariable) {
                        return ret;
                    }
                    return null;
                });
                forward.setSignature(signature);
            }
            for (Type exception : method.exceptions()) {
                forward.addException(exception.toString());
            }
            ResultHandle[] params = new ResultHandle[method.parameters().size()];
            for (int i = 0; i < method.parameters().size(); ++i) {
                params[i] = forward.getMethodParam(i);
            }
            if (!superClass.equals(Object.class.getName())) {
                BytecodeCreator notConstructed = forward.ifNull(forward.readInstanceField(beanField.getFieldDescriptor(), forward.getThis())).trueBranch();
                if (Modifier.isAbstract(method.flags())) {
                    notConstructed.throwException(IllegalStateException.class, "Cannot delegate to an abstract method");
                } else {
                    MethodDescriptor superDescriptor = MethodDescriptor.ofMethod((Object)superClass, (String)method.name(), (Object)method.returnType().name().toString(), (Object[])method.parameters().stream().map(p -> p.name().toString()).toArray());
                    notConstructed.returnValue(notConstructed.invokeSpecialMethod(superDescriptor, notConstructed.getThis(), params));
                }
            }
            ResultHandle delegate = forward.invokeVirtualMethod(MethodDescriptor.ofMethod((String)generatedName, (String)DELEGATE_METHOD_NAME, (String)providerType.descriptorName(), (String[])new String[0]), forward.getThis(), new ResultHandle[0]);
            if (Methods.isObjectToString(method)) {
                ret = forward.invokeVirtualMethod(originalMethodDescriptor, delegate, params);
            } else if (isInterface) {
                ret = forward.invokeInterfaceMethod(method, delegate, params);
            } else if (this.isReflectionFallbackNeeded(method, targetPackage)) {
                ResultHandle paramTypesArray = forward.newArray(Class.class, forward.load(method.parameters().size()));
                int idx = 0;
                for (Type param : method.parameters()) {
                    forward.writeArrayValue(paramTypesArray, idx++, forward.loadClass(param.name().toString()));
                }
                ResultHandle argsArray = forward.newArray(Object.class, forward.load(params.length));
                idx = 0;
                for (ResultHandle argHandle : params) {
                    forward.writeArrayValue(argsArray, idx++, argHandle);
                }
                this.reflectionRegistration.registerMethod(method);
                ret = forward.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{forward.loadClass(method.declaringClass().name().toString()), forward.load(method.name()), paramTypesArray, delegate, argsArray});
            } else {
                MethodDescriptor virtualMethod = MethodDescriptor.ofMethod((String)providerType.className(), (String)originalMethodDescriptor.getName(), (String)originalMethodDescriptor.getReturnType(), (String[])originalMethodDescriptor.getParameterTypes());
                ret = forward.invokeVirtualMethod(virtualMethod, delegate, params);
            }
            forward.returnValue(ret);
        }
        clientProxy.close();
        return classOutput.getResources();
    }

    private void implementMockMethods(ClassCreator clientProxy) {
        MethodCreator clear = clientProxy.getMethodCreator(MethodDescriptor.ofMethod((Object)clientProxy.getClassName(), (String)CLEAR_MOCK_METHOD_NAME, Void.TYPE, (Object[])new Object[0]));
        clear.writeInstanceField(FieldDescriptor.of((String)clientProxy.getClassName(), (String)MOCK_FIELD, Object.class), clear.getThis(), clear.loadNull());
        clear.returnValue(null);
        MethodCreator set = clientProxy.getMethodCreator(MethodDescriptor.ofMethod((Object)clientProxy.getClassName(), (String)SET_MOCK_METHOD_NAME, Void.TYPE, (Object[])new Object[]{Object.class}));
        set.writeInstanceField(FieldDescriptor.of((String)clientProxy.getClassName(), (String)MOCK_FIELD, Object.class), set.getThis(), set.getMethodParam(0));
        set.returnValue(null);
    }

    void createConstructor(ClassCreator clientProxy, String beanClassName, String superClasName, FieldDescriptor beanField, FieldDescriptor contextField) {
        MethodCreator creator = clientProxy.getMethodCreator("<init>", Void.TYPE, new Object[]{beanClassName});
        creator.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)superClasName, (String[])new String[0]), creator.getThis(), new ResultHandle[0]);
        ResultHandle beanHandle = creator.getMethodParam(0);
        creator.writeInstanceField(beanField, creator.getThis(), beanHandle);
        if (contextField != null) {
            creator.writeInstanceField(contextField, creator.getThis(), creator.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_GET_ACTIVE_CONTEXT, creator.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]), new ResultHandle[]{creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InjectableBean.class, (String)"getScope", Class.class, (Class[])new Class[0]), beanHandle, new ResultHandle[0])}));
        }
        creator.returnValue(null);
    }

    void implementDelegate(ClassCreator clientProxy, BeanGenerator.ProviderType providerType, FieldDescriptor beanField, BeanInfo bean) {
        ResultHandle contextHandle;
        MethodCreator creator = (MethodCreator)clientProxy.getMethodCreator(DELEGATE_METHOD_NAME, providerType.descriptorName(), new String[0]).setModifiers(2);
        if (this.mockable) {
            ResultHandle mock = creator.readInstanceField(FieldDescriptor.of((String)clientProxy.getClassName(), (String)MOCK_FIELD, (String)Object.class.getName()), creator.getThis());
            BytecodeCreator falseBranch = creator.ifNull(mock).falseBranch();
            falseBranch.returnValue(falseBranch.checkCast(mock, providerType.className()));
        }
        ResultHandle beanHandle = creator.readInstanceField(beanField, creator.getThis());
        if (BuiltinScope.APPLICATION.is(bean.getScope())) {
            contextHandle = creator.readInstanceField(FieldDescriptor.of((String)clientProxy.getClassName(), (String)CONTEXT_FIELD, InjectableContext.class), creator.getThis());
        } else {
            ResultHandle container = creator.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
            ResultHandle scope = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InjectableBean.class, (String)"getScope", Class.class, (Class[])new Class[0]), beanHandle, new ResultHandle[0]);
            contextHandle = creator.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_GET_ACTIVE_CONTEXT, container, new ResultHandle[]{scope});
            BytecodeCreator inactiveBranch = creator.ifNull(contextHandle).trueBranch();
            ResultHandle exception = inactiveBranch.newInstance(MethodDescriptor.ofConstructor(ContextNotActiveException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{inactiveBranch.invokeVirtualMethod(MethodDescriptors.OBJECT_TO_STRING, scope, new ResultHandle[0])});
            inactiveBranch.throwException(exception);
        }
        AssignableResultHandle ret = creator.createVariable(Object.class);
        creator.assign(ret, creator.invokeInterfaceMethod(MethodDescriptors.CONTEXT_GET_IF_PRESENT, contextHandle, new ResultHandle[]{beanHandle}));
        BytecodeCreator isNullBranch = creator.ifNull((ResultHandle)ret).trueBranch();
        ResultHandle creationContext = isNullBranch.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{beanHandle});
        isNullBranch.assign(ret, isNullBranch.invokeInterfaceMethod(MethodDescriptors.CONTEXT_GET, contextHandle, new ResultHandle[]{beanHandle, creationContext}));
        creator.returnValue((ResultHandle)ret);
    }

    void implementGetContextualInstance(ClassCreator clientProxy, BeanGenerator.ProviderType providerType) {
        MethodCreator creator = (MethodCreator)clientProxy.getMethodCreator(GET_CONTEXTUAL_INSTANCE_METHOD_NAME, Object.class, new Class[0]).setModifiers(1);
        creator.returnValue(creator.invokeVirtualMethod(MethodDescriptor.ofMethod((String)clientProxy.getClassName(), (String)DELEGATE_METHOD_NAME, (String)providerType.descriptorName(), (String[])new String[0]), creator.getThis(), new ResultHandle[0]));
    }

    void implementGetBean(ClassCreator clientProxy, FieldDescriptor beanField) {
        MethodCreator creator = (MethodCreator)clientProxy.getMethodCreator(GET_BEAN, InjectableBean.class, new Class[0]).setModifiers(1);
        creator.returnValue(creator.readInstanceField(beanField, creator.getThis()));
    }

    Collection<MethodInfo> getDelegatingMethods(BeanInfo bean, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        HashMap<Methods.MethodKey, MethodInfo> methods = new HashMap<Methods.MethodKey, MethodInfo>();
        if (bean.isClassBean()) {
            HashSet<Methods.NameAndDescriptor> methodsFromWhichToRemoveFinal = new HashSet<Methods.NameAndDescriptor>();
            ClassInfo classInfo = bean.getTarget().get().asClass();
            Methods.addDelegatingMethods(bean.getDeployment().getBeanArchiveIndex(), classInfo, methods, methodsFromWhichToRemoveFinal, transformUnproxyableClasses);
            if (!methodsFromWhichToRemoveFinal.isEmpty()) {
                String className = classInfo.name().toString();
                bytecodeTransformerConsumer.accept(new BytecodeTransformer(className, new Methods.RemoveFinalFromMethod(className, methodsFromWhichToRemoveFinal)));
            }
        } else if (bean.isProducerMethod()) {
            MethodInfo producerMethod = bean.getTarget().get().asMethod();
            ClassInfo returnTypeClass = IndexClassLookupUtils.getClassByName(bean.getDeployment().getBeanArchiveIndex(), producerMethod.returnType());
            Methods.addDelegatingMethods(bean.getDeployment().getBeanArchiveIndex(), returnTypeClass, methods, null, transformUnproxyableClasses);
        } else if (bean.isProducerField()) {
            FieldInfo producerField = bean.getTarget().get().asField();
            ClassInfo fieldClass = IndexClassLookupUtils.getClassByName(bean.getDeployment().getBeanArchiveIndex(), producerField.type());
            Methods.addDelegatingMethods(bean.getDeployment().getBeanArchiveIndex(), fieldClass, methods, null, transformUnproxyableClasses);
        } else if (bean.isSynthetic()) {
            Methods.addDelegatingMethods(bean.getDeployment().getBeanArchiveIndex(), bean.getImplClazz(), methods, null, transformUnproxyableClasses);
        }
        return methods.values();
    }
}

