/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.hotspot;

import io.prometheus.client.Collector;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ThreadExports
extends Collector {
    private static final List<String> EMPTY_LABEL = Collections.emptyList();
    private final ThreadMXBean threadBean;

    public ThreadExports() {
        this(ManagementFactory.getThreadMXBean());
    }

    public ThreadExports(ThreadMXBean threadBean) {
        this.threadBean = threadBean;
    }

    void addThreadMetrics(List<Collector.MetricFamilySamples> sampleFamilies) {
        sampleFamilies.add(new Collector.MetricFamilySamples("jvm_threads_current", Collector.Type.GAUGE, "Current thread count of a JVM", Collections.singletonList(new Collector.MetricFamilySamples.Sample("jvm_threads_current", EMPTY_LABEL, EMPTY_LABEL, (double)this.threadBean.getThreadCount()))));
        sampleFamilies.add(new Collector.MetricFamilySamples("jvm_threads_daemon", Collector.Type.GAUGE, "Daemon thread count of a JVM", Collections.singletonList(new Collector.MetricFamilySamples.Sample("jvm_threads_daemon", EMPTY_LABEL, EMPTY_LABEL, (double)this.threadBean.getDaemonThreadCount()))));
        sampleFamilies.add(new Collector.MetricFamilySamples("jvm_peak_threads", Collector.Type.GAUGE, "Peak thread count of a JVM", Collections.singletonList(new Collector.MetricFamilySamples.Sample("jvm_threads_peak", EMPTY_LABEL, EMPTY_LABEL, (double)this.threadBean.getPeakThreadCount()))));
        sampleFamilies.add(new Collector.MetricFamilySamples("jvm_threads_started_total", Collector.Type.COUNTER, "Started thread count of a JVM", Collections.singletonList(new Collector.MetricFamilySamples.Sample("jvm_threads_started_total", EMPTY_LABEL, EMPTY_LABEL, (double)this.threadBean.getTotalStartedThreadCount()))));
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addThreadMetrics(mfs);
        return mfs;
    }
}

