/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.bootstrap.ServerBootstrap;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpServerOperator;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.tcp.TcpServer;

final class HttpServerHandle
extends HttpServerOperator
implements ConnectionObserver,
Function<ServerBootstrap, ServerBootstrap> {
    final BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler;

    HttpServerHandle(HttpServer server, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        super(server);
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    @Override
    protected TcpServer tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (newState == ConnectionObserver.State.CONFIGURED) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "Handler is being applied: {}"), new Object[]{this.handler});
                }
                HttpServerOperations ops = (HttpServerOperations)connection;
                Mono.fromDirect(this.handler.apply(ops, ops)).subscribe(ops.disposeSubscriber());
            }
            catch (Throwable t) {
                log.error(ReactorNetty.format(connection.channel(), ""), t);
                connection.channel().close();
            }
        }
    }

    @Override
    public ServerBootstrap apply(ServerBootstrap b) {
        ConnectionObserver observer = BootstrapHandlers.childConnectionObserver(b);
        BootstrapHandlers.childConnectionObserver(b, observer.then(this));
        return b;
    }
}

