/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

abstract class PublisherContext {
    PublisherContext() {
    }

    static <T> Publisher<T> withContext(Publisher<T> publisher, Context context) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(context);
        if (publisher instanceof Callable) {
            return publisher;
        }
        if (publisher instanceof Flux) {
            return ((Flux)publisher).subscriberContext(context);
        }
        if (publisher instanceof Mono) {
            return ((Mono)publisher).subscriberContext(context);
        }
        return publisher;
    }

    static <T, V> Publisher<V> publiserOrScalarMap(Publisher<T> publisher, Function<? super T, ? extends V> mapper) {
        if (publisher instanceof Callable) {
            return Mono.fromCallable(new ScalarMap<T, V>(publisher, mapper));
        }
        return Flux.from(publisher).map(mapper);
    }

    static final class ScalarMap<T, V>
    implements Callable<V> {
        final Callable<T> source;
        final Function<? super T, ? extends V> mapper;

        public ScalarMap(Publisher<T> source, Function<? super T, ? extends V> mapper) {
            this.source = (Callable)source;
            this.mapper = mapper;
        }

        @Override
        public V call() throws Exception {
            T called = this.source.call();
            if (called == null) {
                return null;
            }
            return this.mapper.apply(called);
        }
    }
}

