package io.lettuce.core.api.reactive;

import reactor.core.publisher.Mono;
import io.lettuce.core.TransactionResult;

/**
 * Reactive executed commands for Transactions.
 *
 * @param <K> Key type.
 * @param <V> Value type.
 * @author Mark Paluch
 * @since 4.0
 * @generated by io.lettuce.apigenerator.CreateReactiveApi
 */
public interface RedisTransactionalReactiveCommands<K, V> {

    /**
     * Discard all commands issued after MULTI.
     *
     * @return String simple-string-reply always {@code OK}.
     */
    Mono<String> discard();

    /**
     * Execute all commands issued after MULTI.
     *
     * @return Object array-reply each element being the reply to each of the commands in the atomic transaction.
     *
     *         When using {@code WATCH}, {@code EXEC} can return a {@link TransactionResult#wasDiscarded discarded
     *         TransactionResult}.
     * @see TransactionResult#wasDiscarded
     */
    Mono<TransactionResult> exec();

    /**
     * Mark the start of a transaction block.
     *
     * @return String simple-string-reply always {@code OK}.
     */
    Mono<String> multi();

    /**
     * Watch the given keys to determine execution of the MULTI/EXEC block.
     *
     * @param keys the key.
     * @return String simple-string-reply always {@code OK}.
     */
    Mono<String> watch(K... keys);

    /**
     * Forget about all watched keys.
     *
     * @return String simple-string-reply always {@code OK}.
     */
    Mono<String> unwatch();

}
