/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class RoundRobin<V> {
    protected volatile Collection<? extends V> collection = Collections.emptyList();
    protected volatile V offset;

    RoundRobin() {
    }

    public boolean isConsistent(Collection<? extends V> master) {
        Collection<V> collection = this.collection;
        return collection.containsAll(master) && master.containsAll(collection);
    }

    public void rebuild(Collection<? extends V> master) {
        this.collection = new ArrayList<V>(master);
        this.offset = null;
    }

    public V next() {
        Collection<V> collection = this.collection;
        V offset = this.offset;
        if (offset != null) {
            boolean accept = false;
            for (V element : collection) {
                if (element == offset) {
                    accept = true;
                    continue;
                }
                if (!accept) continue;
                this.offset = element;
                return this.offset;
            }
        }
        this.offset = collection.iterator().next();
        return this.offset;
    }
}

