/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.graphql.generator.exceptions.TypeMappingException;
import io.leangen.graphql.util.Utils;
import io.leangen.graphql.util.classpath.ClassFinder;
import io.leangen.graphql.util.classpath.ClassReadingException;
import io.leangen.graphql.util.classpath.SubclassClassFilter;
import java.beans.Introspector;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassUtils {
    private static final Map<Class, List<Class>> implementationCache;
    private static final Class<?> javassistProxyClass;
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final Set<Class> ROOT_TYPES;

    public static Set<Method> getAnnotatedMethods(Class<?> type, Class<? extends Annotation> annotation) {
        HashSet<Method> methods = new HashSet<Method>();
        ClassUtils.collectPublicAbstractMethods(type, methods);
        Collections.addAll(methods, type.getMethods());
        return methods.stream().filter(element -> element.isAnnotationPresent(annotation)).collect(Collectors.toSet());
    }

    public static Set<Field> getAnnotatedFields(Class<?> type, Class<? extends Annotation> annotation) {
        return Arrays.stream(type.getFields()).filter(element -> element.isAnnotationPresent(annotation)).collect(Collectors.toSet());
    }

    private static void collectPublicAbstractMethods(Class type, Set<Method> methods) {
        if (type == null || type.equals(Object.class)) {
            return;
        }
        if (ClassUtils.isAbstract(type)) {
            Arrays.stream(type.getDeclaredMethods()).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> Modifier.isAbstract(method.getModifiers())).forEach(methods::add);
        }
        ClassUtils.collectPublicAbstractMethods(type.getSuperclass(), methods);
    }

    public static AnnotatedType getReturnType(Method method, AnnotatedType declaringType) {
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType((AnnotatedType)GenericTypeReflector.capture((AnnotatedType)declaringType), method.getDeclaringClass());
        if (GenericTypeReflector.isMissingTypeParameters((Type)exactDeclaringType.getType())) {
            return method.getAnnotatedReturnType();
        }
        return GenericTypeReflector.getReturnType((Method)method, (AnnotatedType)declaringType);
    }

    public static AnnotatedType getFieldType(Field field, AnnotatedType declaringType) {
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType((AnnotatedType)GenericTypeReflector.capture((AnnotatedType)declaringType), field.getDeclaringClass());
        if (GenericTypeReflector.isMissingTypeParameters((Type)exactDeclaringType.getType())) {
            return field.getAnnotatedType();
        }
        return GenericTypeReflector.getFieldType((Field)field, (AnnotatedType)declaringType);
    }

    public static AnnotatedType[] getParameterTypes(Executable executable, AnnotatedType declaringType) {
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType((AnnotatedType)GenericTypeReflector.capture((AnnotatedType)declaringType), executable.getDeclaringClass());
        if (GenericTypeReflector.isMissingTypeParameters((Type)exactDeclaringType.getType())) {
            return executable.getAnnotatedParameterTypes();
        }
        return GenericTypeReflector.getParameterTypes((Executable)executable, (AnnotatedType)declaringType);
    }

    public static Class<?> getRawType(Type type) {
        Class erased = GenericTypeReflector.erase((Type)type);
        if (erased == Object.class && type != Object.class) {
            throw new TypeMappingException("Type of " + type.getTypeName() + " is lost to erasure. Consider explicitly providing the type to GraphQLSchemaGenerator#withOperationsFrom... methods, or customizing the mapping process.");
        }
        return erased;
    }

    public static boolean isGetter(Method getter) {
        return getter.getParameterCount() == 0 && getter.getReturnType() != Void.TYPE && getter.getReturnType() != Void.class && getter.getName().startsWith("get") || (getter.getReturnType() == Boolean.class || getter.getReturnType() == Boolean.TYPE) && getter.getName().startsWith("is");
    }

    public static boolean isSetter(Method setter) {
        return setter.getName().startsWith("set") && setter.getParameterCount() == 1;
    }

    public static String getFieldNameFromGetter(Method getter) {
        return Introspector.decapitalize(getter.getName().replaceAll("^get", "").replaceAll("^is", ""));
    }

    public static String getFieldNameFromSetter(Method setter) {
        return Introspector.decapitalize(setter.getName().replaceAll("^set", ""));
    }

    public static Method findGetter(Class<?> type, String fieldName) throws NoSuchMethodException {
        try {
            return type.getMethod("get" + ClassUtils.capitalize(fieldName), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return type.getMethod("is" + ClassUtils.capitalize(fieldName), new Class[0]);
        }
    }

    public static Method findSetter(Class<?> type, String fieldName, Class<?> fieldType) throws NoSuchMethodException {
        return type.getMethod("set" + ClassUtils.capitalize(fieldName), fieldType);
    }

    public static <T> T getFieldValue(Object source, String fieldName) {
        try {
            try {
                return (T)ClassUtils.findGetter(source.getClass(), fieldName).invoke(source, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                return (T)source.getClass().getField(fieldName).get(source);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to extract the value of field " + fieldName + " from the given instance of " + source.getClass(), e);
        }
    }

    public static List<AnnotatedType> findImplementations(AnnotatedType superType, String ... packages) {
        Class<?> rawType = ClassUtils.getRawType(superType.getType());
        return ClassUtils.findImplementations(rawType, packages).stream().map(raw -> GenericTypeReflector.getExactSubType((AnnotatedType)superType, (Class)raw)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<Class> findImplementations(Class superType, String ... packages) {
        if (implementationCache.containsKey(superType)) {
            return implementationCache.get(superType);
        }
        try {
            ClassFinder classFinder = new ClassFinder();
            packages = packages == null ? null : (String[])Arrays.stream(packages).filter(Utils::notEmpty).toArray(String[]::new);
            classFinder = packages == null || packages.length == 0 ? classFinder.addExplicitClassPath() : classFinder.add(superType.getClassLoader(), packages);
            List<Class> implementations = classFinder.findClasses(new SubclassClassFilter(superType)).stream().map(classInfo -> ClassUtils.loadClass(classInfo.getClassName())).collect(Collectors.toList());
            implementationCache.putIfAbsent(superType, implementations);
            return implementations;
        }
        catch (ClassReadingException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isAbstract(AnnotatedType type) {
        return ClassUtils.isAbstract(ClassUtils.getRawType(type.getType()));
    }

    public static boolean isAbstract(Class<?> type) {
        return (type.isInterface() || Modifier.isAbstract(type.getModifiers())) && !type.isPrimitive() && !type.isArray();
    }

    public static boolean isAssignable(Type superType, Type subType) {
        return (superType instanceof ParameterizedType && Arrays.stream(((ParameterizedType)superType).getActualTypeArguments()).allMatch(arg -> arg instanceof TypeVariable) || superType instanceof GenericArrayType && ((GenericArrayType)superType).getGenericComponentType() instanceof TypeVariable) && ClassUtils.getRawType(superType).isAssignableFrom(ClassUtils.getRawType(subType)) || superType == Byte.class && subType == Byte.TYPE || superType == Short.class && subType == Short.TYPE || superType == Integer.class && subType == Integer.TYPE || superType == Long.class && subType == Long.TYPE || superType == Float.class && subType == Float.TYPE || superType == Double.class && subType == Double.TYPE || superType == Boolean.class && subType == Boolean.TYPE || superType == Void.class && subType == Void.TYPE || GenericTypeReflector.isSuperType((Type)superType, (Type)subType);
    }

    public static String toString(AnnotatedType type) {
        return type.getType().getTypeName() + "(" + Arrays.toString(type.getAnnotations()) + ")";
    }

    public static boolean containsTypeAnnotation(AnnotatedType type, Class<? extends Annotation> annotation) {
        if (type.isAnnotationPresent(annotation)) {
            return true;
        }
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
            return Arrays.stream(parameterizedType.getAnnotatedActualTypeArguments()).anyMatch(param -> ClassUtils.containsTypeAnnotation(param, annotation));
        }
        if (type instanceof AnnotatedTypeVariable) {
            AnnotatedTypeVariable variable = (AnnotatedTypeVariable)type;
            return Arrays.stream(variable.getAnnotatedBounds()).anyMatch(bound -> ClassUtils.containsTypeAnnotation(bound, annotation));
        }
        if (type instanceof AnnotatedWildcardType) {
            AnnotatedWildcardType wildcard = (AnnotatedWildcardType)type;
            return Stream.concat(Arrays.stream(wildcard.getAnnotatedLowerBounds()), Arrays.stream(wildcard.getAnnotatedUpperBounds())).anyMatch(param -> ClassUtils.containsTypeAnnotation(param, annotation));
        }
        if (type instanceof AnnotatedArrayType) {
            return ClassUtils.containsTypeAnnotation(((AnnotatedArrayType)type).getAnnotatedGenericComponentType(), annotation);
        }
        return false;
    }

    public static Annotation[] getAllAnnotations(Stream<AnnotatedType> types) {
        return (Annotation[])types.flatMap(type -> Arrays.stream(type.getAnnotations())).distinct().toArray(Annotation[]::new);
    }

    public static AnnotatedType addAnnotations(AnnotatedType type, Annotation[] annotations) {
        if (type == null || annotations == null || annotations.length == 0) {
            return type;
        }
        return GenericTypeReflector.updateAnnotations((AnnotatedType)type, (Annotation[])GenericTypeReflector.merge((Annotation[][])new Annotation[][]{type.getAnnotations(), annotations}));
    }

    public static AnnotatedType eraseBounds(AnnotatedType type, AnnotatedType replacement) {
        if (type instanceof AnnotatedWildcardType) {
            AnnotatedType bound;
            AnnotatedWildcardType wildcard = (AnnotatedWildcardType)type;
            AnnotatedType annotatedType = bound = wildcard.getAnnotatedLowerBounds().length > 0 ? ClassUtils.eraseBounds(wildcard.getAnnotatedLowerBounds()[0], replacement) : ClassUtils.eraseBounds(wildcard.getAnnotatedUpperBounds()[0], replacement);
            if (bound.getType().equals(Object.class)) {
                if (replacement != null) {
                    bound = replacement;
                } else {
                    throw new TypeMappingException(type.getType());
                }
            }
            return GenericTypeReflector.updateAnnotations((AnnotatedType)bound, (Annotation[])type.getAnnotations());
        }
        if (type instanceof AnnotatedTypeVariable) {
            AnnotatedType bound = ((AnnotatedTypeVariable)type).getAnnotatedBounds()[0];
            if (bound.getType().equals(Object.class)) {
                if (replacement != null) {
                    bound = replacement;
                } else {
                    throw new TypeMappingException(type.getType());
                }
            }
            return GenericTypeReflector.updateAnnotations((AnnotatedType)bound, (Annotation[])type.getAnnotations());
        }
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
            AnnotatedType[] typeArguments = (AnnotatedType[])Arrays.stream(parameterizedType.getAnnotatedActualTypeArguments()).map(parameterType -> ClassUtils.eraseBounds(parameterType, replacement)).toArray(AnnotatedType[]::new);
            return GenericTypeReflector.replaceParameters((AnnotatedParameterizedType)parameterizedType, (AnnotatedType[])typeArguments);
        }
        if (type instanceof AnnotatedArrayType) {
            return TypeFactory.arrayOf((AnnotatedType)ClassUtils.eraseBounds(((AnnotatedArrayType)type).getAnnotatedGenericComponentType(), replacement), (Annotation[])type.getAnnotations());
        }
        return type;
    }

    public static AnnotatedType completeGenerics(AnnotatedType type, AnnotatedType replacement) {
        if (type.getType() instanceof Class) {
            Class clazz = (Class)type.getType();
            if (clazz.isArray()) {
                return TypeFactory.arrayOf((AnnotatedType)ClassUtils.completeGenerics(GenericTypeReflector.annotate(clazz.getComponentType()), replacement), (Annotation[])type.getAnnotations());
            }
            if (GenericTypeReflector.isMissingTypeParameters((Type)clazz)) {
                if (replacement == null) {
                    throw new TypeMappingException(clazz);
                }
                AnnotatedType[] parameters = new AnnotatedType[clazz.getTypeParameters().length];
                for (int i = 0; i < parameters.length; ++i) {
                    parameters[i] = replacement;
                }
                return TypeFactory.parameterizedAnnotatedClass((Class)clazz, (Annotation[])type.getAnnotations(), (AnnotatedType[])parameters);
            }
        } else {
            if (type instanceof AnnotatedParameterizedType) {
                AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
                AnnotatedType[] parameters = (AnnotatedType[])Arrays.stream(parameterizedType.getAnnotatedActualTypeArguments()).map(parameterType -> ClassUtils.completeGenerics(parameterType, replacement)).toArray(AnnotatedType[]::new);
                return GenericTypeReflector.replaceParameters((AnnotatedParameterizedType)parameterizedType, (AnnotatedType[])parameters);
            }
            if (type instanceof AnnotatedArrayType) {
                AnnotatedType componentType = ClassUtils.completeGenerics(((AnnotatedArrayType)type).getAnnotatedGenericComponentType(), replacement);
                return TypeFactory.arrayOf((AnnotatedType)componentType, (Annotation[])type.getAnnotations());
            }
            if (type instanceof AnnotatedWildcardType || type instanceof AnnotatedTypeVariable) {
                throw new TypeMappingException(type.getType().getTypeName() + " can not be completed. Call eraseBounds first?");
            }
        }
        return type;
    }

    public static AnnotatedType getCommonSuperType(List<AnnotatedType> types) {
        return ClassUtils.getCommonSuperType(types, new HashSet<String>(), null);
    }

    public static AnnotatedType getCommonSuperType(List<AnnotatedType> types, AnnotatedType fallback) {
        return ClassUtils.getCommonSuperType(types, new HashSet<String>(), fallback);
    }

    private static AnnotatedType getCommonSuperType(List<AnnotatedType> types, Set<String> seenTypeCombos, AnnotatedType fallback) {
        if (types == null || types.isEmpty()) {
            throw new IllegalArgumentException("At least one type must be provided");
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        Annotation[] mergedAnnotations = ClassUtils.getMergedAnnotations(types.toArray(new AnnotatedType[types.size()]));
        if (types.stream().map(AnnotatedType::getType).allMatch(type -> type.equals(((AnnotatedType)types.get(0)).getType()))) {
            return GenericTypeReflector.replaceAnnotations((AnnotatedType)types.get(0), (Annotation[])mergedAnnotations);
        }
        List<Class<?>> classes = types.stream().map(AnnotatedType::getType).map(ClassUtils::getRawType).collect(Collectors.toList());
        String typeNames = types.stream().map(type -> type.getType().getTypeName()).sorted().collect(Collectors.joining(","));
        if (seenTypeCombos.contains(typeNames)) {
            return ClassUtils.fallbackOrException(fallback);
        }
        seenTypeCombos.add(typeNames);
        if (types.stream().allMatch(type -> type instanceof AnnotatedArrayType)) {
            List<AnnotatedType> componentTypes = types.stream().map(type -> ((AnnotatedArrayType)type).getAnnotatedGenericComponentType()).collect(Collectors.toList());
            AnnotatedType componentType = ClassUtils.getCommonSuperType(componentTypes, seenTypeCombos, fallback);
            return TypeFactory.arrayOf((AnnotatedType)componentType, (Annotation[])mergedAnnotations);
        }
        Class<?> commonRawSuperType = ClassUtils.getCommonSuperTypes(classes).get(0);
        if (classes.stream().noneMatch(ROOT_TYPES::contains) && ROOT_TYPES.contains(commonRawSuperType)) {
            return ClassUtils.fallbackOrException(fallback);
        }
        List normalizedTypes = types.stream().map(type -> GenericTypeReflector.getExactSuperType((AnnotatedType)type, (Class)commonRawSuperType)).collect(Collectors.toList());
        if (normalizedTypes.stream().anyMatch(type -> GenericTypeReflector.isMissingTypeParameters((Type)type.getType()))) {
            throw new TypeMappingException("Automatic type inference failed because some of the types are missing generic type parameter(s).");
        }
        if (normalizedTypes.stream().allMatch(type -> type.getType() instanceof Class)) {
            return GenericTypeReflector.annotate(commonRawSuperType, (Annotation[])mergedAnnotations);
        }
        if (normalizedTypes.stream().allMatch(type -> type instanceof AnnotatedParameterizedType)) {
            AnnotatedType[] parameters = (AnnotatedType[])Arrays.stream(commonRawSuperType.getTypeParameters()).map(param -> normalizedTypes.stream().map(type -> GenericTypeReflector.getTypeParameter((AnnotatedType)type, (TypeVariable)param)).collect(Collectors.toList())).map(paramTypes -> ClassUtils.getCommonSuperType(paramTypes, seenTypeCombos, fallback)).toArray(AnnotatedType[]::new);
            return TypeFactory.parameterizedAnnotatedClass(commonRawSuperType, (Annotation[])mergedAnnotations, (AnnotatedType[])parameters);
        }
        return ClassUtils.fallbackOrException(fallback);
    }

    public static List<Class<?>> getCommonSuperTypes(List<Class<?>> classes) {
        LinkedHashSet rollingIntersect = new LinkedHashSet(ClassUtils.getSuperTypes(classes.get(0)));
        for (int i = 1; i < classes.size(); ++i) {
            rollingIntersect.retainAll(ClassUtils.getSuperTypes(classes.get(i)));
        }
        if (rollingIntersect.isEmpty()) {
            return Collections.singletonList(Object.class);
        }
        LinkedList result = new LinkedList(rollingIntersect);
        result.sort(new TypeComparator());
        return result;
    }

    public static Set<Class<?>> getSuperTypes(Class<?> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        LinkedHashSet nextLevel = new LinkedHashSet();
        nextLevel.add(clazz);
        do {
            classes.addAll(nextLevel);
            LinkedHashSet thisLevel = new LinkedHashSet(nextLevel);
            nextLevel.clear();
            for (Class each : thisLevel) {
                Class superClass = each.getSuperclass();
                if (superClass != null && superClass != Object.class) {
                    nextLevel.add(superClass);
                }
                Collections.addAll(nextLevel, each.getInterfaces());
            }
        } while (!nextLevel.isEmpty());
        return classes;
    }

    private static AnnotatedType fallbackOrException(AnnotatedType fallback) {
        if (fallback != null) {
            return fallback;
        }
        throw new TypeMappingException("Automatic type inference failed because some of the types had no common ancestors except for Object class");
    }

    public static boolean isProxy(Class<?> clazz) {
        return Proxy.isProxyClass(clazz) || javassistProxyClass != null && javassistProxyClass.isAssignableFrom(clazz) || clazz.getName().contains(CGLIB_CLASS_SEPARATOR);
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
    }

    private static String capitalize(String str) {
        char newChar;
        char firstChar = str.charAt(0);
        if (firstChar == (newChar = Character.toUpperCase(firstChar))) {
            return str;
        }
        char[] newChars = new char[str.length()];
        newChars[0] = newChar;
        str.getChars(1, str.length(), newChars, 1);
        return String.valueOf(newChars);
    }

    private static Class<?> loadClass(String className) {
        try {
            return ClassUtils.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Annotation[] getMergedAnnotations(AnnotatedType ... types) {
        return (Annotation[])Arrays.stream(types).flatMap(type -> Arrays.stream(type.getAnnotations())).distinct().toArray(Annotation[]::new);
    }

    static {
        Class<?> proxy;
        implementationCache = new ConcurrentHashMap<Class, List<Class>>();
        ROOT_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Object.class, Annotation.class, Cloneable.class, Comparable.class, Serializable.class)));
        try {
            proxy = ClassUtils.forName("javassist.util.proxy.ProxyObject");
        }
        catch (ClassNotFoundException e) {
            proxy = null;
        }
        javassistProxyClass = proxy;
    }

    private static class TypeComparator
    implements Comparator<Class<?>> {
        private TypeComparator() {
        }

        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            if (c2 == Cloneable.class || c2 == Serializable.class) {
                return -1;
            }
            if (!c1.isInterface() && c2.isInterface()) {
                return -1;
            }
            if (c2.isAssignableFrom(c1)) {
                return -1;
            }
            return 0;
        }
    }
}

