/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SimpleStringValueMapper {
    protected Serializer<Object> TO_BASE64_STRING;
    protected Serializer<Object> TO_STRING;
    protected Deserializer<Object> FROM_BASE64_STRING;
    private Map<Type, Serializer<?>> serializers = new HashMap();
    private Map<Type, Deserializer<?>> deserializers = new HashMap();

    public SimpleStringValueMapper() {
        this.TO_STRING = Object::toString;
        this.TO_BASE64_STRING = value -> {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
                out.writeObject(value);
                String string = Base64.getEncoder().encodeToString(bytes.toByteArray());
                return string;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        this.FROM_BASE64_STRING = serializedValue -> {
            ByteArrayInputStream bytes = new ByteArrayInputStream(Base64.getDecoder().decode(serializedValue));
            try (ObjectInputStream out = new ObjectInputStream(bytes);){
                Object object = out.readObject();
                return object;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
        this.withSerializer(Date.class, date -> Long.toString(date.getTime()));
        this.withSerializer(String.class, val -> val);
        this.withSerializer(Long.class, this.TO_STRING);
        this.withSerializer(Integer.class, this.TO_STRING);
        this.withSerializer(UUID.class, this.TO_STRING);
        this.withSerializer(URI.class, this.TO_STRING);
        this.withDeserializer(Date.class, val -> new Date(Long.parseLong(val)));
        this.withDeserializer(String.class, val -> val);
        this.withDeserializer(Long.class, Long::parseLong);
        this.withDeserializer(Integer.class, Integer::parseInt);
        this.withDeserializer(UUID.class, UUID::fromString);
        this.withDeserializer(URI.class, URI::create);
    }

    protected <T> SimpleStringValueMapper withSerializer(Class<T> clazz, Serializer<? super T> serializer) {
        this.serializers.put(clazz, serializer);
        return this;
    }

    protected <T> SimpleStringValueMapper withDeserializer(Class<T> clazz, Deserializer<? super T> deserializer) {
        this.deserializers.put(clazz, deserializer);
        return this;
    }

    public boolean supports(Type type) {
        return this.serializers.containsKey(type);
    }

    public <T> String serialize(T id) {
        return this.serializers.getOrDefault(id.getClass(), this.TO_BASE64_STRING).serialize(id);
    }

    public <T> T deserialize(String id, Type type) {
        return (T)this.deserializers.getOrDefault(type, this.FROM_BASE64_STRING).deserialize(id);
    }

    @FunctionalInterface
    protected static interface Deserializer<T> {
        public T deserialize(String var1);
    }

    @FunctionalInterface
    protected static interface Serializer<T> {
        public String serialize(T var1);
    }
}

