/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.gson;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.metadata.strategy.type.DefaultTypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.metadata.strategy.value.gson.GsonFieldNamingStrategy;
import io.leangen.graphql.metadata.strategy.value.gson.GsonValueMapper;
import io.leangen.graphql.metadata.strategy.value.gson.RuntimeTypeAdapterFactory;
import io.leangen.graphql.util.ClassUtils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import net.dongliu.gson.GsonJava8TypeAdapterFactory;

public class GsonValueMapperFactory
implements ValueMapperFactory<GsonValueMapper> {
    private final String basePackage;
    private final FieldNamingStrategy fieldNamingStrategy;
    private final TypeInfoGenerator typeInfoGenerator;
    private final Configurer configurer;
    private final GsonValueMapper defaultValueMapper;

    public GsonValueMapperFactory() {
        this(null);
    }

    public GsonValueMapperFactory(String basePackage) {
        this(basePackage, new DefaultTypeInfoGenerator());
    }

    public GsonValueMapperFactory(String basePackage, TypeInfoGenerator typeInfoGenerator) {
        this(basePackage, typeInfoGenerator, new GsonFieldNamingStrategy(), new AbstractClassAdapterConfigurer());
    }

    public GsonValueMapperFactory(String basePackage, TypeInfoGenerator typeInfoGenerator, FieldNamingStrategy fieldNamingStrategy, Configurer configurer) {
        this.basePackage = basePackage;
        this.fieldNamingStrategy = fieldNamingStrategy;
        this.typeInfoGenerator = typeInfoGenerator;
        this.configurer = configurer;
        this.defaultValueMapper = new GsonValueMapper(this.initBuilder(fieldNamingStrategy, Collections.emptySet(), configurer).create());
    }

    @Override
    public GsonValueMapper getValueMapper(Set<Type> abstractTypes) {
        if (abstractTypes.isEmpty()) {
            return this.defaultValueMapper;
        }
        return new GsonValueMapper(this.initBuilder(this.fieldNamingStrategy, abstractTypes, this.configurer).create());
    }

    private GsonBuilder initBuilder(FieldNamingStrategy fieldNamingStrategy, Set<Type> abstractTypes, Configurer configurer) {
        GsonBuilder gsonBuilder = new GsonBuilder().setFieldNamingStrategy(fieldNamingStrategy).registerTypeAdapterFactory((TypeAdapterFactory)new GsonJava8TypeAdapterFactory());
        return configurer.configure(gsonBuilder, abstractTypes, this.basePackage, this.typeInfoGenerator);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with " + this.typeInfoGenerator.getClass().getSimpleName();
    }

    @FunctionalInterface
    public static interface Configurer {
        public GsonBuilder configure(GsonBuilder var1, Set<Type> var2, String var3, TypeInfoGenerator var4);
    }

    public static class AbstractClassAdapterConfigurer
    implements Configurer {
        @Override
        public GsonBuilder configure(GsonBuilder gsonBuilder, Set<Type> abstractTypes, String basePackage, TypeInfoGenerator infoGenerator) {
            abstractTypes.stream().map(ClassUtils::getRawType).distinct().map(abstractType -> this.adapterFor((Class)abstractType, basePackage, infoGenerator)).forEach(arg_0 -> ((GsonBuilder)gsonBuilder).registerTypeAdapterFactory(arg_0));
            return gsonBuilder;
        }

        private TypeAdapterFactory adapterFor(Class superClass, String basePackage, TypeInfoGenerator infoGen) {
            RuntimeTypeAdapterFactory adapterFactory = RuntimeTypeAdapterFactory.of(superClass, "_type_");
            ClassUtils.findImplementations(superClass, basePackage).stream().filter(impl -> !ClassUtils.isAbstract(impl)).forEach(impl -> adapterFactory.registerSubtype(impl, infoGen.generateTypeName(GenericTypeReflector.annotate((Type)impl))));
            return adapterFactory;
        }
    }
}

