/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.union;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.graphql.annotations.GraphQLUnion;
import io.leangen.graphql.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class Union {
    private String name;
    private String description;
    private List<AnnotatedType> javaTypes;
    private static final String SINGLE_TYPE_UNION_ERROR = "Unions of a single type are not allowed";

    public Union(String name, String description, List<AnnotatedType> javaTypes) {
        this.name = name;
        this.description = description;
    }

    public static AnnotatedType unionize(AnnotatedType[] types) {
        Objects.requireNonNull(types);
        if (types.length < 2) {
            if (types.length == 1 && GenericTypeReflector.isSuperType(Union.class, (Type)types[0].getType())) {
                return types[0];
            }
            throw new IllegalArgumentException(SINGLE_TYPE_UNION_ERROR);
        }
        AnnotatedType t1 = types[0];
        if (Arrays.stream(types).anyMatch(t -> t.isAnnotationPresent(GraphQLUnion.class))) {
            if (Arrays.stream(types).allMatch(t -> t.isAnnotationPresent(GraphQLUnion.class) && t.getAnnotation(GraphQLUnion.class).name().equals(t1.getAnnotation(GraphQLUnion.class).name()))) {
                return Union.of(types);
            }
            throw new IllegalArgumentException("All union members must be explicitly annotated: " + Arrays.toString(types));
        }
        if (Arrays.stream(types).allMatch(t -> t instanceof AnnotatedParameterizedType)) {
            AnnotatedParameterizedType p1 = (AnnotatedParameterizedType)t1;
            AnnotatedParameterizedType[] pTypes = (AnnotatedParameterizedType[])Arrays.stream(types).map(t -> (AnnotatedParameterizedType)t).toArray(AnnotatedParameterizedType[]::new);
            AnnotatedType[] params = new AnnotatedType[p1.getAnnotatedActualTypeArguments().length];
            for (int i = 0; i < p1.getAnnotatedActualTypeArguments().length; ++i) {
                int j = i;
                params[i] = Union.unionize((AnnotatedType[])Arrays.stream(pTypes).map(p -> p.getAnnotatedActualTypeArguments()[j]).toArray(AnnotatedType[]::new));
            }
            Class rawType = (Class)((ParameterizedType)p1.getType()).getRawType();
            return TypeFactory.parameterizedAnnotatedClass((Class)rawType, (Annotation[])ClassUtils.getAllAnnotations(Arrays.stream(types)), (AnnotatedType[])params);
        }
        if (Arrays.stream(types).allMatch(t -> t instanceof AnnotatedArrayType)) {
            AnnotatedType[] components = (AnnotatedType[])Arrays.stream(types).map(type -> ((AnnotatedArrayType)type).getAnnotatedGenericComponentType()).toArray(AnnotatedType[]::new);
            return TypeFactory.arrayOf((AnnotatedType)Union.unionize(components), (Annotation[])ClassUtils.getAllAnnotations(Arrays.stream(types)));
        }
        if (Arrays.stream(types).allMatch(t -> types[0].getType().equals(t.getType()))) {
            return types[0];
        }
        throw new IllegalArgumentException("Types are incompatible and can not be unionized: ");
    }

    public static AnnotatedType of(AnnotatedType[] types) {
        Class<?> union;
        Objects.requireNonNull(types);
        if (types.length < 2) {
            if (types.length == 1 && GenericTypeReflector.isSuperType(Union.class, (Type)types[0].getType())) {
                return types[0];
            }
            throw new IllegalArgumentException(SINGLE_TYPE_UNION_ERROR);
        }
        AnnotatedType[] distinctTypes = Union.dedupe(types);
        try {
            union = ClassUtils.forName(Union.class.getName() + distinctTypes.length);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unions of more than 10 types are not supported");
        }
        Annotation unionAnnotation = Arrays.stream(ClassUtils.getAllAnnotations(Arrays.stream(types))).filter(annotation -> annotation.annotationType().equals(GraphQLUnion.class)).filter(annotation -> !((GraphQLUnion)annotation).description().isEmpty()).findFirst().orElse(types[0].getAnnotation(GraphQLUnion.class));
        return TypeFactory.parameterizedAnnotatedClass(union, (Annotation[])new Annotation[]{unionAnnotation}, (AnnotatedType[])distinctTypes);
    }

    private static AnnotatedType[] dedupe(AnnotatedType ... types) {
        return (AnnotatedType[])Arrays.stream(types).collect(Collectors.groupingBy(AnnotatedType::getType)).values().stream().map(typeGroup -> GenericTypeReflector.updateAnnotations((AnnotatedType)((AnnotatedType)typeGroup.get(0)), (Annotation[])ClassUtils.getAllAnnotations(typeGroup.stream()))).toArray(AnnotatedType[]::new);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<AnnotatedType> getJavaTypes() {
        return this.javaTypes;
    }
}

