/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import io.leangen.graphql.generator.OperationSource;
import io.leangen.graphql.generator.OperationSourceRepository;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.strategy.query.OperationBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OperationRepository {
    private final Set<Operation> queries;
    private final Set<Operation> mutations;
    private final OperationSourceRepository operationSourceRepository;
    private final OperationBuilder operationBuilder;

    public OperationRepository(OperationSourceRepository operationSourceRepository, OperationBuilder operationBuilder) {
        this.operationSourceRepository = operationSourceRepository;
        this.operationBuilder = operationBuilder;
        List<Resolver> resolvers = this.buildQueryResolvers(operationSourceRepository.getOperationSources());
        List<Resolver> mutationResolvers = this.buildMutationResolvers(operationSourceRepository.getOperationSources());
        this.queries = this.buildQueries(resolvers);
        this.mutations = this.buildMutations(mutationResolvers);
    }

    private Set<Operation> buildQueries(List<Resolver> resolvers) {
        return resolvers.stream().collect(Collectors.groupingBy(Resolver::getOperationName)).values().stream().flatMap(r -> this.collectContextTypes((Collection<Resolver>)r).stream().map(contextType -> this.resolversPerContext((Type)contextType, (List<Resolver>)r)).filter(contextual -> !((List)contextual.getValue()).isEmpty()).map(contextual -> this.operationBuilder.buildQuery((Type)contextual.getKey(), (List)contextual.getValue()))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<Operation> buildMutations(List<Resolver> resolvers) {
        return resolvers.stream().collect(Collectors.groupingBy(Resolver::getOperationName)).values().stream().flatMap(r -> this.collectContextTypes((Collection<Resolver>)r).stream().map(contextType -> this.resolversPerContext((Type)contextType, (List<Resolver>)r)).filter(contextual -> !((List)contextual.getValue()).isEmpty()).map(contextual -> this.operationBuilder.buildMutation((Type)contextual.getKey(), (List)contextual.getValue()))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Map.Entry<Type, List<Resolver>> resolversPerContext(Type context, List<Resolver> resolvers) {
        List contextual = context == null ? resolvers.stream().filter(r -> r.getSourceTypes().isEmpty()).collect(Collectors.toList()) : resolvers.stream().filter(r -> r.getSourceTypes().contains(context)).collect(Collectors.toList());
        return new AbstractMap.SimpleEntry<Type, List<Resolver>>(context, contextual);
    }

    private List<Type> collectContextTypes(Collection<Resolver> resolvers) {
        List<Type> contextTypes = resolvers.stream().flatMap(r -> r.getSourceTypes().stream()).distinct().collect(Collectors.toList());
        contextTypes.add(null);
        return contextTypes;
    }

    private Collection<Operation> getAllQueries() {
        return this.queries;
    }

    public Collection<Operation> getRootQueries() {
        return this.queries.stream().filter(Operation::isRoot).collect(Collectors.toList());
    }

    public Collection<Operation> getMutations() {
        return this.mutations;
    }

    public Set<Operation> getNestedQueries(AnnotatedType domainType) {
        OperationSource domainSource = this.operationSourceRepository.nestedSourceForType(domainType);
        return this.buildNestedQueries(domainSource);
    }

    public Collection<Operation> getChildQueries(AnnotatedType domainType) {
        HashMap children = new HashMap();
        Map nestedQueries = this.getNestedQueries(domainType).stream().collect(Collectors.toMap(Operation::getName, Function.identity()));
        Map embeddableQueries = this.getEmbeddableQueries(domainType.getType()).stream().collect(Collectors.toMap(Operation::getName, Function.identity()));
        children.putAll(nestedQueries);
        children.putAll(embeddableQueries);
        return children.values();
    }

    public Set<Operation> getEmbeddableQueries(Type domainType) {
        return this.getAllQueries().stream().map(Operation::unbatch).filter(query -> query.isEmbeddableForType(domainType)).collect(Collectors.toSet());
    }

    private Set<Operation> buildNestedQueries(OperationSource operationSource) {
        return this.buildQueries(this.buildQueryResolvers(Collections.singleton(operationSource)));
    }

    private List<Resolver> buildQueryResolvers(Collection<OperationSource> operationSources) {
        return this.buildResolvers(operationSources, (operationSource, builder) -> builder.buildQueryResolvers(operationSource.getServiceSingleton(), operationSource.getJavaType()));
    }

    private List<Resolver> buildMutationResolvers(Collection<OperationSource> operationSources) {
        return this.buildResolvers(operationSources, (operationSource, builder) -> builder.buildMutationResolvers(operationSource.getServiceSingleton(), operationSource.getJavaType()));
    }

    private List<Resolver> buildResolvers(Collection<OperationSource> operationSources, BiFunction<OperationSource, ResolverBuilder, Collection<Resolver>> building) {
        return operationSources.stream().flatMap(operationSource -> operationSource.getResolverBuilders().stream().flatMap(builder -> ((Collection)building.apply((OperationSource)operationSource, (ResolverBuilder)builder)).stream()).distinct()).collect(Collectors.toList());
    }
}

