/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution.complexity;

import graphql.execution.ConditionalNodes;
import graphql.execution.ExecutionContext;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.TypeFromAST;
import graphql.execution.ValuesResolver;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import io.leangen.graphql.execution.complexity.ComplexityFunction;
import io.leangen.graphql.execution.complexity.ComplexityLimitExceededException;
import io.leangen.graphql.execution.complexity.ResolvedField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ComplexityAnalyzer {
    private final ConditionalNodes conditionalNodes = new ConditionalNodes();
    private final ComplexityFunction complexityFunction;
    private final int maximumComplexity;
    private static final ValuesResolver valuesResolver = new ValuesResolver();

    ComplexityAnalyzer(ComplexityFunction complexityFunction, int maximumComplexity) {
        this.complexityFunction = complexityFunction;
        this.maximumComplexity = maximumComplexity;
    }

    ResolvedField collectFields(ExecutionContext context) {
        FieldCollectorParameters parameters = FieldCollectorParameters.newParameters((GraphQLSchema)context.getGraphQLSchema(), (GraphQLObjectType)context.getGraphQLSchema().getQueryType()).fragments(context.getFragmentsByName()).variables(context.getVariables()).build();
        List fields = context.getOperationDefinition().getSelectionSet().getSelections().stream().map(selection -> (Field)selection).collect(Collectors.toList());
        Field field = (Field)fields.get(0);
        GraphQLFieldDefinition fieldDefinition = context.getGraphQLSchema().getQueryType().getFieldDefinition(field.getName());
        Map argumentValues = valuesResolver.getArgumentValues(fieldDefinition.getArguments(), field.getArguments(), context.getVariables());
        return this.collectFields(parameters, fields.stream().map(f -> new ResolvedField((Field)f, fieldDefinition, argumentValues)).collect(Collectors.toList()));
    }

    private Map<String, ResolvedField> collectFields(FieldCollectorParameters parameters, List<Field> fields, GraphQLFieldsContainer parent) {
        ArrayList visitedFragments = new ArrayList();
        LinkedHashMap<String, List<ResolvedField>> unconditionalSubFields = new LinkedHashMap<String, List<ResolvedField>>();
        LinkedHashMap<String, Map<String, List<ResolvedField>>> conditionalSubFields = new LinkedHashMap<String, Map<String, List<ResolvedField>>>();
        fields.stream().filter(field -> field.getSelectionSet() != null).forEach(field -> this.collectFields(parameters, unconditionalSubFields, this.getUnconditionalSelections(field.getSelectionSet()), visitedFragments, parent));
        fields.stream().filter(field -> field.getSelectionSet() != null).forEach(field -> this.getConditionalSelections(field.getSelectionSet()).forEach((condition, selections) -> {
            LinkedHashMap<String, List<ResolvedField>> subFields = new LinkedHashMap<String, List<ResolvedField>>();
            this.collectFields(parameters, (Map<String, List<ResolvedField>>)subFields, (List<Selection>)selections, visitedFragments, parent);
            conditionalSubFields.put((String)condition, (Map<String, List<ResolvedField>>)subFields);
        }));
        if (conditionalSubFields.isEmpty()) {
            return unconditionalSubFields.values().stream().map(nodes -> this.collectFields(parameters, (List<ResolvedField>)nodes)).collect(Collectors.toMap(ResolvedField::getName, Function.identity()));
        }
        return this.reduceAlternatives(parameters, unconditionalSubFields, conditionalSubFields);
    }

    private ResolvedField collectFields(FieldCollectorParameters parameters, List<ResolvedField> fields) {
        int childScore;
        ResolvedField field = fields.get(0);
        if (!fields.stream().allMatch(f -> f.getFieldType() instanceof GraphQLFieldsContainer)) {
            field.setComplexityScore(this.complexityFunction.getComplexity(field, 0));
            return field;
        }
        List<Field> rawFields = fields.stream().map(ResolvedField::getField).collect(Collectors.toList());
        Map<String, ResolvedField> children = this.collectFields(parameters, rawFields, (GraphQLFieldsContainer)field.getFieldType());
        ResolvedField node = new ResolvedField(field.getField(), field.getFieldDefinition(), field.getArguments(), children);
        int complexityScore = this.complexityFunction.getComplexity(node, childScore = children.values().stream().mapToInt(ResolvedField::getComplexityScore).sum());
        if (complexityScore > this.maximumComplexity) {
            throw new ComplexityLimitExceededException(complexityScore, this.maximumComplexity);
        }
        node.setComplexityScore(complexityScore);
        return node;
    }

    private void collectFields(FieldCollectorParameters parameters, Map<String, List<ResolvedField>> fields, List<Selection> selectionSet, List<String> visitedFragments, GraphQLFieldsContainer parent) {
        for (Selection selection : selectionSet) {
            if (selection instanceof Field) {
                this.collectField(parameters, fields, (Field)selection, parent);
                continue;
            }
            if (selection instanceof InlineFragment) {
                this.collectInlineFragment(parameters, fields, visitedFragments, (InlineFragment)selection, parent);
                continue;
            }
            if (!(selection instanceof FragmentSpread)) continue;
            this.collectFragmentSpread(parameters, fields, visitedFragments, (FragmentSpread)selection, parent);
        }
    }

    private void collectFragmentSpread(FieldCollectorParameters parameters, Map<String, List<ResolvedField>> fields, List<String> visitedFragments, FragmentSpread fragmentSpread, GraphQLFieldsContainer parent) {
        if (visitedFragments.contains(fragmentSpread.getName())) {
            return;
        }
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), fragmentSpread.getDirectives())) {
            return;
        }
        visitedFragments.add(fragmentSpread.getName());
        FragmentDefinition fragmentDefinition = (FragmentDefinition)parameters.getFragmentsByName().get(fragmentSpread.getName());
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), fragmentDefinition.getDirectives())) {
            return;
        }
        if (fragmentDefinition.getTypeCondition() != null) {
            parent = (GraphQLFieldsContainer)TypeFromAST.getTypeFromAST((GraphQLSchema)parameters.getGraphQLSchema(), (Type)fragmentDefinition.getTypeCondition());
        }
        this.collectFields(parameters, fields, fragmentDefinition.getSelectionSet().getSelections(), visitedFragments, parent);
    }

    private void collectInlineFragment(FieldCollectorParameters parameters, Map<String, List<ResolvedField>> fields, List<String> visitedFragments, InlineFragment inlineFragment, GraphQLFieldsContainer parent) {
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), inlineFragment.getDirectives())) {
            return;
        }
        if (inlineFragment.getTypeCondition() != null) {
            parent = (GraphQLFieldsContainer)TypeFromAST.getTypeFromAST((GraphQLSchema)parameters.getGraphQLSchema(), (Type)inlineFragment.getTypeCondition());
        }
        this.collectFields(parameters, fields, inlineFragment.getSelectionSet().getSelections(), visitedFragments, parent);
    }

    private void collectField(FieldCollectorParameters parameters, Map<String, List<ResolvedField>> fields, Field field, GraphQLFieldsContainer parent) {
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), field.getDirectives())) {
            return;
        }
        GraphQLFieldDefinition fieldDefinition = parent.getFieldDefinition(field.getName());
        Map argumentValues = valuesResolver.getArgumentValues(fieldDefinition.getArguments(), field.getArguments(), parameters.getVariables());
        ResolvedField node = new ResolvedField(field, fieldDefinition, argumentValues);
        fields.putIfAbsent(node.getName(), new ArrayList());
        fields.get(node.getName()).add(node);
    }

    protected Map<String, ResolvedField> reduceAlternatives(FieldCollectorParameters parameters, Map<String, List<ResolvedField>> unconditionalSubFields, Map<String, Map<String, List<ResolvedField>>> conditionalSubFields) {
        Map reduced = null;
        for (Map.Entry<String, Map<String, List<ResolvedField>>> conditional : conditionalSubFields.entrySet()) {
            int maxScore;
            HashMap<String, List<ResolvedField>> merged = new HashMap<String, List<ResolvedField>>(conditional.getValue());
            for (Map.Entry<String, List<ResolvedField>> unconditional : unconditionalSubFields.entrySet()) {
                merged.merge(unconditional.getKey(), unconditional.getValue(), (condNodes, uncondNodes) -> Stream.concat(condNodes.stream(), uncondNodes.stream()).collect(Collectors.toList()));
            }
            Map flat = merged.values().stream().map(nodes -> this.collectFields(parameters, (List<ResolvedField>)nodes)).collect(Collectors.toMap(ResolvedField::getName, Function.identity()));
            if (reduced == null) {
                reduced = flat;
                continue;
            }
            int currentScore = flat.values().stream().mapToInt(ResolvedField::getComplexityScore).sum();
            if (currentScore <= (maxScore = reduced.values().stream().mapToInt(ResolvedField::getComplexityScore).sum())) continue;
            reduced = flat;
        }
        return reduced;
    }

    private List<Selection> getUnconditionalSelections(SelectionSet selectionSet) {
        return selectionSet.getSelections().stream().filter(selection -> !this.isConditional((Selection)selection)).collect(Collectors.toList());
    }

    private Map<String, List<Selection>> getConditionalSelections(SelectionSet selectionSet) {
        return selectionSet.getSelections().stream().filter(this::isConditional).collect(Collectors.groupingBy(s -> s instanceof FragmentDefinition ? ((FragmentDefinition)s).getTypeCondition().getName() : ((InlineFragment)s).getTypeCondition().getName()));
    }

    private boolean isConditional(Selection selection) {
        return selection instanceof FragmentDefinition && ((FragmentDefinition)selection).getTypeCondition() != null || selection instanceof InlineFragment && ((InlineFragment)selection).getTypeCondition() != null;
    }
}

