/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql;

import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.DataFetchParameters;
import graphql.execution.instrumentation.parameters.ExecutionParameters;
import graphql.execution.instrumentation.parameters.FieldFetchParameters;
import graphql.execution.instrumentation.parameters.FieldParameters;
import graphql.execution.instrumentation.parameters.ValidationParameters;
import graphql.language.Document;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import io.leangen.graphql.execution.ContextWrapper;
import io.leangen.graphql.execution.complexity.ComplexityAnalysisInstrumentation;
import io.leangen.graphql.execution.complexity.JavaScriptEvaluator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GraphQLRuntime
extends GraphQL {
    private final GraphQL delegate;

    private GraphQLRuntime(GraphQL delegate, GraphQLSchema schema) {
        super(schema);
        this.delegate = delegate;
    }

    public ExecutionResult execute(String requestString, String operationName, Object context, Map<String, Object> arguments) {
        return this.delegate.execute(requestString, operationName, (Object)new ContextWrapper(context), arguments);
    }

    public static Builder newGraphQL(GraphQLSchema graphQLSchema) {
        return new Builder(graphQLSchema);
    }

    public static class InstrumentationContextChain<T>
    implements InstrumentationContext<T> {
        private final List<InstrumentationContext<T>> contexts;

        InstrumentationContextChain(List<InstrumentationContext<T>> contexts) {
            this.contexts = Collections.unmodifiableList(contexts);
        }

        public void onEnd(T result) {
            this.contexts.forEach(context -> context.onEnd(result));
        }

        public void onEnd(Exception e) {
            this.contexts.forEach(context -> context.onEnd(e));
        }
    }

    public static class InstrumentationChain
    implements Instrumentation {
        private final List<Instrumentation> instrumentations;

        public InstrumentationChain(List<Instrumentation> instrumentations) {
            this.instrumentations = Collections.unmodifiableList(instrumentations);
        }

        public InstrumentationContext<ExecutionResult> beginExecution(ExecutionParameters parameters) {
            return new InstrumentationContextChain<ExecutionResult>(this.instrumentations.stream().map(instrumentation -> instrumentation.beginExecution(parameters)).collect(Collectors.toList()));
        }

        public InstrumentationContext<Document> beginParse(ExecutionParameters parameters) {
            return new InstrumentationContextChain<Document>(this.instrumentations.stream().map(instrumentation -> instrumentation.beginParse(parameters)).collect(Collectors.toList()));
        }

        public InstrumentationContext<List<ValidationError>> beginValidation(ValidationParameters parameters) {
            return new InstrumentationContextChain<List<ValidationError>>(this.instrumentations.stream().map(instrumentation -> instrumentation.beginValidation(parameters)).collect(Collectors.toList()));
        }

        public InstrumentationContext<ExecutionResult> beginDataFetch(DataFetchParameters parameters) {
            return new InstrumentationContextChain<ExecutionResult>(this.instrumentations.stream().map(instrumentation -> instrumentation.beginDataFetch(parameters)).collect(Collectors.toList()));
        }

        public InstrumentationContext<ExecutionResult> beginField(FieldParameters parameters) {
            return new InstrumentationContextChain<ExecutionResult>(this.instrumentations.stream().map(instrumentation -> instrumentation.beginField(parameters)).collect(Collectors.toList()));
        }

        public InstrumentationContext<Object> beginFieldFetch(FieldFetchParameters parameters) {
            return new InstrumentationContextChain<Object>(this.instrumentations.stream().map(instrumentation -> instrumentation.beginFieldFetch(parameters)).collect(Collectors.toList()));
        }
    }

    public static class Builder
    extends GraphQL.Builder {
        private GraphQLSchema graphQLSchema;
        private List<Instrumentation> instrumentations;

        private Builder(GraphQLSchema graphQLSchema) {
            super(graphQLSchema);
            this.graphQLSchema = graphQLSchema;
            this.instrumentations = new ArrayList<Instrumentation>();
        }

        public Builder instrumentation(Instrumentation instrumentation) {
            this.instrumentations.add(instrumentation);
            return this;
        }

        public Builder maximumQueryComplexity(int limit) {
            this.instrumentations.add(new ComplexityAnalysisInstrumentation(new JavaScriptEvaluator(), limit));
            return this;
        }

        public GraphQLRuntime build() {
            if (this.instrumentations.size() == 1) {
                super.instrumentation(this.instrumentations.get(0));
            } else if (!this.instrumentations.isEmpty()) {
                super.instrumentation((Instrumentation)new InstrumentationChain(this.instrumentations));
            }
            return new GraphQLRuntime(super.build(), this.graphQLSchema);
        }
    }
}

