/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeapitest.process;

import io.fabric8.kubeapitest.KubeAPIServerConfig;
import io.fabric8.kubeapitest.KubeAPITestException;
import io.fabric8.kubeapitest.binary.BinaryManager;
import io.fabric8.kubeapitest.cert.CertManager;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessReadinessChecker {
    private static final Logger log = LoggerFactory.getLogger(ProcessReadinessChecker.class);
    public static final int POLLING_INTERVAL = 200;

    public void waitUntilDefaultNamespaceAvailable(int apiServerPort, BinaryManager binaryManager, CertManager certManager, KubeAPIServerConfig config, int timeoutMillis) {
        ProcessReadinessChecker.pollWithTimeout(() -> this.defaultNamespaceExists(apiServerPort, binaryManager, certManager, config), "Kube API Server", timeoutMillis);
    }

    private boolean defaultNamespaceExists(int apiServerPort, BinaryManager binaryManager, CertManager certManager, KubeAPIServerConfig config) {
        try {
            Process process;
            ProcessBuilder processBuilder = new ProcessBuilder(binaryManager.binaries().getKubectl().getPath(), "--client-certificate=" + certManager.getClientCertPath(), "--client-key=" + certManager.getClientKeyPath(), "--certificate-authority=" + certManager.getAPIServerCertPath(), "--server=https://127.0.0.1:" + apiServerPort, "--request-timeout=5s", "get", "ns", "default");
            if (!config.isUpdateKubeConfig()) {
                Map<String, String> env = processBuilder.environment();
                env.put("KUBECONFIG", config.getKubeAPITestDir() + "/.kubeconfig");
            }
            return (process = processBuilder.start()).waitFor() == 0;
        }
        catch (IOException e) {
            throw new KubeAPITestException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KubeAPITestException(e);
        }
    }

    public void waitUntilReady(int port, String readyCheckPath, String processName, boolean useTLS, int timeoutMillis) {
        HttpClient client = ProcessReadinessChecker.getHttpClient();
        HttpRequest request = this.getHttpRequest(useTLS, readyCheckPath, port);
        ProcessReadinessChecker.pollWithTimeout(() -> this.ready(client, request, processName, port), processName, timeoutMillis);
    }

    private static void pollWithTimeout(BooleanSupplier predicate, String processName, int timeoutMillis) {
        try {
            LocalTime startedAt = LocalTime.now();
            while (true) {
                if (predicate.getAsBoolean()) {
                    return;
                }
                if (LocalTime.now().isAfter(startedAt.plus(timeoutMillis, ChronoUnit.MILLIS))) {
                    throw new KubeAPITestException(processName + " did not start properly");
                }
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KubeAPITestException(e);
        }
    }

    private boolean ready(HttpClient client, HttpRequest request, String processName, int port) {
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            log.debug("Ready Response message:{} code: {} for {} on Port: {}", new Object[]{response.body(), response.statusCode(), processName, port});
            return response.statusCode() == 200;
        }
        catch (ConnectException | SSLException e) {
            log.debug("Cannot connect to the server", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            throw new KubeAPITestException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KubeAPITestException(e);
        }
    }

    private HttpRequest getHttpRequest(boolean useTLS, String readyCheckPath, int port) {
        try {
            return HttpRequest.newBuilder().uri(new URI((useTLS ? "https" : "http") + "://127.0.0.1:" + port + "/" + readyCheckPath)).GET().build();
        }
        catch (URISyntaxException e) {
            throw new KubeAPITestException(e);
        }
    }

    private static HttpClient getHttpClient() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new X509ExtendedTrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] a_certificates, String a_auth_type) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] a_certificates, String a_auth_type) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] a_certificates, String a_auth_type, Socket a_socket) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] a_certificates, String a_auth_type, SSLEngine a_engine) {
                }
            }}, null);
            return HttpClient.newBuilder().sslContext(sslContext).version(HttpClient.Version.HTTP_1_1).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new KubeAPITestException(e);
        }
    }
}

