/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.grid.ColumnPathRenderer;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentFocusable;
import org.vaadin.firitin.fluency.ui.FluentHasSize;
import org.vaadin.firitin.fluency.ui.FluentHasStyle;
import org.vaadin.firitin.fluency.ui.FluentHasTheme;
import org.vaadin.firitin.util.VStyleUtil;
import tools.jackson.core.util.Named;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.BasicBeanDescription;
import tools.jackson.databind.introspect.BeanPropertyDefinition;

public class VGrid<T>
extends Grid<T>
implements FluentComponent<VGrid<T>>,
FluentHasStyle<VGrid<T>>,
FluentHasSize<VGrid<T>>,
FluentFocusable<Grid<T>, VGrid<T>>,
FluentHasTheme<VGrid<T>> {
    private static ObjectMapper dummyOm;
    private BasicBeanDescription bbd;
    private Set<String> columnCssKeys;
    private Set<String> rowCssKeys;
    private CellFormatter<T> cellFormatter;

    public VGrid() {
    }

    public VGrid(int pageSize) {
        super(pageSize);
    }

    public VGrid(Class<T> beanType) {
        this(beanType, true);
    }

    public VGrid(Class<T> beanType, boolean autoCreateColumns) {
        super(beanType, false);
        if (dummyOm == null) {
            dummyOm = new ObjectMapper();
        }
        JavaType javaType = dummyOm.getTypeFactory().constructType(beanType);
        this.bbd = (BasicBeanDescription)dummyOm._deserializationContext().introspectBeanDescription(javaType);
        if (autoCreateColumns) {
            List<String> propertyNames = this.getBeanPropertyNames();
            this.setColumns(propertyNames.toArray(new String[0]));
        }
    }

    protected List<BeanPropertyDefinition> getBeanPropertyDefinitions() {
        return this.bbd.findProperties();
    }

    protected List<String> getBeanPropertyNames() {
        return this.getBeanPropertyDefinitions().stream().map(Named::getName).toList();
    }

    public void focus() {
        this.getElement().executeJs("    setTimeout(function() {\n        $0.shadowRoot.querySelector(\"tr\").focus();\n    }, 100);\n", new Object[0]);
    }

    protected BiFunction<Renderer<T>, String, Grid.Column<T>> getDefaultColumnFactory() {
        return (tRenderer, s) -> new VColumn(this, (String)s, tRenderer);
    }

    public VGrid<T> withSelectionMode(Grid.SelectionMode selectionMode) {
        this.setSelectionMode(selectionMode);
        return this;
    }

    public VGrid<T> withSelectionModel(GridSelectionModel<T> selectionModel, Grid.SelectionMode selectionMode) {
        this.setSelectionModel(selectionModel, selectionMode);
        return this;
    }

    public VGrid<T> withProperties(String ... propertyNames) {
        this.setColumns(propertyNames);
        return this;
    }

    public VGrid<T> hideProperties(String ... propertyNamesToHide) {
        ArrayList<String> properties = new ArrayList<String>(this.getColumns().stream().map(col -> col.getKey()).toList());
        for (String pToHide : propertyNamesToHide) {
            properties.remove(pToHide);
        }
        this.setColumns(properties.toArray(new String[properties.size()]));
        ((Grid.Column)this.getColumns().get(1)).setVisible(false);
        return this;
    }

    public void setColumns(String ... propertyNames) {
        if (this.getBeanType().isRecord()) {
            this.removeAllColumns();
            RecordComponent[] recordComponents = this.getBeanType().getRecordComponents();
            for (String p : propertyNames) {
                for (RecordComponent r : recordComponents) {
                    String name = r.getName();
                    if (!name.equals(p)) continue;
                    this.addRecordColumn(r, name);
                }
            }
        } else {
            super.setColumns(propertyNames);
        }
    }

    public Grid.Column<T> addColumn(String propertyName) {
        try {
            return super.addColumn(propertyName);
        }
        catch (IllegalArgumentException exception) {
            if (this.bbd != null) {
                BeanPropertyDefinition d = this.bbd.findProperties().stream().filter(p -> p.getName().equals(propertyName)).findFirst().get();
                AnnotatedMethod getter = d.getGetter();
                Grid.Column col = this.addColumn((ValueProvider & Serializable)i -> {
                    try {
                        if (getter == null) {
                            return d.getAccessor().getValue(i);
                        }
                        return getter.callOn(i);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                try {
                    col.setKey(propertyName);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Multiple columns for the same property: " + propertyName);
                }
                if (Comparable.class.isAssignableFrom(d.getPrimaryType().getRawClass())) {
                    col.setSortable(true);
                }
                col.setHeader(SharedUtil.capitalize((String)propertyName));
                return col;
            }
            throw exception;
        }
    }

    private void addRecordColumn(RecordComponent r, String name) {
        this.addColumn((ValueProvider & Serializable)v -> {
            try {
                r.getAccessor().setAccessible(true);
                return r.getAccessor().invoke(v, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).setKey(name).setHeader(SharedUtil.capitalize((String)name));
    }

    public VGrid<T> withThemeVariants(GridVariant ... variants) {
        this.addThemeVariants(variants);
        return this;
    }

    public VGrid<T> setDataProvider(CallbackDataProvider.FetchCallback<T, Void> fetchCallback, CallbackDataProvider.CountCallback<T, Void> countCallback) {
        this.setDataProvider((DataProvider)DataProvider.fromCallbacks(fetchCallback, countCallback));
        return this;
    }

    public VGrid<T> withItems(Collection<T> items) {
        this.setItems(items);
        return this;
    }

    public VGrid<T> withItems(T ... items) {
        this.setItems(items);
        return this;
    }

    @Deprecated
    public void scrollToItem(T item) {
        Stream items;
        try {
            items = this.getListDataView().getItems();
        }
        catch (IllegalStateException exception) {
            items = this.getGenericDataView().getItems();
        }
        AtomicInteger i = new AtomicInteger();
        int index = items.peek(v -> i.incrementAndGet()).anyMatch(itm -> itm.equals(item)) ? i.get() - 1 : -1;
        this.scrollToIndex(index);
    }

    public VGrid<T> withColumnSelector() {
        ContextMenu columnSelector = new ContextMenu();
        List columns = this.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Grid.Column col = (Grid.Column)columns.get(i);
            Object headerText = col.getHeaderText();
            if (headerText == null) {
                headerText = col.getKey();
            }
            if (headerText == null) {
                headerText = "Column " + i;
            }
            MenuItem item = (MenuItem)columnSelector.addItem((String)headerText);
            item.setCheckable(true);
            item.setChecked(col.isVisible());
            item.addClickListener((ComponentEventListener & Serializable)e -> {
                col.setVisible(!col.isVisible());
                item.setChecked(col.isVisible());
            });
        }
        Button b = new Button((Component)VaadinIcon.CHEVRON_CIRCLE_DOWN_O.create()){
            {
                this.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
                this.getStyle().setPosition(Style.Position.ABSOLUTE).setRight("0").setMinWidth("1em").setMarginRight("0").setMarginTop("0.5em").setPadding("0");
                this.getElement().executeJs("const el = this;\nconst gridel = $0;\ngridel.shadowRoot.getElementById(\"scroller\").appendChild(el);\n", new Object[]{VGrid.this.getElement()});
            }
        };
        this.getElement().appendVirtualChild(new Element[]{b.getElement()});
        columnSelector.setTarget((Component)b);
        columnSelector.setOpenOnClick(true);
        return this;
    }

    private VColumn<T> colById(String columnId) {
        try {
            Field field = Grid.class.getDeclaredField("idToColumnMap");
            field.setAccessible(true);
            Map idToColumnMap = (Map)field.get(this);
            return (VColumn)((Object)idToColumnMap.get(columnId));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected <C extends Grid.Column<T>> C addColumn(ValueProvider<T, ?> valueProvider, BiFunction<Renderer<T>, String, C> columnFactory) {
        String columnId = this.createColumnId(false);
        Grid.Column column = this.addColumn((Renderer)new ColumnPathRenderer(columnId, (ValueProvider & Serializable)item -> this.formatColumnValue(this.colById(columnId), this.applyValueProvider(valueProvider, item))), columnFactory);
        try {
            Field field = Grid.Column.class.getDeclaredField("comparator");
            field.setAccessible(true);
            SerializableComparator & Serializable c = (SerializableComparator & Serializable)(a, b) -> VGrid.compareMaybeComparables((Object)this.applyValueProvider(valueProvider, a), (Object)this.applyValueProvider(valueProvider, b));
            field.set(column, c);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return (C)column;
    }

    private Object applyValueProvider(ValueProvider<T, ?> valueProvider, T item) {
        Object value;
        block2: {
            try {
                value = valueProvider.apply(item);
            }
            catch (NullPointerException npe) {
                value = null;
                if (Grid.NestedNullBehavior.THROW != this.getNestedNullBehavior()) break block2;
                throw npe;
            }
        }
        return value;
    }

    private String formatColumnValue(VColumn<T> col, Object value) {
        if (this.cellFormatter != null) {
            return this.cellFormatter.formatColumnValue(col, value);
        }
        try {
            return CellFormatter.defaultVaadinFormatting(value);
        }
        catch (Exception e) {
            if (value == null) {
                return "null";
            }
            return value.getClass().getSimpleName();
        }
    }

    public VGrid<T> withCellFormatter(CellFormatter<T> formatter) {
        this.cellFormatter = formatter;
        return this;
    }

    public VGrid<T> withRowStyler(RowStyler<T> rowStyler) {
        SerializableFunction oldCNG = this.getPartNameGenerator();
        this.setPartNameGenerator((SerializableFunction)(ValueProvider & Serializable)t -> {
            String oldNames;
            boolean newRule;
            final TreeMap<String, String> styleRules = new TreeMap<String, String>();
            Style style = new Style(){
                final /* synthetic */ VGrid this$0;
                {
                    this.this$0 = this$0;
                }

                public String get(String name) {
                    return (String)styleRules.get(name);
                }

                public Style set(String name, String value) {
                    styleRules.put(name, value);
                    return this;
                }

                public Style remove(String name) {
                    styleRules.remove(name);
                    return this;
                }

                public Style clear() {
                    styleRules.clear();
                    return this;
                }

                public boolean has(String name) {
                    return styleRules.containsKey(name);
                }

                public Stream<String> getNames() {
                    return styleRules.keySet().stream();
                }
            };
            rowStyler.styleRow(t, style);
            if (styleRules.isEmpty()) {
                return oldCNG != null ? (String)oldCNG.apply(t) : null;
            }
            StringBuilder cellCssBody = new StringBuilder();
            styleRules.forEach((k, v) -> cellCssBody.append("%s: %s;".formatted(k, v)));
            String cellCssBodyString = cellCssBody.toString();
            String key = "dynstyle" + cellCssBodyString.hashCode() + "-rc";
            if (this.rowCssKeys == null) {
                this.rowCssKeys = new HashSet<String>();
            }
            if (newRule = this.rowCssKeys.add(key)) {
                VStyleUtil.inject("vaadin-grid::part(%s) {\n    %s\n}\n".formatted(key, cellCssBodyString));
            }
            if (oldCNG != null && (oldNames = (String)oldCNG.apply(t)) != null) {
                return oldNames + " " + key;
            }
            return key;
        });
        return this;
    }

    public static class VColumn<T>
    extends Grid.Column<T> {
        private Style customStyle;

        public VColumn(Grid<T> grid, String columnId, Renderer<T> renderer) {
            super(grid, columnId, renderer);
        }

        public Style getStyle() {
            if (this.customStyle != null) {
                return this.customStyle;
            }
            final int indexOfColumn = this.getGrid().getColumns().indexOf((Object)this);
            this.customStyle = new Style(){
                private static final String[] harmfulAsDuplicate = new String[]{"border", "outline", "padding", "margin", "zoom"};
                private TreeMap<String, String> styles = new TreeMap();
                private boolean deferred;
                final /* synthetic */ VColumn this$0;
                {
                    this.this$0 = this$0;
                }

                public String get(String s) {
                    return null;
                }

                public Style set(String s, String s1) {
                    this.styles.put(s, s1);
                    this.deferredApply();
                    return this;
                }

                private void deferredApply() {
                    if (!this.deferred) {
                        this.this$0.getGrid().getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> this.doApply());
                        this.deferred = true;
                    }
                }

                private void doApply() {
                    boolean newRule;
                    StringBuilder cellCssBody = new StringBuilder();
                    StringBuilder headerContentCssBody = new StringBuilder();
                    this.styles.forEach((k, v) -> {
                        cellCssBody.append("%s: %s;".formatted(k, v));
                        if (Arrays.stream(harmfulAsDuplicate).noneMatch(k::contains)) {
                            headerContentCssBody.append("%s: %s;".formatted(k, v));
                        }
                    });
                    String cellCssBodyString = cellCssBody.toString();
                    String key = "dynstyle" + cellCssBodyString.hashCode();
                    String headerText = this.this$0.getHeaderText();
                    if (headerText != null) {
                        this.this$0.setHeader((Component)new Span(headerText));
                    }
                    if (this.this$0.getHeaderComponent() != null) {
                        this.this$0.getHeaderComponent().addClassName(key + "-hc");
                    }
                    this.this$0.setPartNameGenerator((SerializableFunction & Serializable)p -> key);
                    this.this$0.getGrid().getElement().executeJs("const g = this; setTimeout(() => {g.shadowRoot.querySelector('th:nth-child(" + (indexOfColumn + 1) + ")').part.add('" + key + "');}, 1);", new Object[0]);
                    VGrid grid = (VGrid)this.this$0.findAncestor(VGrid.class);
                    if (grid.columnCssKeys == null) {
                        grid.columnCssKeys = new HashSet<String>();
                    }
                    if (newRule = grid.columnCssKeys.add(key)) {
                        VStyleUtil.inject("vaadin-grid::part(%s) {\n    %s\n}\n.%s-hc {\n    %s\n}\n".formatted(key, cellCssBodyString, key, headerContentCssBody.toString()));
                    }
                }

                public Style remove(String s) {
                    this.styles.remove(s);
                    return this;
                }

                public Style clear() {
                    this.this$0.customStyle.clear();
                    return this;
                }

                public boolean has(String s) {
                    return this.this$0.customStyle.has(s);
                }

                public Stream<String> getNames() {
                    return this.this$0.customStyle.getNames();
                }
            };
            return this.customStyle;
        }
    }

    public static interface CellFormatter<T> {
        public static String defaultVaadinFormatting(Object value) {
            if (value == null) {
                return "";
            }
            Object string = String.valueOf(value);
            if (value.getClass().isRecord() && ((String)string).startsWith(value.getClass().getSimpleName()) && ((String)(string = ((String)string).substring(value.getClass().getSimpleName().length() + 1))).endsWith("]")) {
                string = ((String)string).substring(0, ((String)string).length() - 1);
            }
            if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                if (bytes.length > 0) {
                    int max = Integer.min(10, bytes.length);
                    Object formatHex = HexFormat.ofDelimiter("").formatHex(bytes, 0, max);
                    if (max < bytes.length) {
                        formatHex = (String)formatHex + "...";
                    }
                    string = "[#" + (String)formatHex + "]";
                } else {
                    string = "[]";
                }
            }
            return string;
        }

        public String formatColumnValue(VColumn<T> var1, Object var2);
    }

    public static interface RowStyler<T> {
        public void styleRow(T var1, Style var2);
    }
}

